/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import schemacrawler.schema.Property;
import sf.util.Utility;

abstract class AbstractProperty
implements Property {
    private static final long serialVersionUID = -7150431683440256142L;
    private final String name;
    private final Serializable value;

    AbstractProperty(String name, Serializable value) {
        if (Utility.isBlank(name)) {
            throw new IllegalArgumentException("No property name provided");
        }
        this.name = name.trim();
        this.value = value != null && value.getClass().isArray() ? (Serializable)((Object)Arrays.asList((Object[])value)) : value;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Property)) {
            return false;
        }
        Property other = (Property)obj;
        return Objects.equals(this.name, other.getName()) && Objects.equals(this.value, other.getValue());
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public Serializable getValue() {
        return this.value;
    }

    public final int hashCode() {
        return Objects.hash(this.name, this.value);
    }
}

