/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MetadataRetrievalStrategy;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableFunction;
import schemacrawler.crawl.MutableFunctionColumn;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.schema.FunctionColumn;
import schemacrawler.schema.FunctionColumnType;
import schemacrawler.schema.RoutineType;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import schemacrawler.utility.Query;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

final class FunctionColumnRetriever
extends AbstractRetriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(FunctionColumnRetriever.class.getName());

    FunctionColumnRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveFunctionColumns(NamedObjectList<MutableRoutine> allRoutines, InclusionRule columnInclusionRule) throws SQLException {
        Objects.requireNonNull(allRoutines, "No functions provided");
        InclusionRuleFilter<FunctionColumn> columnFilter = new InclusionRuleFilter<FunctionColumn>(columnInclusionRule, true);
        if (columnFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving function columns, since this was not requested");
            return;
        }
        MetadataRetrievalStrategy functionColumnRetrievalStrategy = this.getRetrieverConnection().getFunctionColumnRetrievalStrategy();
        switch (functionColumnRetrievalStrategy) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving function columns, using fast data dictionary retrieval");
                this.retrieveFunctionColumnsFromDataDictionary(allRoutines, columnFilter);
                break;
            }
            case metadata_all: {
                LOGGER.log(Level.INFO, "Retrieving function columns, using fast meta-data retrieval");
                this.retrieveFunctionColumnsFromMetadataForAllFunctions(allRoutines, columnFilter);
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving function columns");
                this.retrieveFunctionColumnsFromMetadata(allRoutines, columnFilter);
                break;
            }
        }
    }

    private void createFunctionColumn(MetadataResultSet results, NamedObjectList<MutableRoutine> allRoutines, InclusionRuleFilter<FunctionColumn> columnFilter) {
        String columnCatalogName = this.normalizeCatalogName(results.getString("FUNCTION_CAT"));
        String schemaName = this.normalizeSchemaName(results.getString("FUNCTION_SCHEM"));
        String functionName = results.getString("FUNCTION_NAME");
        String columnName = results.getString("COLUMN_NAME");
        String specificName = results.getString("SPECIFIC_NAME");
        LOGGER.log(Level.FINE, new StringFormat("Retrieving function column <%s.%s.%s.%s.%s>", columnCatalogName, schemaName, functionName, specificName, columnName));
        if (Utility.isBlank(columnName)) {
            return;
        }
        Optional<MutableRoutine> optionalRoutine = allRoutines.lookup(Arrays.asList(columnCatalogName, schemaName, functionName, specificName));
        if (!optionalRoutine.isPresent()) {
            return;
        }
        MutableRoutine routine = optionalRoutine.get();
        if (routine.getRoutineType() != RoutineType.function) {
            return;
        }
        MutableFunction function = (MutableFunction)routine;
        MutableFunctionColumn column = this.lookupOrCreateFunctionColumn(function, columnName);
        if (columnFilter.test(column) && this.belongsToSchema(function, columnCatalogName, schemaName)) {
            FunctionColumnType columnType = results.getEnumFromShortId("COLUMN_TYPE", FunctionColumnType.unknown);
            int ordinalPosition = results.getInt("ORDINAL_POSITION", 0);
            int dataType = results.getInt("DATA_TYPE", 0);
            String typeName = results.getString("TYPE_NAME");
            int length = results.getInt("LENGTH", 0);
            int precision = results.getInt("PRECISION", 0);
            boolean isNullable = results.getShort("NULLABLE", (short)2) == 1;
            String remarks = results.getString("REMARKS");
            column.setOrdinalPosition(ordinalPosition);
            column.setFunctionColumnType(columnType);
            column.setColumnDataType(this.lookupOrCreateColumnDataType(function.getSchema(), dataType, typeName));
            column.setSize(length);
            column.setPrecision(precision);
            column.setNullable(isNullable);
            column.setRemarks(remarks);
            column.addAttributes(results.getAttributes());
            LOGGER.log(Level.FINER, new StringFormat("Adding column to function <%s>", column.getFullName()));
            function.addColumn(column);
        }
    }

    private MutableFunctionColumn lookupOrCreateFunctionColumn(MutableFunction function, String columnName) {
        Optional<MutableFunctionColumn> columnOptional = function.lookupColumn(columnName);
        MutableFunctionColumn column = columnOptional.isPresent() ? columnOptional.get() : new MutableFunctionColumn(function, columnName);
        return column;
    }

    private void retrieveFunctionColumnsFromDataDictionary(NamedObjectList<MutableRoutine> allRoutines, InclusionRuleFilter<FunctionColumn> columnFilter) throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.FUNCTION_COLUMNS)) {
            throw new SchemaCrawlerSQLException("No function columns SQL provided", null);
        }
        Query functionColumnsSql = informationSchemaViews.getQuery(InformationSchemaKey.FUNCTION_COLUMNS);
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(functionColumnsSql, statement, this.getSchemaInclusionRule());){
            results.setDescription("retrieveFunctionColumnsFromDataDictionary");
            while (results.next()) {
                this.createFunctionColumn(results, allRoutines, columnFilter);
            }
        }
    }

    private void retrieveFunctionColumnsFromMetadata(NamedObjectList<MutableRoutine> allRoutines, InclusionRuleFilter<FunctionColumn> columnFilter) throws SchemaCrawlerSQLException {
        for (MutableRoutine routine : allRoutines) {
            if (routine.getRoutineType() != RoutineType.function) continue;
            MutableFunction function = (MutableFunction)routine;
            LOGGER.log(Level.FINE, "Retrieving function columns for " + function);
            try {
                MetadataResultSet results = new MetadataResultSet(this.getMetaData().getFunctionColumns(function.getSchema().getCatalogName(), function.getSchema().getName(), function.getName(), null));
                Throwable throwable = null;
                try {
                    while (results.next()) {
                        this.createFunctionColumn(results, allRoutines, columnFilter);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (results == null) continue;
                    if (throwable != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    results.close();
                }
            }
            catch (AbstractMethodError | SQLFeatureNotSupportedException e) {
                this.logSQLFeatureNotSupported(new StringFormat("Could not retrieve columns for function %s", function), e);
            }
            catch (SQLException e) {
                this.logPossiblyUnsupportedSQLFeature(new StringFormat("Could not retrieve columns for function %s", function), e);
            }
        }
    }

    private void retrieveFunctionColumnsFromMetadataForAllFunctions(NamedObjectList<MutableRoutine> allRoutines, InclusionRuleFilter<FunctionColumn> columnFilter) throws SQLException {
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getFunctionColumns(null, null, "%", "%"));){
            while (results.next()) {
                this.createFunctionColumn(results, allRoutines, columnFilter);
            }
        }
        catch (AbstractMethodError | SQLFeatureNotSupportedException e) {
            this.logSQLFeatureNotSupported(new StringFormat("Could not retrieve columns for functions", new Object[0]), e);
        }
        catch (SQLException e) {
            this.logPossiblyUnsupportedSQLFeature(new StringFormat("Could not retrieve columns for functions", new Object[0]), e);
        }
    }
}

