/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.commandline.BaseDatabaseConnectionOptionsParser;

final class BundledDriverConnectionOptionsParser
extends BaseDatabaseConnectionOptionsParser {
    private static final String URLX = "urlx";
    private static final String DATABASE = "database";
    private static final String PORT = "port";
    private static final String HOST = "host";

    BundledDriverConnectionOptionsParser(Config config) {
        super(config);
    }

    @Override
    public void loadConfig() throws SchemaCrawlerException {
        super.loadConfig();
        if (this.config.hasValue(HOST)) {
            this.config.put(HOST, this.config.getStringValue(HOST, ""));
        }
        if (this.config.hasValue(PORT)) {
            this.config.put(PORT, String.valueOf(this.config.getIntegerValue(PORT, 0)));
        }
        if (this.config.hasValue(DATABASE)) {
            this.config.put(DATABASE, this.config.getStringValue(DATABASE, ""));
        }
        if (this.config.hasValue(URLX)) {
            this.config.put(URLX, this.config.getStringValue(URLX, ""));
        }
    }
}

