/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.JvmSystemInfo;
import schemacrawler.OperatingSystemInfo;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.commandline.CommandLine;
import schemacrawler.tools.commandline.CommandParser;
import schemacrawler.tools.commandline.DatabaseServerTypeParser;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.DatabaseConnectorRegistry;
import schemacrawler.tools.executable.CommandDescription;
import schemacrawler.tools.executable.CommandRegistry;
import schemacrawler.tools.iosource.ClasspathInputResource;
import schemacrawler.tools.iosource.InputResource;
import sf.util.IOUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.Utility;

public final class SchemaCrawlerHelpCommandLine
implements CommandLine {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(SchemaCrawlerHelpCommandLine.class.getName());
    private final PrintWriter out;
    private final String command;
    private final boolean showVersionOnly;
    private final InputResource connectionHelpResource;
    private final DatabaseServerType dbServerType;

    public SchemaCrawlerHelpCommandLine(Config argsMap, boolean showVersionOnly) throws SchemaCrawlerException {
        Objects.requireNonNull(argsMap, "No command-line arguments provided");
        DatabaseServerTypeParser dbServerTypeParser = new DatabaseServerTypeParser(argsMap);
        DatabaseConnector dbConnector = dbServerTypeParser.getOptions();
        this.connectionHelpResource = dbConnector.getConnectionHelpResource();
        this.dbServerType = dbConnector.getDatabaseServerType();
        this.showVersionOnly = showVersionOnly;
        this.out = new PrintWriter(System.out);
        String command = null;
        if (!argsMap.isEmpty()) {
            CommandParser parser = new CommandParser(argsMap);
            if (parser.hasOptions()) {
                command = parser.getOptions().toString();
            }
            if (Utility.isBlank(command)) {
                command = null;
            }
        }
        this.command = command;
    }

    @Override
    public void execute() throws SchemaCrawlerException {
        CommandRegistry commandRegistry = new CommandRegistry();
        if (this.dbServerType != null && !this.dbServerType.isUnknownDatabaseSystem()) {
            this.out.println("SchemaCrawler for " + this.dbServerType.getDatabaseSystemName());
        }
        this.printHelpText("/help/SchemaCrawler.txt");
        this.out.println();
        if (this.showVersionOnly) {
            this.out.println(new JvmSystemInfo());
            this.out.println(new OperatingSystemInfo());
            this.out.flush();
            return;
        }
        if (this.connectionHelpResource == null) {
            DatabaseConnectorRegistry databaseConnectorRegistry = new DatabaseConnectorRegistry();
            this.printHelpText("/help/Connections.txt");
            this.out.println("Available servers are: ");
            for (DatabaseServerType availableServer : databaseConnectorRegistry) {
                this.out.println("  " + availableServer);
            }
            this.out.println();
        } else {
            this.printHelpText(this.connectionHelpResource);
        }
        this.printHelpText("/help/SchemaCrawlerOptions.txt");
        this.printHelpText("/help/Config.txt");
        this.printHelpText("/help/ApplicationOptions.txt");
        if (!commandRegistry.isCommandSupported(this.command)) {
            this.printHelpText("/help/Command.txt");
            this.out.println("  Available commands are: ");
            for (CommandDescription availableCommand : commandRegistry) {
                this.out.println("    " + availableCommand);
            }
            this.out.println();
        } else {
            this.printHelpText(commandRegistry.getHelp(this.command));
        }
        this.out.flush();
    }

    public final String getCommand() {
        return this.command;
    }

    private void printHelpText(InputResource helpResource) {
        if (helpResource == null) {
            return;
        }
        try (Reader helpReader = helpResource.openNewInputReader(StandardCharsets.UTF_8);){
            IOUtility.copy(helpReader, this.out);
            this.out.println();
            this.out.flush();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, String.format("Could not print help from resource <%s>", helpResource), (Throwable)e);
        }
    }

    private void printHelpText(String helpClaspathResource) {
        try {
            this.printHelpText(new ClasspathInputResource(helpClaspathResource));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, String.format("Could not find help resource <%s>", helpClaspathResource), (Throwable)e);
        }
    }
}

