/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.util.logging.Level;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.InfoLevel;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import schemacrawler.tools.commandline.BaseOptionsParser;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

public final class SchemaCrawlerOptionsParser
extends BaseOptionsParser<SchemaCrawlerOptions> {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(SchemaCrawlerOptionsParser.class.getName());
    private static final String DEFAULT_TABLE_TYPES = "TABLE,VIEW";
    private static final String DEFAULT_ROUTINE_TYPES = "PROCEDURE,FUNCTION";
    private final SchemaCrawlerOptionsBuilder optionsBuilder;

    public SchemaCrawlerOptionsParser(Config config) {
        super(config);
        this.normalizeOptionName("title", new String[0]);
        this.normalizeOptionName("infolevel", "i");
        this.normalizeOptionName("schemas", new String[0]);
        this.normalizeOptionName("tabletypes", new String[0]);
        this.normalizeOptionName("tables", new String[0]);
        this.normalizeOptionName("excludecolumns", new String[0]);
        this.normalizeOptionName("synonyms", new String[0]);
        this.normalizeOptionName("sequences", new String[0]);
        this.normalizeOptionName("routinetypes", new String[0]);
        this.normalizeOptionName("routines", new String[0]);
        this.normalizeOptionName("excludeinout", new String[0]);
        this.normalizeOptionName("grepcolumns", new String[0]);
        this.normalizeOptionName("grepinout", new String[0]);
        this.normalizeOptionName("grepdef", new String[0]);
        this.normalizeOptionName("invert-match", new String[0]);
        this.normalizeOptionName("only-matching", new String[0]);
        this.normalizeOptionName("noemptytables", "hideemptytables");
        this.normalizeOptionName("parents", new String[0]);
        this.normalizeOptionName("children", new String[0]);
        this.optionsBuilder = SchemaCrawlerOptionsBuilder.builder().fromConfig(config);
    }

    @Override
    public SchemaCrawlerOptions getOptions() throws SchemaCrawlerException {
        if (this.config.hasValue("title")) {
            this.optionsBuilder.title(this.config.getStringValue("title", ""));
            this.consumeOption("title");
        }
        SchemaInfoLevelBuilder schemaInfoLevelBuilder = SchemaInfoLevelBuilder.builder().fromConfig(this.config);
        if (this.config.hasValue("infolevel")) {
            InfoLevel infoLevel = this.config.getEnumValue("infolevel", InfoLevel.standard);
            schemaInfoLevelBuilder.withInfoLevel(infoLevel);
            this.consumeOption("infolevel");
        } else {
            schemaInfoLevelBuilder.withInfoLevel(InfoLevel.standard);
        }
        this.optionsBuilder.withSchemaInfoLevel(schemaInfoLevelBuilder);
        if (this.config.hasValue("schemas")) {
            InclusionRule schemaInclusionRule = this.config.getInclusionRule("schemas");
            this.logOverride("schemas", schemaInclusionRule);
            this.optionsBuilder.includeSchemas(schemaInclusionRule);
            this.consumeOption("schemas");
        } else {
            LOGGER.log(Level.WARNING, "Please provide a -schemas option for efficient retrieval of database metadata");
        }
        if (this.config.hasValue("tabletypes")) {
            String tabletypes = this.config.getStringValue("tabletypes", DEFAULT_TABLE_TYPES);
            if (!Utility.isBlank(tabletypes)) {
                this.optionsBuilder.tableTypes(tabletypes);
            } else {
                this.optionsBuilder.tableTypes((String)null);
            }
            this.consumeOption("tabletypes");
        }
        if (this.config.hasValue("tables")) {
            InclusionRule tableInclusionRule = this.config.getInclusionRule("tables");
            this.logOverride("tables", tableInclusionRule);
            this.optionsBuilder.includeTables(tableInclusionRule);
            this.consumeOption("tables");
        }
        if (this.config.hasValue("excludecolumns")) {
            InclusionRule columnInclusionRule = this.config.getExclusionRule("excludecolumns");
            this.logOverride("excludecolumns", columnInclusionRule);
            this.optionsBuilder.includeColumns(columnInclusionRule);
            this.consumeOption("excludecolumns");
        }
        if (this.config.hasValue("routinetypes")) {
            this.optionsBuilder.routineTypes(this.config.getStringValue("routinetypes", DEFAULT_ROUTINE_TYPES));
            this.consumeOption("routinetypes");
        }
        if (this.config.hasValue("routines")) {
            InclusionRule routineInclusionRule = this.config.getInclusionRule("routines");
            this.logOverride("routines", routineInclusionRule);
            this.optionsBuilder.includeRoutines(routineInclusionRule);
            this.consumeOption("routines");
        }
        if (this.config.hasValue("excludeinout")) {
            InclusionRule routineColumnInclusionRule = this.config.getExclusionRule("excludeinout");
            this.logOverride("excludeinout", routineColumnInclusionRule);
            this.optionsBuilder.includeRoutineColumns(routineColumnInclusionRule);
            this.consumeOption("excludeinout");
        }
        if (this.config.hasValue("synonyms")) {
            InclusionRule synonymInclusionRule = this.config.getInclusionRule("synonyms");
            this.logOverride("synonyms", synonymInclusionRule);
            this.optionsBuilder.includeSynonyms(synonymInclusionRule);
            this.consumeOption("synonyms");
        }
        if (this.config.hasValue("sequences")) {
            InclusionRule sequenceInclusionRule = this.config.getInclusionRule("sequences");
            this.logOverride("sequences", sequenceInclusionRule);
            this.optionsBuilder.includeSequences(sequenceInclusionRule);
            this.consumeOption("sequences");
        }
        if (this.config.hasValue("invert-match")) {
            this.optionsBuilder.invertGrepMatch(this.config.getBooleanValue("invert-match", true));
            this.consumeOption("invert-match");
        }
        if (this.config.hasValue("only-matching")) {
            this.optionsBuilder.grepOnlyMatching(this.config.getBooleanValue("only-matching", true));
            this.consumeOption("only-matching");
        }
        if (this.config.hasValue("grepcolumns")) {
            InclusionRule grepColumnInclusionRule = this.config.getInclusionRule("grepcolumns");
            this.optionsBuilder.includeGreppedColumns(grepColumnInclusionRule);
            this.consumeOption("grepcolumns");
        } else {
            this.optionsBuilder.includeGreppedColumns(null);
        }
        if (this.config.hasValue("grepinout")) {
            InclusionRule grepRoutineColumnInclusionRule = this.config.getInclusionRule("grepinout");
            this.optionsBuilder.includeGreppedRoutineColumns(grepRoutineColumnInclusionRule);
            this.consumeOption("grepinout");
        } else {
            this.optionsBuilder.includeGreppedRoutineColumns(null);
        }
        if (this.config.hasValue("grepdef")) {
            InclusionRule grepDefinitionInclusionRule = this.config.getInclusionRule("grepdef");
            this.optionsBuilder.includeGreppedDefinitions(grepDefinitionInclusionRule);
            this.consumeOption("grepdef");
        } else {
            this.optionsBuilder.includeGreppedDefinitions(null);
        }
        if (this.config.hasValue("noemptytables")) {
            boolean noEmptyTables = this.config.getBooleanValue("noemptytables", true);
            if (noEmptyTables) {
                this.optionsBuilder.noEmptyTables();
            }
            this.consumeOption("noemptytables");
        }
        if (this.config.hasValue("parents")) {
            int parentTableFilterDepth = this.config.getIntegerValue("parents", 0);
            this.optionsBuilder.parentTableFilterDepth(parentTableFilterDepth);
            this.consumeOption("parents");
        } else {
            this.optionsBuilder.parentTableFilterDepth(0);
        }
        if (this.config.hasValue("children")) {
            int childTableFilterDepth = this.config.getIntegerValue("children", 0);
            this.optionsBuilder.childTableFilterDepth(childTableFilterDepth);
            this.consumeOption("children");
        } else {
            this.optionsBuilder.childTableFilterDepth(0);
        }
        return this.optionsBuilder.toOptions();
    }

    private void logOverride(String inclusionRuleName, InclusionRule schemaInclusionRule) {
        LOGGER.log(Level.INFO, new StringFormat("Overriding %s inclusion rule from command-line to %s", inclusionRuleName, schemaInclusionRule));
    }
}

