/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.databaseconnector;

import java.sql.Connection;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.schemacrawler.InformationSchemaViewsBuilder;
import schemacrawler.schemacrawler.Options;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.tools.databaseconnector.BaseDatabaseConnectionOptions;
import schemacrawler.tools.databaseconnector.ConnectionOptions;
import schemacrawler.tools.databaseconnector.DatabaseConfigConnectionOptions;
import schemacrawler.tools.databaseconnector.DatabaseConnectionOptions;
import schemacrawler.tools.databaseconnector.SingleUseUserCredentials;
import schemacrawler.tools.databaseconnector.UserCredentials;
import schemacrawler.tools.iosource.InputResource;
import schemacrawler.utility.PropertiesUtility;
import sf.util.Utility;

public abstract class DatabaseConnector
implements Options {
    protected static final DatabaseConnector UNKNOWN = new DatabaseConnector(){};
    private final DatabaseServerType dbServerType;
    private final InputResource connectionHelpResource;
    private final InputResource configResource;
    private final BiConsumer<InformationSchemaViewsBuilder, Connection> informationSchemaViewsBuilderForConnection;
    private final Predicate<String> supportsUrlPredicate;

    protected DatabaseConnector(DatabaseServerType dbServerType, InputResource connectionHelpResource, InputResource configResource, BiConsumer<InformationSchemaViewsBuilder, Connection> informationSchemaViewsBuilderForConnection, Predicate<String> supportsUrlPredicate) {
        this.dbServerType = Objects.requireNonNull(dbServerType, "No database server type provided");
        this.connectionHelpResource = Objects.requireNonNull(connectionHelpResource, "No connection help provided");
        this.configResource = Objects.requireNonNull(configResource, "No config resource provided");
        this.informationSchemaViewsBuilderForConnection = informationSchemaViewsBuilderForConnection;
        this.supportsUrlPredicate = Objects.requireNonNull(supportsUrlPredicate, "No database connection URL predicate provided");
    }

    private DatabaseConnector() {
        this.dbServerType = DatabaseServerType.UNKNOWN;
        this.connectionHelpResource = null;
        this.configResource = null;
        this.informationSchemaViewsBuilderForConnection = null;
        this.supportsUrlPredicate = url -> false;
    }

    public final Config getConfig() {
        if (this.configResource == null) {
            return new Config();
        }
        return PropertiesUtility.loadConfig(this.configResource);
    }

    public InputResource getConnectionHelpResource() {
        return this.connectionHelpResource;
    }

    public DatabaseServerType getDatabaseServerType() {
        return this.dbServerType;
    }

    public SchemaRetrievalOptionsBuilder getSchemaRetrievalOptionsBuilder(Connection connection) {
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaRetrievalOptionsBuilder.builder().withDatabaseServerType(this.dbServerType).withInformationSchemaViewsForConnection(this.informationSchemaViewsBuilderForConnection, connection).fromConnnection(connection);
        return schemaRetrievalOptionsBuilder;
    }

    public boolean isUnknownDatabaseSystem() {
        return this.dbServerType.isUnknownDatabaseSystem();
    }

    public ConnectionOptions newDatabaseConnectionOptions(UserCredentials userCredentials, Config additionalConfig) throws SchemaCrawlerException {
        Objects.requireNonNull(userCredentials, "No database connection user credentials provided");
        Config config = this.getConfig();
        if (additionalConfig != null) {
            config.putAll(additionalConfig);
            additionalConfig.remove("user");
            additionalConfig.remove("password");
        }
        BaseDatabaseConnectionOptions connectionOptions = this.dbServerType.isUnknownDatabaseSystem() || config.hasValue("url") ? new DatabaseConnectionOptions(userCredentials, config) : new DatabaseConfigConnectionOptions(userCredentials, config);
        return connectionOptions;
    }

    public final boolean supportsUrl(String url) {
        if (Utility.isBlank(url)) {
            return false;
        }
        return this.supportsUrlPredicate.test(url);
    }

    public String toString() {
        return "Database connector for " + this.dbServerType;
    }

    void checkDatabaseConnectionOptions() throws SchemaCrawlerException {
        this.newDatabaseConnectionOptions(new SingleUseUserCredentials(), null);
    }
}

