/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.embeddedgraph;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.regex.Pattern;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.executable.CommandChain;
import schemacrawler.tools.integration.graph.GraphOutputFormat;
import schemacrawler.tools.integration.graph.GraphvizJavaExecutorUtility;
import schemacrawler.tools.integration.graph.GraphvizUtility;
import schemacrawler.tools.options.TextOutputFormat;
import sf.util.IOUtility;

public class EmbeddedGraphRenderer
extends BaseSchemaCrawlerCommand {
    private static Pattern svgInsertionPoint = Pattern.compile("<h2.*Tables.*h2>");
    private static Pattern svgStart = Pattern.compile("<svg.*");

    public EmbeddedGraphRenderer(String command) {
        super(command);
    }

    @Override
    public void checkAvailibility() throws Exception {
        if (GraphvizUtility.isGraphvizAvailable()) {
            return;
        }
        if (GraphvizJavaExecutorUtility.isGraphvizJavaAvailable(GraphOutputFormat.svg)) {
            return;
        }
        throw new SchemaCrawlerException("Cannot generate graph in SVG format");
    }

    @Override
    public void execute() throws Exception {
        this.checkCatalog();
        Path finalHtmlFile = IOUtility.createTempFilePath("schemacrawler", "html");
        Path baseHtmlFile = IOUtility.createTempFilePath("schemacrawler", "html");
        Path baseSvgFile = IOUtility.createTempFilePath("schemacrawler", "svg");
        CommandChain chain = new CommandChain(this);
        chain.addNext(this.command, TextOutputFormat.html, baseHtmlFile);
        chain.addNext(this.command, GraphOutputFormat.svg, baseSvgFile);
        chain.execute();
        try (BufferedWriter finalHtmlFileWriter = Files.newBufferedWriter(finalHtmlFile, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
             BufferedReader baseHtmlFileReader = Files.newBufferedReader(baseHtmlFile, StandardCharsets.UTF_8);
             BufferedReader baseSvgFileReader = Files.newBufferedReader(baseSvgFile, StandardCharsets.UTF_8);){
            String line;
            while ((line = baseHtmlFileReader.readLine()) != null) {
                if (svgInsertionPoint.matcher(line).matches()) {
                    this.insertSvg(finalHtmlFileWriter, baseSvgFileReader);
                }
                finalHtmlFileWriter.append(line).append(System.lineSeparator());
            }
        }
        var6_6 = null;
        try (Writer writer = this.outputOptions.openNewOutputWriter();){
            IOUtility.copy(Files.newBufferedReader(finalHtmlFile, StandardCharsets.UTF_8), writer);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    @Override
    public boolean usesConnection() {
        return false;
    }

    private void insertSvg(BufferedWriter finalHtmlFileWriter, BufferedReader baseSvgFileReader) throws IOException {
        String line;
        finalHtmlFileWriter.append(System.lineSeparator());
        boolean skipLines = true;
        boolean isSvgStart = false;
        while ((line = baseSvgFileReader.readLine()) != null) {
            if (skipLines) {
                isSvgStart = svgStart.matcher(line).matches();
                boolean bl = skipLines = !isSvgStart;
            }
            if (skipLines) continue;
            if (isSvgStart) {
                line = "<svg";
                isSvgStart = false;
            }
            finalHtmlFileWriter.append(line).append(System.lineSeparator());
        }
        finalHtmlFileWriter.append(System.lineSeparator());
    }
}

