/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.util.List;
import java.util.logging.Level;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputFormatState;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

public enum GraphOutputFormat implements OutputFormat
{
    htmlx("SchemaCrawler graph embedded in HTML5"),
    scdot("SchemaCrawler generated format"),
    bmp("Windows Bitmap Format"),
    canon("DOT"),
    dot("DOT"),
    gv("DOT"),
    xdot("DOT", "xdot1.2", "xdot1.4"),
    cgimage("CGImage bitmap format"),
    cmap("Client-side imagemap (deprecated)"),
    eps("Encapsulated PostScript"),
    exr("OpenEXR"),
    fig("FIG"),
    gd("GD/GD2 formats", "gd2"),
    gif("GIF"),
    gtk("GTK canvas"),
    ico("Icon Image File Format"),
    imap("Server-side and client-side imagemaps", "cmapx", "imap_np", "cmapx_np"),
    jp2("JPEG 2000"),
    jpg("JPEG", "jpeg", "jpe"),
    pct("PICT", "pict"),
    pdf("Portable Document Format (PDF)"),
    pic("Kernighan's PIC graphics language"),
    plain("Simple text format", "plain-ext"),
    png("Portable Network Graphics format"),
    pov("POV-Ray markup language (prototype)"),
    ps("PostScript"),
    ps2("PostScript for PDF"),
    psd("PSD"),
    sgi("SGI"),
    svg("Scalable Vector Graphics"),
    svgz("Scalable Vector Graphics"),
    tga("Truevision TGA"),
    tiff("TIFF (Tag Image File Format)", "tif"),
    tk("TK graphics"),
    vml("Vector Markup Language (VML)"),
    vmlz("Vector Markup Language (VML)"),
    vrml("VRML"),
    wbmp("Wireless BitMap format"),
    webp("Image format for the Web"),
    xlib("Xlib canvas", "x11");

    private static final SchemaCrawlerLogger LOGGER;
    private final OutputFormatState outputFormatState;

    public static GraphOutputFormat fromFormat(String format) {
        GraphOutputFormat outputFormat = GraphOutputFormat.fromFormatOrNull(format);
        if (outputFormat == null) {
            LOGGER.log(Level.CONFIG, new StringFormat("Unknown format <%s>, using default", format));
            return png;
        }
        return outputFormat;
    }

    public static boolean isSupportedFormat(String format) {
        return GraphOutputFormat.fromFormatOrNull(format) != null;
    }

    private static GraphOutputFormat fromFormatOrNull(String format) {
        if (Utility.isBlank(format)) {
            return null;
        }
        for (GraphOutputFormat outputFormat : GraphOutputFormat.values()) {
            if (!outputFormat.outputFormatState.isSupportedFormat(format)) continue;
            return outputFormat;
        }
        return null;
    }

    private GraphOutputFormat(String description) {
        this.outputFormatState = new OutputFormatState(this.name(), description, new String[0]);
    }

    private GraphOutputFormat(String description, String ... additionalFormatSpecifiers) {
        this.outputFormatState = new OutputFormatState(this.name(), description, additionalFormatSpecifiers);
    }

    @Override
    public String getDescription() {
        return this.outputFormatState.getDescription();
    }

    @Override
    public String getFormat() {
        return this.outputFormatState.getFormat();
    }

    @Override
    public List<String> getFormats() {
        return this.outputFormatState.getFormats();
    }

    public String toString() {
        return this.outputFormatState.toString();
    }

    static {
        LOGGER = SchemaCrawlerLogger.getLogger(GraphOutputFormat.class.getName());
    }
}

