/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.serialization;

import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.integration.serialization.JavaSerializedCatalog;

public final class SerializationCommand
extends BaseSchemaCrawlerCommand {
    static final String COMMAND = "serialize";

    public SerializationCommand() {
        this(COMMAND);
    }

    public SerializationCommand(String command) {
        super(command);
    }

    @Override
    public void checkAvailibility() throws Exception {
    }

    @Override
    public void execute() throws Exception {
        this.checkCatalog();
        Path outputFile = this.outputOptions.getOutputFile().orElseGet(() -> Paths.get(".", String.format("schemacrawler-%s.%s", UUID.randomUUID(), "data"))).normalize().toAbsolutePath();
        JavaSerializedCatalog serializableCatalog = new JavaSerializedCatalog(this.catalog);
        try (OutputStream out = Files.newOutputStream(outputFile, new OpenOption[0]);){
            serializableCatalog.save(out);
        }
    }

    @Override
    public boolean usesConnection() {
        return false;
    }
}

