/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.options;

import java.util.ArrayList;
import java.util.List;
import schemacrawler.tools.options.OutputFormat;
import sf.util.Utility;

public final class OutputFormatState
implements OutputFormat {
    private final List<String> formatSpecifiers;
    private final String description;

    public OutputFormatState(String formatSpecifier, String description, String ... additionalFormatSpecifiers) {
        if (Utility.isBlank(formatSpecifier)) {
            throw new IllegalArgumentException("No formation provided");
        }
        if (Utility.isBlank(description)) {
            throw new IllegalArgumentException("No description provided");
        }
        this.description = description;
        this.formatSpecifiers = new ArrayList<String>();
        this.formatSpecifiers.add(formatSpecifier);
        if (additionalFormatSpecifiers != null) {
            for (String additionalFormatSpecifier : additionalFormatSpecifiers) {
                if (Utility.isBlank(additionalFormatSpecifier)) continue;
                this.formatSpecifiers.add(additionalFormatSpecifier);
            }
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getFormat() {
        return this.formatSpecifiers.get(0);
    }

    @Override
    public List<String> getFormats() {
        return new ArrayList<String>(this.formatSpecifiers);
    }

    public boolean isSupportedFormat(String format) {
        for (String formatSpecifier : this.formatSpecifiers) {
            if (!formatSpecifier.equalsIgnoreCase(format)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("%s %s", this.formatSpecifiers, this.description);
    }
}

