/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.base;

import java.util.Map;
import schemacrawler.SchemaCrawlerInfo;
import schemacrawler.schema.CrawlInfo;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.integration.graph.GraphOptions;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.TextOutputFormat;
import schemacrawler.tools.text.base.BaseFormatter;
import schemacrawler.tools.text.utility.html.Alignment;
import schemacrawler.tools.text.utility.html.TableCell;
import schemacrawler.tools.text.utility.html.TableRow;
import sf.util.Color;
import sf.util.IOUtility;
import sf.util.Utility;

public abstract class BaseDotFormatter
extends BaseFormatter<GraphOptions> {
    protected BaseDotFormatter(GraphOptions options, boolean printVerboseDatabaseInfo, OutputOptions outputOptions, String identifierQuoteString) throws SchemaCrawlerException {
        super(options, printVerboseDatabaseInfo, outputOptions, identifierQuoteString);
    }

    @Override
    public void begin() {
        String header = this.makeGraphvizHeader();
        this.formattingHelper.append(header).println();
    }

    @Override
    public void end() throws SchemaCrawlerException {
        this.formattingHelper.append("}").println();
        super.end();
    }

    @Override
    public void handle(CrawlInfo crawlInfo) {
        TableRow row;
        if (((GraphOptions)this.options).isNoInfo() || crawlInfo == null) {
            return;
        }
        String title = crawlInfo.getTitle();
        if (!Utility.isBlank(title)) {
            row = new TableRow(TextOutputFormat.html);
            row.add(this.newTableCell(title, Alignment.left, true, Color.white, 2));
            this.formattingHelper.append(row.toString()).println();
        }
        if (!((GraphOptions)this.options).isNoSchemaCrawlerInfo()) {
            row = new TableRow(TextOutputFormat.html);
            row.add(this.newTableCell("generated by", Alignment.right, false, Color.white, 1));
            row.add(this.newTableCell(crawlInfo.getSchemaCrawlerInfo(), Alignment.left, false, Color.white, 1));
            this.formattingHelper.append(row.toString()).println();
            row = new TableRow(TextOutputFormat.html);
            row.add(this.newTableCell("generated on", Alignment.right, false, Color.white, 1));
            row.add(this.newTableCell(this.formatTimestamp(crawlInfo.getCrawlTimestamp()), Alignment.left, false, Color.white, 1));
            this.formattingHelper.append(row.toString()).println();
        }
        if (((GraphOptions)this.options).isShowDatabaseInfo()) {
            row = new TableRow(TextOutputFormat.html);
            row.add(this.newTableCell("database version", Alignment.right, false, Color.white, 1));
            row.add(this.newTableCell(crawlInfo.getDatabaseInfo(), Alignment.left, false, Color.white, 1));
            this.formattingHelper.append(row.toString()).println();
        }
    }

    @Override
    public void handle(DatabaseInfo dbInfo) {
    }

    @Override
    public void handle(JdbcDriverInfo driverInfo) {
    }

    @Override
    public void handle(SchemaCrawlerInfo schemaCrawlerInfo) {
    }

    @Override
    public void handleHeaderEnd() throws SchemaCrawlerException {
        if (((GraphOptions)this.options).isNoInfo()) {
            return;
        }
        this.formattingHelper.append("      </table>").println();
        this.formattingHelper.append("    >").println();
        this.formattingHelper.append("  ];").println();
        this.formattingHelper.println();
    }

    @Override
    public void handleHeaderStart() throws SchemaCrawlerException {
        if (((GraphOptions)this.options).isNoInfo()) {
            return;
        }
        this.formattingHelper.append("  /* ").append("Title Block").append(" -=-=-=-=-=-=-=-=-=-=-=-=-=- */").println();
        this.formattingHelper.append("  graph [ ").println();
        this.formattingHelper.append("    label=<").println();
        this.formattingHelper.append("      <table border=\"1\" cellborder=\"0\" cellspacing=\"0\" color=\"#888888\">").println();
    }

    @Override
    public void handleInfoEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleInfoStart() throws SchemaCrawlerException {
    }

    protected TableCell newTableCell(String text, Alignment align, boolean emphasizeText, Color bgColor, int colspan) {
        return new TableCell(text, true, 0, align, emphasizeText, "", bgColor, colspan, TextOutputFormat.html);
    }

    private String makeGraphvizAttributes(Map<String, String> graphvizAttributes, String prefix) {
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<String, String> entry : graphvizAttributes.entrySet()) {
            String[] key = entry.getKey().split("\\.");
            if (key.length != 2 || !key[0].equals(prefix)) continue;
            buffer.append("    ").append(key[1]).append("=").append("\"").append(entry.getValue()).append("\"").append("\n");
        }
        return buffer.toString();
    }

    private String makeGraphvizHeader() {
        Map<String, String> graphvizAttributes = ((GraphOptions)this.options).getGraphvizAttributes();
        String graphvizHeaderTemplate = IOUtility.readResourceFully("/dot.header.txt");
        String graphvizHeader = String.format(graphvizHeaderTemplate, this.makeGraphvizAttributes(graphvizAttributes, "graph"), this.makeGraphvizAttributes(graphvizAttributes, "node"), this.makeGraphvizAttributes(graphvizAttributes, "edge"));
        return graphvizHeader;
    }
}

