/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.io.Serializable;
import java.util.Set;
import sf.util.TemplatingUtility;
import sf.util.Utility;

public final class Query
implements Serializable {
    private static final long serialVersionUID = 2820769346069413473L;
    private final boolean hasName;
    private final String name;
    private final String query;

    public Query(String name, String query) {
        boolean isQueryProvided;
        boolean isNameProvided = !Utility.isBlank(name);
        boolean bl = isQueryProvided = !Utility.isBlank(query);
        if (isNameProvided && isQueryProvided) {
            this.name = name;
            this.query = query;
            this.hasName = true;
        } else if (isNameProvided && !isQueryProvided) {
            this.name = this.query = name;
            this.hasName = false;
        } else {
            throw new IllegalArgumentException("No SQL found for query");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean hasName() {
        return this.hasName;
    }

    public boolean isQueryOver() {
        Set<String> keys = TemplatingUtility.extractTemplateVariables(this.query);
        return keys.contains("table");
    }

    public String toString() {
        return String.format("-- \"%s\"%n%s", this.name, this.query);
    }
}

