/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.commandlineparser;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.logging.Level;
import schemacrawler.JvmSystemInfo;
import schemacrawler.OperatingSystemInfo;
import schemacrawler.Version;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.commandline.ConfigParser;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.iosource.ClasspathInputResource;
import schemacrawler.utility.PropertiesUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;
import us.fatehi.commandlineparser.CommandLineArgumentsParser;

public final class CommandLineUtility {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(CommandLineUtility.class.getName());

    public static void applyApplicationLogLevel(Level applicationLogLevel) {
        Utility.applyApplicationLogLevel(applicationLogLevel);
    }

    public static Config loadConfig(Config argsMap, DatabaseConnector dbConnector) throws SchemaCrawlerException {
        Config config = new Config();
        if (dbConnector != null) {
            config.putAll(dbConnector.getConfig());
        }
        try {
            config.putAll(PropertiesUtility.loadConfig(new ClasspathInputResource("/schemacrawler.config.properties")));
        }
        catch (IOException e) {
            LOGGER.log(Level.CONFIG, "schemacrawler.config.properties not found on CLASSPATH");
        }
        if (argsMap != null) {
            config.putAll(argsMap);
        }
        new ConfigParser(config).loadConfig();
        config.putAll(argsMap);
        new ConfigParser(config).consumeOptions();
        return config;
    }

    public static void logFullStackTrace(Level level, Throwable t) {
        if (level == null || !LOGGER.isLoggable(level)) {
            return;
        }
        if (t == null) {
            return;
        }
        LOGGER.log(level, t.getMessage(), t);
    }

    public static void logSafeArguments(String[] args) {
        if (!LOGGER.isLoggable(Level.INFO)) {
            return;
        }
        LOGGER.log(Level.INFO, String.format("Environment:%n%s %s%n%s%n%s%n", Version.getProductName(), Version.getVersion(), new OperatingSystemInfo(), new JvmSystemInfo()));
        if (args == null) {
            return;
        }
        StringJoiner argsList = new StringJoiner(System.lineSeparator());
        Iterator<String> iterator = Arrays.asList(args).iterator();
        while (iterator.hasNext()) {
            String arg = iterator.next();
            if (arg == null) continue;
            if (arg.startsWith("-password=")) {
                argsList.add("-password=*****");
                continue;
            }
            if (arg.startsWith("-password")) {
                argsList.add("-password");
                if (!iterator.hasNext()) continue;
                iterator.next();
                argsList.add("*****");
                continue;
            }
            argsList.add(arg);
        }
        LOGGER.log(Level.INFO, new StringFormat("Command line: %n%s", argsList.toString()));
    }

    public static void logSystemClasspath() {
        if (!LOGGER.isLoggable(Level.CONFIG)) {
            return;
        }
        LOGGER.log(Level.CONFIG, String.format("Classpath: %n%s", CommandLineUtility.printPath(System.getProperty("java.class.path"))));
        LOGGER.log(Level.CONFIG, String.format("LD_LIBRARY_PATH: %n%s", CommandLineUtility.printPath(System.getenv("LD_LIBRARY_PATH"))));
    }

    public static void logSystemProperties() {
        if (!LOGGER.isLoggable(Level.CONFIG)) {
            return;
        }
        TreeMap<String, String> systemProperties = new TreeMap<String, String>();
        for (Map.Entry<Object, Object> propertyValue : System.getProperties().entrySet()) {
            String name = (String)propertyValue.getKey();
            if (!name.startsWith("java.") && !name.startsWith("os.") || name.endsWith(".path")) continue;
            systemProperties.put(name, (String)propertyValue.getValue());
        }
        LOGGER.log(Level.CONFIG, String.format("System properties: %n%s", Utility.join(systemProperties, System.lineSeparator())));
    }

    public static Config parseArgs(String[] args) {
        CommandLineArgumentsParser argsParser = new CommandLineArgumentsParser(args);
        argsParser.parse();
        Config optionsMap = argsParser.getOptionsMap();
        return optionsMap;
    }

    private static String printPath(String path) {
        if (path == null) {
            return "";
        }
        return String.join((CharSequence)System.lineSeparator(), path.split(File.pathSeparator));
    }

    private CommandLineUtility() {
    }
}

