/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer3.engine;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.ICoreProvider;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer3.IBaseIdentification;
import org.neodatis.odb.core.layers.layer3.IBufferedIO;
import org.neodatis.odb.core.layers.layer3.IOFileParameter;
import org.neodatis.odb.core.layers.layer3.engine.IByteArrayConverter;
import org.neodatis.odb.core.layers.layer3.engine.IFileSystemInterface;
import org.neodatis.odb.core.transaction.ISession;
import org.neodatis.odb.impl.core.layers.layer3.engine.StorageEngineConstant;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.DisplayUtility;
import org.neodatis.tool.wrappers.OdbTime;

public abstract class FileSystemInterface
implements IFileSystemInterface {
    private static final int INT_SIZE = ODBType.INTEGER.getSize();
    private static final int INT_SIZE_x_2 = INT_SIZE * 2;
    public static int nbCall1;
    public static int nbCall2;
    public static final String LOG_ID = "FileSystemInterface";
    private String name;
    private boolean canLog;
    private IBufferedIO io;
    protected IBaseIdentification parameters;
    protected IByteArrayConverter byteArrayConverter;
    private static final byte RESERVED_SPACE = -128;

    public void setDatabaseCharacterEncoding(String databaseCharacterEncoding) {
        this.byteArrayConverter.setDatabaseCharacterEncoding(databaseCharacterEncoding);
    }

    public FileSystemInterface(String name, String fileName, boolean canWrite, boolean canLog, int bufferSize) {
        this(name, new IOFileParameter(fileName, canWrite, null, null), canLog, bufferSize);
    }

    public FileSystemInterface(String name, IBaseIdentification parameters, boolean canLog, int bufferSize) {
        this.name = name;
        this.parameters = parameters;
        this.canLog = canLog;
        ICoreProvider provider = OdbConfiguration.getCoreProvider();
        this.io = provider.getIO(name, parameters, bufferSize);
        this.byteArrayConverter = provider.getByteArrayConverter();
    }

    public abstract ISession getSession();

    public void useBuffer(boolean useBuffer) {
        this.io.setUseBuffer(useBuffer);
    }

    public void flush() {
        this.io.flushAllBuffers();
    }

    public long getPosition() {
        return this.io.getCurrentPosition();
    }

    public long getLength() {
        return this.io.getLength();
    }

    boolean isWritingInWrongPlace(long position) {
        if (position < (long)StorageEngineConstant.DATABASE_HEADER_PROTECTED_ZONE_SIZE) {
            int size = StorageEngineConstant.DATABASE_HEADER_POSITIONS.length;
            for (int i = 0; i < size; ++i) {
                if (position != (long)StorageEngineConstant.DATABASE_HEADER_POSITIONS[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void setWritePositionNoVerification(long position, boolean writeInTransacation) {
        this.io.setCurrentWritePosition(position);
        if (writeInTransacation) {
            this.getSession().getTransaction().setWritePosition(position);
        }
    }

    public void setWritePosition(long position, boolean writeInTransacation) {
        if (position < (long)StorageEngineConstant.DATABASE_HEADER_PROTECTED_ZONE_SIZE && this.isWritingInWrongPlace(position)) {
            throw new ODBRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("Trying to write in Protected area at position " + position));
        }
        this.io.setCurrentWritePosition(position);
        if (writeInTransacation) {
            this.getSession().getTransaction().setWritePosition(position);
        }
    }

    public void setReadPosition(long position) {
        this.io.setCurrentReadPosition(position);
    }

    public long getAvailablePosition() {
        return this.io.getLength();
    }

    private boolean pointerAtTheEndOfTheFile() {
        return this.io.getCurrentPosition() == this.io.getLength();
    }

    private void ensureSpaceFor(long quantity, ODBType type) {
        long space = (long)type.getSize() * quantity;
        if (this.pointerAtTheEndOfTheFile()) {
            if (space != 1L) {
                this.io.setCurrentWritePosition(this.io.getCurrentPosition() + space - 1L);
            }
            this.io.writeByte((byte)-128);
            if (OdbConfiguration.isDebugEnabled(LOG_ID) && this.canLog) {
                // empty if block
            }
        } else {
            this.io.setCurrentWritePosition(this.io.getCurrentPosition() + space);
        }
    }

    public void ensureSpaceFor(ODBType type) {
        this.ensureSpaceFor(1L, type);
    }

    public void writeByte(byte i, boolean writeInTransaction) {
        this.writeByte(i, writeInTransaction, null);
    }

    public void writeByte(byte i, boolean writeInTransaction, String label) {
        byte[] bytes = new byte[]{i};
        if (OdbConfiguration.isDebugEnabled(LOG_ID) && this.canLog) {
            DLogger.debug("writing byte " + i + " at " + this.getPosition() + (label != null ? " : " + label : ""));
        }
        if (!writeInTransaction) {
            this.io.writeByte(i);
        } else {
            this.getSession().getTransaction().manageWriteAction(this.io.getCurrentPosition(), bytes);
            this.ensureSpaceFor(ODBType.NATIVE_BYTE);
        }
    }

    public byte readByte() {
        return this.readByte(null);
    }

    public byte readByte(String label) {
        long position = this.io.getCurrentPosition();
        byte i = this.io.readByte();
        if (OdbConfiguration.isDebugEnabled(LOG_ID) && this.canLog) {
            DLogger.debug("reading byte " + i + " at " + position + (label != null ? " : " + label : ""));
        }
        return i;
    }

    public void writeBytes(byte[] bytes, boolean writeInTransaction, String label) {
        if (OdbConfiguration.isDebugEnabled(LOG_ID) && this.canLog) {
            DLogger.debug("writing " + bytes.length + " bytes at " + this.getPosition() + (label != null ? " : " + label : "") + " = " + DisplayUtility.byteArrayToString(bytes));
        }
        if (!writeInTransaction) {
            this.io.writeBytes(bytes);
        } else {
            this.getSession().getTransaction().manageWriteAction(this.io.getCurrentPosition(), bytes);
            this.ensureSpaceFor(bytes.length, ODBType.NATIVE_BYTE);
        }
        bytes = null;
    }

    public byte[] readBytes(int length) {
        long position = this.io.getCurrentPosition();
        byte[] bytes = this.io.readBytes(length);
        int byteCount = bytes.length;
        if (byteCount != length) {
            throw new ODBRuntimeException(NeoDatisError.FILE_INTERFACE_READ_ERROR.addParameter(length).addParameter(position).addParameter(byteCount));
        }
        return bytes;
    }

    public void writeChar(char c, boolean writeInTransaction) {
        byte[] bytes = this.byteArrayConverter.charToByteArray(c);
        if (!writeInTransaction) {
            this.io.writeBytes(bytes);
        } else {
            this.getSession().getTransaction().manageWriteAction(this.io.getCurrentPosition(), bytes);
            this.ensureSpaceFor(ODBType.NATIVE_CHAR);
        }
        bytes = null;
    }

    public byte[] readCharBytes() {
        return this.io.readBytes(ODBType.CHARACTER.getSize());
    }

    public char readChar() {
        return this.readChar(null);
    }

    public char readChar(String label) {
        long position = this.io.getCurrentPosition();
        char c = this.byteArrayConverter.byteArrayToChar(this.readCharBytes());
        if (OdbConfiguration.isDebugEnabled(LOG_ID) && this.canLog && label != null) {
            DLogger.debug("reading char " + c + " at " + position + " : " + label);
        }
        return c;
    }

    public void writeShort(short s, boolean writeInTransaction) {
        byte[] bytes = this.byteArrayConverter.shortToByteArray(s);
        if (OdbConfiguration.isDebugEnabled(LOG_ID) && this.canLog) {
            DLogger.debug("writing short " + s + " at " + this.getPosition());
        }
        if (!writeInTransaction) {
            this.io.writeBytes(bytes);
        } else {
            this.getSession().getTransaction().manageWriteAction(this.io.getCurrentPosition(), bytes);
            this.ensureSpaceFor(ODBType.NATIVE_SHORT);
        }
        bytes = null;
    }

    public byte[] readShortBytes() {
        return this.io.readBytes(ODBType.NATIVE_SHORT.getSize());
    }

    public short readShort() {
        return this.readShort(null);
    }

    public short readShort(String label) {
        long position = this.io.getCurrentPosition();
        short s = this.byteArrayConverter.byteArrayToShort(this.readShortBytes());
        if (OdbConfiguration.isDebugEnabled(LOG_ID) && this.canLog && label != null) {
            DLogger.debug("reading short " + s + " at " + position + " : " + label);
        }
        return s;
    }

    public void writeInt(int i, boolean writeInTransaction, String label) {
        byte[] bytes = this.byteArrayConverter.intToByteArray(i);
        if (OdbConfiguration.isDebugEnabled(LOG_ID) && this.canLog) {
            DLogger.debug("writing int " + i + " at " + this.getPosition() + " : " + label);
        }
        if (!writeInTransaction) {
            this.io.writeBytes(bytes);
        } else {
            this.getSession().getTransaction().manageWriteAction(this.io.getCurrentPosition(), bytes);
            this.ensureSpaceFor(ODBType.NATIVE_INT);
        }
        bytes = null;
    }

    public byte[] readIntBytes() {
        return this.io.readBytes(ODBType.INTEGER.getSize());
    }

    public int readInt() {
        return this.readInt(null);
    }

    public int readInt(String label) {
        long position = this.io.getCurrentPosition();
        int i = this.byteArrayConverter.byteArrayToInt(this.readIntBytes(), 0);
        if (OdbConfiguration.isDebugEnabled(LOG_ID) && this.canLog) {
            DLogger.debug("reading int " + i + " at " + position + (label != null ? " : " + label : ""));
        }
        return i;
    }

    public void writeLong(long i, boolean writeInTransaction, String label, int writeActionType) {
        byte[] bytes = this.byteArrayConverter.longToByteArray(i);
        if (OdbConfiguration.isDebugEnabled(LOG_ID) && this.canLog && label != null) {
            DLogger.debug("writing long " + i + " at " + this.getPosition() + " : " + label);
        }
        if (!writeInTransaction) {
            this.io.writeBytes(bytes);
        } else {
            this.getSession().getTransaction().manageWriteAction(this.io.getCurrentPosition(), bytes);
            this.ensureSpaceFor(ODBType.NATIVE_LONG);
        }
        bytes = null;
    }

    public byte[] readLongBytes() {
        return this.io.readBytes(ODBType.LONG.getSize());
    }

    public long readLong() {
        return this.readLong(null);
    }

    public long readLong(String label) {
        long position = this.io.getCurrentPosition();
        long l = this.byteArrayConverter.byteArrayToLong(this.readLongBytes(), 0);
        if (OdbConfiguration.isDebugEnabled(LOG_ID) && this.canLog) {
            DLogger.debug("reading long " + l + " at " + position + (label != null ? " : " + label : ""));
        }
        return l;
    }

    public void writeFloat(float f, boolean writeInTransaction) {
        byte[] bytes = this.byteArrayConverter.floatToByteArray(f);
        if (!writeInTransaction) {
            this.io.writeBytes(bytes);
        } else {
            this.getSession().getTransaction().manageWriteAction(this.io.getCurrentPosition(), bytes);
            this.ensureSpaceFor(ODBType.NATIVE_FLOAT);
        }
        bytes = null;
    }

    public byte[] readFloatBytes() {
        return this.io.readBytes(ODBType.FLOAT.getSize());
    }

    public float readFloat() {
        return this.readFloat(null);
    }

    public float readFloat(String label) {
        long position = this.io.getCurrentPosition();
        float f = this.byteArrayConverter.byteArrayToFloat(this.readFloatBytes());
        if (OdbConfiguration.isDebugEnabled(LOG_ID) && this.canLog) {
            DLogger.debug("Reading float '" + f + "' at " + position + (label != null ? " : " + label : ""));
        }
        return f;
    }

    public void writeDouble(double d, boolean writeInTransaction) {
        byte[] bytes = this.byteArrayConverter.doubleToByteArray(d);
        if (!writeInTransaction) {
            this.io.writeBytes(bytes);
        } else {
            this.getSession().getTransaction().manageWriteAction(this.io.getCurrentPosition(), bytes);
            this.ensureSpaceFor(ODBType.NATIVE_DOUBLE);
        }
        bytes = null;
    }

    public byte[] readDoubleBytes() {
        return this.io.readBytes(ODBType.DOUBLE.getSize());
    }

    public double readDouble() {
        return this.readDouble(null);
    }

    public double readDouble(String label) {
        long position = this.io.getCurrentPosition();
        double d = this.byteArrayConverter.byteArrayToDouble(this.readDoubleBytes());
        if (OdbConfiguration.isDebugEnabled(LOG_ID) && this.canLog) {
            DLogger.debug("Reading double '" + d + "' at " + position + (label != null ? " : " + label : ""));
        }
        return d;
    }

    public void writeBigDecimal(BigDecimal d, boolean writeInTransaction) {
        byte[] bytes = this.byteArrayConverter.bigDecimalToByteArray(d, true);
        if (OdbConfiguration.isDebugEnabled(LOG_ID) && this.canLog) {
            DLogger.debug("writing BigDecimal " + d + " at " + this.getPosition());
        }
        if (!writeInTransaction) {
            this.io.writeBytes(bytes);
        } else {
            this.getSession().getTransaction().manageWriteAction(this.io.getCurrentPosition(), bytes);
            this.ensureSpaceFor(bytes.length, ODBType.BIG_DECIMAL);
        }
        bytes = null;
    }

    public byte[] readBigDecimalBytes() {
        return this.readStringBytes(false);
    }

    public BigDecimal readBigDecimal() {
        return this.readBigDecimal(null);
    }

    public BigDecimal readBigDecimal(String label) {
        long position = this.io.getCurrentPosition();
        BigDecimal d = this.byteArrayConverter.byteArrayToBigDecimal(this.readBigDecimalBytes(), false);
        if (OdbConfiguration.isDebugEnabled(LOG_ID) && this.canLog) {
            DLogger.debug("Reading bigDecimal '" + d + "' at " + position + (label != null ? " : " + label : ""));
        }
        return d;
    }

    public void writeBigInteger(BigInteger d, boolean writeInTransaction) {
        byte[] bytes = this.byteArrayConverter.bigIntegerToByteArray(d, true);
        if (!writeInTransaction) {
            this.io.writeBytes(bytes);
        } else {
            this.getSession().getTransaction().manageWriteAction(this.io.getCurrentPosition(), bytes);
            this.ensureSpaceFor(bytes.length, ODBType.BIG_INTEGER);
        }
        bytes = null;
    }

    public byte[] readBigIntegerBytes(boolean hasSize) {
        return this.readStringBytes(hasSize);
    }

    public BigInteger readBigInteger() {
        return this.readBigInteger(null);
    }

    public BigInteger readBigInteger(String label) {
        long position = this.io.getCurrentPosition();
        BigInteger d = this.byteArrayConverter.byteArrayToBigInteger(this.readBigIntegerBytes(true), true);
        if (OdbConfiguration.isDebugEnabled(LOG_ID) && this.canLog) {
            DLogger.debug("Reading bigInteger '" + d + "' at " + position + (label != null ? " : " + label : ""));
        }
        return d;
    }

    public void writeDate(Date d, boolean writeInTransaction) {
        byte[] bytes = this.byteArrayConverter.dateToByteArray(d);
        if (OdbConfiguration.isDebugEnabled(LOG_ID) && this.canLog) {
            DLogger.debug("writing Date " + OdbTime.getMilliseconds(d) + " at " + this.getPosition());
        }
        if (!writeInTransaction) {
            this.io.writeBytes(bytes);
        } else {
            this.getSession().getTransaction().manageWriteAction(this.io.getCurrentPosition(), bytes);
            this.ensureSpaceFor(ODBType.DATE);
        }
        bytes = null;
    }

    public byte[] readDateBytes() {
        return this.io.readBytes(ODBType.DATE.getSize());
    }

    public Date readDate() {
        return this.readDate(null);
    }

    public Date readDate(String label) {
        long position = this.io.getCurrentPosition();
        Date date = this.byteArrayConverter.byteArrayToDate(this.readDateBytes());
        if (OdbConfiguration.isDebugEnabled(LOG_ID) && this.canLog) {
            DLogger.debug("Reading date '" + date + "' at " + position + (label != null ? " : " + label : ""));
        }
        return date;
    }

    public void writeString(String s, boolean writeInTransaction, boolean useEncoding) {
        this.writeString(s, writeInTransaction, useEncoding, -1);
    }

    public void writeString(String s, boolean writeInTransaction, boolean useEncoding, int totalSpace) {
        byte[] bytes = this.byteArrayConverter.stringToByteArray(s, true, totalSpace, useEncoding);
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            long position = this.getPosition();
            DLogger.debug("Writing string '" + s + "' at " + position + " size=" + bytes.length + " bytes");
        }
        if (!writeInTransaction) {
            long startPosition = this.io.getCurrentPosition();
            this.io.writeBytes(bytes);
            long endPosition = this.io.getCurrentPosition();
            if (OdbConfiguration.isEnableAfterWriteChecking()) {
                this.io.setCurrentWritePosition(startPosition);
                String s2 = this.readString(useEncoding);
                throw new RuntimeException("error while writing string at " + startPosition + " :  " + s + " / check after writing =" + s2);
            }
        } else {
            this.getSession().getTransaction().manageWriteAction(this.io.getCurrentPosition(), bytes);
            this.ensureSpaceFor(bytes.length, ODBType.STRING);
        }
        bytes = null;
    }

    public byte[] readStringBytes(boolean withSize) {
        if (withSize) {
            int i;
            byte[] sizeBytes = this.io.readBytes(INT_SIZE_x_2);
            int totalSize = this.byteArrayConverter.byteArrayToInt(sizeBytes, 0);
            int stringSize = this.byteArrayConverter.byteArrayToInt(sizeBytes, INT_SIZE);
            byte[] bytes = this.readBytes(stringSize);
            ++nbCall2;
            byte[] extraBytes = this.readBytes(totalSize - stringSize);
            byte[] bytes2 = new byte[stringSize + INT_SIZE_x_2];
            for (i = 0; i < INT_SIZE_x_2; ++i) {
                bytes2[i] = sizeBytes[i];
            }
            for (i = 0; i < bytes.length; ++i) {
                bytes2[i + 8] = bytes[i];
            }
            extraBytes = null;
            sizeBytes = null;
            return bytes2;
        }
        byte[] sizeBytesNoSize = this.io.readBytes(INT_SIZE_x_2);
        int stringSizeNoSize = this.byteArrayConverter.byteArrayToInt(sizeBytesNoSize, INT_SIZE);
        byte[] bytesNoSize = this.readBytes(stringSizeNoSize);
        ++nbCall1;
        sizeBytesNoSize = null;
        return bytesNoSize;
    }

    public String readString(boolean useEncoding) {
        return this.readString(useEncoding, OdbConfiguration.getDatabaseCharacterEncoding());
    }

    public String readString(boolean useEncoding, String label) {
        String s = this.byteArrayConverter.byteArrayToString(this.readStringBytes(true), true, useEncoding);
        if (OdbConfiguration.isDebugEnabled(LOG_ID) && this.canLog) {
            long startPosition = this.io.getCurrentPosition();
            DLogger.debug("Reading string '" + s + "' at " + startPosition + (label != null ? " : " + label : ""));
        }
        return s;
    }

    public void writeBoolean(boolean b, boolean writeInTransaction) {
        this.writeBoolean(b, writeInTransaction, null);
    }

    public void writeBoolean(boolean b, boolean writeInTransaction, String label) {
        if (OdbConfiguration.isDebugEnabled(LOG_ID) && this.canLog && label != null) {
            DLogger.debug("writing boolean " + b + " at " + this.getPosition() + " : " + label);
        }
        byte[] bytes = this.byteArrayConverter.booleanToByteArray(b);
        if (!writeInTransaction) {
            this.io.writeBytes(bytes);
        } else {
            this.getSession().getTransaction().manageWriteAction(this.io.getCurrentPosition(), bytes);
            this.ensureSpaceFor(ODBType.NATIVE_BOOLEAN);
        }
        bytes = null;
    }

    public byte[] readBooleanBytes() {
        return this.io.readBytes(ODBType.BOOLEAN.getSize());
    }

    public boolean readBoolean() {
        return this.readBoolean(null);
    }

    public boolean readBoolean(String label) {
        long position = this.io.getCurrentPosition();
        boolean b = this.byteArrayConverter.byteArrayToBoolean(this.readBooleanBytes(), 0);
        if (OdbConfiguration.isDebugEnabled(LOG_ID) && this.canLog && label != null) {
            DLogger.debug("reading boolean " + b + " at " + position + " : " + label);
        }
        return b;
    }

    public byte[] readNativeAttributeBytes(int attributeType) {
        switch (attributeType) {
            case 20: {
                byte[] bytes = new byte[]{this.readByte()};
                return bytes;
            }
            case 10: {
                return this.readBooleanBytes();
            }
            case 30: {
                return this.readCharBytes();
            }
            case 70: {
                return this.readFloatBytes();
            }
            case 80: {
                return this.readDoubleBytes();
            }
            case 50: {
                return this.readIntBytes();
            }
            case 60: {
                return this.readLongBytes();
            }
            case 40: {
                return this.readShortBytes();
            }
            case 200: {
                return this.readBigDecimalBytes();
            }
            case 190: {
                return this.readBigIntegerBytes(true);
            }
            case 160: {
                return this.readBooleanBytes();
            }
            case 150: {
                return this.readCharBytes();
            }
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: {
                return this.readDateBytes();
            }
            case 130: {
                return this.readFloatBytes();
            }
            case 140: {
                return this.readDoubleBytes();
            }
            case 110: {
                return this.readIntBytes();
            }
            case 210: {
                return this.readStringBytes(true);
            }
        }
        throw new ODBRuntimeException(NeoDatisError.NATIVE_TYPE_NOT_SUPPORTED.addParameter(attributeType).addParameter(""));
    }

    public void close() {
        this.clear();
        this.io.close();
        this.io = null;
    }

    public void clear() {
    }

    public IBaseIdentification getParameters() {
        return this.parameters;
    }

    public boolean delete() {
        return this.io.delete();
    }

    public IBufferedIO getIo() {
        return this.io;
    }
}

