/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.query.execution;

import java.util.ArrayList;
import org.neodatis.btree.IBTree;
import org.neodatis.btree.IBTreeMultipleValuesPerKey;
import org.neodatis.btree.IBTreeSingleValuePerKey;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.Objects;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoIndex;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer3.IObjectReader;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.core.query.QueryManager;
import org.neodatis.odb.core.query.execution.EmptyExecutionPlan;
import org.neodatis.odb.core.query.execution.IMatchingObjectAction;
import org.neodatis.odb.core.query.execution.IMultiClassQueryExecutor;
import org.neodatis.odb.core.query.execution.IQueryExecutionPlan;
import org.neodatis.odb.core.query.execution.IQueryExecutorCallback;
import org.neodatis.odb.core.query.execution.IndexTool;
import org.neodatis.odb.core.transaction.ISession;
import org.neodatis.odb.impl.core.btree.LazyODBBTreePersister;
import org.neodatis.odb.impl.tool.MemoryMonitor;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbComparable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericQueryExecutor
implements IMultiClassQueryExecutor {
    public static final String LOG_ID = "GenericQueryExecutor";
    protected IStorageEngine storageEngine;
    protected IQuery query;
    protected ClassInfo classInfo;
    protected IObjectReader objectReader;
    protected ISession session;
    protected OID nextOID;
    private boolean queryHasOrderBy;
    private OdbComparable orderByKey;
    protected OID currentOid;
    protected NonNativeObjectInfo currentNnoi;
    protected IQueryExecutorCallback callback;
    protected boolean executeStartAndEndOfQueryAction;

    public GenericQueryExecutor(IQuery query, IStorageEngine engine) {
        this.query = query;
        this.storageEngine = engine;
        this.objectReader = this.storageEngine.getObjectReader();
        this.session = this.storageEngine.getSession(true);
        this.callback = OdbConfiguration.getQueryExecutorCallback();
        this.executeStartAndEndOfQueryAction = true;
    }

    public abstract IQueryExecutionPlan getExecutionPlan();

    public abstract void prepareQuery();

    public abstract Comparable computeIndexKey(ClassInfo var1, ClassInfoIndex var2);

    public abstract Object getCurrentObjectMetaRepresentation();

    public abstract boolean matchObjectWithOid(OID var1, boolean var2, boolean var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Objects<T> execute(boolean inMemory, int startIndex, int endIndex, boolean returnObjects, IMatchingObjectAction queryResultAction) {
        if (this.storageEngine.isClosed()) {
            throw new ODBRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.storageEngine.getBaseIdentification().getIdentification()));
        }
        if (this.session.isRollbacked()) {
            throw new ODBRuntimeException(NeoDatisError.ODB_HAS_BEEN_ROLLBACKED);
        }
        if (this.classInfo == null) {
            String fullClassName = this.getFullClassName(this.query);
            if (!this.session.getMetaModel().existClass(fullClassName)) {
                queryResultAction.start();
                queryResultAction.end();
                this.query.setExecutionPlan(new EmptyExecutionPlan());
                return queryResultAction.getObjects();
            }
            this.classInfo = this.session.getMetaModel().getClassInfo(fullClassName, true);
        }
        IQueryExecutionPlan plan = this.getExecutionPlan();
        plan.start();
        try {
            if (plan.useIndex() && OdbConfiguration.useIndex()) {
                Objects<T> objects = this.executeUsingIndex(plan.getIndex(), inMemory, startIndex, endIndex, returnObjects, queryResultAction);
                return objects;
            }
            if (this.query.isForSingleOid()) {
                Objects<T> objects = this.executeForOneOid(inMemory, returnObjects, queryResultAction);
                return objects;
            }
            Objects<T> objects = this.executeFullScan(inMemory, startIndex, endIndex, returnObjects, queryResultAction);
            return objects;
        }
        finally {
            plan.end();
        }
    }

    @Override
    public abstract String getFullClassName(IQuery var1);

    private <T> Objects<T> executeFullScan(boolean inMemory, int startIndex, int endIndex, boolean returnObjects, IMatchingObjectAction queryResultAction) {
        boolean objectInRange = false;
        boolean objectMatches = false;
        if (this.storageEngine.isClosed()) {
            throw new ODBRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.storageEngine.getBaseIdentification().getIdentification()));
        }
        long nbObjects = this.classInfo.getNumberOfObjects();
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("loading " + nbObjects + " instance(s) of " + this.classInfo.getFullClassName());
        }
        if (this.executeStartAndEndOfQueryAction()) {
            queryResultAction.start();
        }
        OID currentOID = null;
        OID prevOID = null;
        this.nextOID = this.classInfo.getCommitedZoneInfo().first;
        if (nbObjects > 0L && this.nextOID == null) {
            this.nextOID = this.classInfo.getUncommittedZoneInfo().first;
        }
        this.prepareQuery();
        if (this.query != null) {
            this.queryHasOrderBy = this.query.hasOrderBy();
        }
        boolean monitorMemory = OdbConfiguration.isMonitoringMemory();
        int nbObjectsInResult = 0;
        int i = 0;
        while ((long)i < nbObjects) {
            if (monitorMemory && i % 10000 == 0) {
                MemoryMonitor.displayCurrentMemory("" + (i + 1), true);
            }
            this.orderByKey = null;
            objectMatches = false;
            prevOID = currentOID;
            currentOID = this.nextOID;
            if (currentOID == null) {
                if (!OdbConfiguration.throwExceptionWhenInconsistencyFound()) break;
                throw new ODBRuntimeException(NeoDatisError.NULL_NEXT_OBJECT_OID.addParameter(this.classInfo.getFullClassName()).addParameter(i).addParameter(nbObjects).addParameter(prevOID));
            }
            if (endIndex != -1 && nbObjectsInResult >= endIndex) break;
            objectInRange = startIndex == -1 || nbObjectsInResult >= startIndex;
            if (!inMemory && this.query == null) {
                ++nbObjectsInResult;
                if (objectInRange) {
                    this.orderByKey = this.buildOrderByKey(this.currentNnoi);
                    queryResultAction.objectMatch(this.nextOID, this.orderByKey);
                }
                this.nextOID = this.objectReader.getNextObjectOID(currentOID);
            } else {
                objectMatches = this.matchObjectWithOid(currentOID, returnObjects, inMemory);
                if (objectMatches) {
                    ++nbObjectsInResult;
                    if (objectInRange) {
                        if (this.queryHasOrderBy) {
                            this.orderByKey = this.buildOrderByKey(this.getCurrentObjectMetaRepresentation());
                        }
                        queryResultAction.objectMatch(currentOID, this.getCurrentObjectMetaRepresentation(), this.orderByKey);
                        if (this.callback != null) {
                            this.callback.readingObject(i, -1L);
                        }
                    }
                }
            }
            ++i;
        }
        if (this.executeStartAndEndOfQueryAction()) {
            queryResultAction.end();
        }
        return queryResultAction.getObjects();
    }

    private <T> Objects<T> executeUsingIndex(ClassInfoIndex index, boolean inMemory, int startIndex, int endIndex, boolean returnObjects, IMatchingObjectAction queryResultAction) {
        long btreeSize;
        if (index.getBTree().getPersister() == null) {
            index.getBTree().setPersister(new LazyODBBTreePersister(this.storageEngine));
        }
        boolean objectMatches = false;
        long nbObjects = this.classInfo.getNumberOfObjects();
        if (nbObjects != (btreeSize = index.getBTree().getSize())) {
            ClassInfo ci = this.storageEngine.getSession(true).getMetaModel().getClassInfoFromId(index.getClassInfoId());
            throw new ODBRuntimeException(NeoDatisError.INDEX_IS_CORRUPTED.addParameter(index.getName()).addParameter(ci.getFullClassName()).addParameter(nbObjects).addParameter(btreeSize));
        }
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("loading " + nbObjects + " instance(s) of " + this.classInfo.getFullClassName());
        }
        if (this.executeStartAndEndOfQueryAction()) {
            queryResultAction.start();
        }
        this.prepareQuery();
        if (this.query != null) {
            this.queryHasOrderBy = this.query.hasOrderBy();
        }
        IBTree tree = index.getBTree();
        boolean isUnique = index.isUnique();
        Comparable key = this.computeIndexKey(this.classInfo, index);
        ArrayList<Object> list = null;
        if (isUnique) {
            IBTreeSingleValuePerKey treeSingle = (IBTreeSingleValuePerKey)tree;
            Object object = treeSingle.search(key);
            if (object != null) {
                list = new ArrayList<Object>();
                list.add(object);
            }
        } else {
            IBTreeMultipleValuesPerKey treeMultiple = (IBTreeMultipleValuesPerKey)tree;
            list = treeMultiple.search(key);
        }
        if (list != null) {
            for (OID oID : list) {
                long position = this.objectReader.getObjectPositionFromItsOid(oID, true, true);
                this.orderByKey = null;
                objectMatches = this.matchObjectWithOid(oID, returnObjects, inMemory);
                if (!objectMatches) continue;
                queryResultAction.objectMatch(oID, this.getCurrentObjectMetaRepresentation(), this.orderByKey);
            }
            queryResultAction.end();
            return queryResultAction.getObjects();
        }
        if (this.executeStartAndEndOfQueryAction()) {
            queryResultAction.end();
        }
        return queryResultAction.getObjects();
    }

    private <T> Objects<T> executeForOneOid(boolean inMemory, boolean returnObjects, IMatchingObjectAction queryResultAction) {
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("loading Object with oid " + this.query.getOidOfObjectToQuery() + " - class " + this.classInfo.getFullClassName());
        }
        if (this.executeStartAndEndOfQueryAction()) {
            queryResultAction.start();
        }
        this.prepareQuery();
        OID oid = this.query.getOidOfObjectToQuery();
        long position = this.objectReader.getObjectPositionFromItsOid(oid, true, true);
        boolean objectMatches = this.matchObjectWithOid(oid, returnObjects, inMemory);
        queryResultAction.objectMatch(oid, this.getCurrentObjectMetaRepresentation(), this.orderByKey);
        queryResultAction.end();
        return queryResultAction.getObjects();
    }

    public OdbComparable buildOrderByKey(Object object) {
        if (object instanceof AttributeValuesMap) {
            return this.buildOrderByKey((AttributeValuesMap)object);
        }
        return this.buildOrderByKey((NonNativeObjectInfo)object);
    }

    public OdbComparable buildOrderByKey(NonNativeObjectInfo nnoi) {
        return IndexTool.buildIndexKey("OrderBy", nnoi, QueryManager.getOrderByAttributeIds(this.classInfo, this.query));
    }

    public OdbComparable buildOrderByKey(AttributeValuesMap values) {
        return IndexTool.buildIndexKey("OrderBy", values, this.query.getOrderByFieldNames());
    }

    @Override
    public boolean executeStartAndEndOfQueryAction() {
        return this.executeStartAndEndOfQueryAction;
    }

    @Override
    public void setExecuteStartAndEndOfQueryAction(boolean yes) {
        this.executeStartAndEndOfQueryAction = yes;
    }

    @Override
    public IStorageEngine getStorageEngine() {
        return this.storageEngine;
    }

    @Override
    public IQuery getQuery() {
        return this.query;
    }

    @Override
    public void setClassInfo(ClassInfo classInfo) {
        this.classInfo = classInfo;
    }
}

