/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui.classbrowser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer3.IBaseIdentification;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.gui.IBrowserContainer;
import org.neodatis.odb.gui.classbrowser.ClassHierarchyModel;
import org.neodatis.odb.gui.classbrowser.MyMouseListener;
import org.neodatis.odb.gui.classbrowser.MyRenderer;
import org.neodatis.odb.gui.objectbrowser.flat.FlatQueryResultPanel;
import org.neodatis.odb.gui.objectbrowser.hierarchy.HierarchicObjectBrowserPanel;
import org.neodatis.odb.gui.objectbrowser.update.NewObjectPanel;
import org.neodatis.odb.gui.query.CriteriaQueryPanel;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;
import org.neodatis.tool.ILogger;
import org.neodatis.tool.wrappers.OdbString;

public class ClassHierarchyPanel
extends JPanel {
    public static final String ACTION_NONE = "none";
    public static final String ACTION_OBJECT_VIEW = "object-view";
    public static final String ACTION_TABLE_VIEW = "table-view";
    public static final String ACTION_NEW_OBJECT = "new-object";
    public static final String ACTION_QUERY = "query";
    public static final String ACTION_REFACTOR_RENAME_CLASS = "refactor-rename-class";
    public static final String ACTION_REFACTOR_ADD_FIELD = "refactor-add-field";
    public static final String ACTION_REFACTOR_RENAME_FIELD = "refactor-rename-field";
    public static final String ACTION_REFACTOR_REMOVE_FIELD = "refactor-remove-field";
    public static final String ACTION_REFACTOR_CHANGE_FIELD_TYPE = "refactor-change-field-type";
    public static final String ACTION_REBUILD_INDEX = "rebuild-index";
    private static final int MAX_OBJECTS = 300;
    private IStorageEngine engine;
    private ClassHierarchyModel model;
    private JTree tree;
    private IBrowserContainer browser;
    private JButton closeButton;
    private JButton commitButton;
    private JButton rollbackButton;
    private JButton fakeButton;
    private ILogger logger;

    public ClassHierarchyPanel(IStorageEngine theEngine, IBrowserContainer browser, String title, ILogger logger) {
        this.engine = theEngine;
        this.browser = browser;
        this.logger = logger;
        System.out.println("Setting engine : " + this.engine);
        System.out.println("Title = " + title);
        this.initGUI(title);
    }

    private void initGUI(String title) {
        this.setLayout(new BorderLayout(4, 4));
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.getTitle());
        this.model = new ClassHierarchyModel(this.engine, root);
        this.tree = new JTree(this.model);
        ImageIcon classIcon = ClassHierarchyPanel.createImageIcon("/img/class.png");
        ImageIcon fieldIcon = ClassHierarchyPanel.createImageIcon("/img/field.png");
        this.tree.setCellRenderer(new MyRenderer((Icon)classIcon, fieldIcon));
        this.tree.addMouseListener(new MyMouseListener(this.tree, this));
        JScrollPane scrollPane = new JScrollPane(this.tree);
        scrollPane.setPreferredSize(new Dimension(200, 200));
        scrollPane.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.add(scrollPane);
        this.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
    }

    public void updateEngine(IStorageEngine engine) {
        this.engine = engine;
        this.model.updateEngine(engine);
        this.tree.invalidate();
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = ClassHierarchyPanel.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    private Object getTitle() {
        if (this.engine == null) {
            System.out.println("Engine is null!");
        }
        IBaseIdentification p = this.engine.getBaseIdentification();
        return p.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(String action, ClassInfo ci, ClassAttributeInfo cai) {
        String actionCommand = action;
        if (actionCommand == null) {
            return;
        }
        if (actionCommand.equals(ACTION_TABLE_VIEW)) {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.flatBrowseObjects(ci);
            }
            catch (Exception e1) {
                this.logger.error("Error while browsing ", e1);
                this.logger.error(OdbString.exceptionToString(e1, true));
                JOptionPane.showMessageDialog(this, "Error while browsing : " + e1.getMessage());
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        if (actionCommand.equals(ACTION_OBJECT_VIEW)) {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.hierarchyBrowseObjects(ci);
            }
            catch (Exception e1) {
                this.logger.error("Error while browsing ", e1);
                this.logger.error(OdbString.exceptionToString(e1, true));
                JOptionPane.showMessageDialog(this, "Error while browsing : " + e1.getMessage());
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        if (actionCommand.equals(ACTION_QUERY)) {
            try {
                this.queryObjects(ci);
            }
            catch (Exception e1) {
                this.logger.error("Error while executing query ", e1);
                this.logger.error(OdbString.exceptionToString(e1, true));
                JOptionPane.showMessageDialog(this, "Error while executing query : " + e1.getMessage());
            }
        }
        if (actionCommand.equals(ACTION_NEW_OBJECT)) {
            try {
                this.newObjectPanel(ci);
            }
            catch (Exception e1) {
                this.logger.error("Error while creating a new object ", e1);
                this.logger.error(OdbString.exceptionToString(e1, true));
                JOptionPane.showMessageDialog(this, "Error while creating new Object : " + e1.getMessage());
            }
        }
        if (actionCommand.equals(ACTION_REFACTOR_RENAME_CLASS)) {
            try {
                this.logger.info("Renaming class " + ci.getFullClassName());
                String newClassName = JOptionPane.showInputDialog(this, "Enter the new full class name", ci.getFullClassName());
                if (newClassName == null) {
                    JOptionPane.showMessageDialog(this, "The class name must be defined");
                }
                this.engine.getRefactorManager().renameClass(ci.getFullClassName(), newClassName);
                JOptionPane.showMessageDialog(this, "Refactor was successfull!");
            }
            catch (Exception e1) {
                this.logger.error("Error while renaming class " + ci.getFullClassName());
                this.logger.error(OdbString.exceptionToString(e1, true));
                JOptionPane.showMessageDialog(this, "Error while renaming class : " + e1.getMessage());
            }
        }
        if (actionCommand.startsWith(ACTION_REBUILD_INDEX)) {
            try {
                String indexName = actionCommand.split(":")[1];
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.logger.info("Rebuilding index " + indexName + " on class " + ci.getFullClassName());
                this.engine.rebuildIndex(ci.getFullClassName(), indexName, true);
                JOptionPane.showMessageDialog(this, "Rebuild index was successfull!");
            }
            catch (Exception e1) {
                this.logger.error("Error while rebuilding index " + ci.getFullClassName());
                this.logger.error(OdbString.exceptionToString(e1, true));
                JOptionPane.showMessageDialog(this, "Error while rebuilding index : " + e1.getMessage());
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        if (actionCommand.equals(ACTION_REFACTOR_RENAME_FIELD)) {
            try {
                this.logger.info("Renaming field " + ci.getFullClassName() + "." + cai.getName());
                String newFieldName = JOptionPane.showInputDialog(this, "Enter the new field name", cai.getName());
                this.engine.getRefactorManager().renameField(ci.getFullClassName(), cai.getName(), newFieldName);
                JOptionPane.showMessageDialog(this, "Refactor was successfull!");
            }
            catch (Exception e1) {
                this.logger.error("Error while renaming class " + ci.getFullClassName());
                this.logger.error(OdbString.exceptionToString(e1, true));
                JOptionPane.showMessageDialog(this, "Error while renaming class : " + e1.getMessage());
            }
        }
        if (actionCommand.equals(ACTION_REFACTOR_REMOVE_FIELD)) {
            try {
                this.logger.info("Removing field " + ci.getFullClassName() + "." + cai.getName());
                int r = JOptionPane.showConfirmDialog(this, "Do you really want to remove field " + cai.getName() + " from " + ci.getFullClassName());
                if (r == 0) {
                    this.engine.getRefactorManager().removeField(ci.getFullClassName(), cai.getName());
                    JOptionPane.showMessageDialog(this, "Field " + cai.getName() + " removed successfully!");
                }
            }
            catch (Exception e1) {
                String msg = "Error while removing field + " + cai.getName() + " from " + ci.getFullClassName() + " : " + OdbString.exceptionToString(e1, true);
                this.logger.error(msg);
                this.logger.error(OdbString.exceptionToString(e1, true));
                JOptionPane.showMessageDialog(this, msg);
            }
        }
        if (actionCommand.equals(ACTION_REFACTOR_ADD_FIELD)) {
            String newFieldName = null;
            String newFieldType = null;
            try {
                this.logger.info("Adding a field on class " + ci.getFullClassName());
                newFieldName = JOptionPane.showInputDialog(this, "Enter the field name", "myNewField");
                newFieldType = JOptionPane.showInputDialog(this, "Enter the type of the field", "int or long or org.neodatis.test.MyClass");
                Class<?> type = Class.forName(newFieldType);
                this.engine.getRefactorManager().addField(ci.getFullClassName(), type, newFieldName);
                JOptionPane.showMessageDialog(this, "Refactor was successfull : field " + newFieldName + " added");
            }
            catch (Exception e1) {
                String m = "Error while adding a field name=" + newFieldName + ", type=" + newFieldType + " to class " + ci.getFullClassName();
                this.logger.error(m);
                this.logger.error(OdbString.exceptionToString(e1, true));
                JOptionPane.showMessageDialog(this, m + ":" + e1.getMessage());
            }
        }
    }

    private void newObjectPanel(ClassInfo ci) {
        if (ci == null) {
            JOptionPane.showMessageDialog(this, "Select a class");
            return;
        }
        String title = "Creating new object of type " + ci.getFullClassName();
        NewObjectPanel panel = new NewObjectPanel(this.engine, ci, this.browser, this.logger);
        this.browser.browse(title, panel, -1);
    }

    private void flatBrowseObjects(ClassInfo classInfoToBrowse) throws Exception {
        int userOption;
        if (classInfoToBrowse == null) {
            JOptionPane.showMessageDialog(this, "Select a class to browse");
            return;
        }
        if (classInfoToBrowse.hasCyclicReference()) {
            JOptionPane.showMessageDialog(this, "<html>Class <b>" + classInfoToBrowse.getFullClassName() + "</b> has cyclic references : it can not be displayed in table view. <br>Please use the Object View</html>");
            return;
        }
        String title = classInfoToBrowse.getFullClassName();
        long nbObjects = this.engine.getSession(true).getMetaModel().getClassInfo(classInfoToBrowse.getFullClassName(), true).getNumberOfObjects();
        if (nbObjects > 300L && (userOption = JOptionPane.showConfirmDialog(this, "Class " + classInfoToBrowse.getFullClassName() + "\n has " + nbObjects + " objects. Do you really want to display all ?", "Warning", 2)) == 2) {
            return;
        }
        Objects l = this.engine.getObjectInfos(new CriteriaQuery(classInfoToBrowse.getFullClassName()), true, -1, -1, false);
        FlatQueryResultPanel panel = new FlatQueryResultPanel(this.engine, classInfoToBrowse.getFullClassName(), l);
        this.browser.browse(title, panel, l.size());
    }

    private void queryObjects(ClassInfo classInfoToBrowse) throws Exception {
        if (classInfoToBrowse == null) {
            JOptionPane.showMessageDialog(this, "Select a class to query");
            return;
        }
        String title = "query on " + classInfoToBrowse.getFullClassName();
        CriteriaQueryPanel panel = new CriteriaQueryPanel(this.engine, classInfoToBrowse, this.browser, this.logger);
        this.browser.browse(title, panel, -1);
    }

    private void hierarchyBrowseObjects(ClassInfo classInfoToBrowse) throws Exception {
        int userOption;
        if (classInfoToBrowse == null) {
            JOptionPane.showMessageDialog(this, "Select a class to browse");
            return;
        }
        long nbObjects = this.engine.getSession(true).getMetaModel().getClassInfo(classInfoToBrowse.getFullClassName(), true).getNumberOfObjects();
        if (nbObjects > 300L && (userOption = JOptionPane.showConfirmDialog(this, "Class " + classInfoToBrowse.getFullClassName() + "\n has " + nbObjects + " objects. Do you really want to display all ?", "Warning", 2)) == 2) {
            return;
        }
        String title = classInfoToBrowse.getFullClassName();
        Objects l = this.engine.getObjectInfos(new CriteriaQuery(classInfoToBrowse.getFullClassName()), true, -1, -1, false);
        ArrayList list = new ArrayList(l.size());
        list.addAll(l);
        HierarchicObjectBrowserPanel panel = new HierarchicObjectBrowserPanel(this.browser, this.engine, classInfoToBrowse, list, true, this.logger);
        this.browser.browse(title, panel, l.size());
    }
}

