/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.layers.layer3.buffer;

import java.io.IOException;
import java.nio.channels.OverlappingFileLockException;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.IError;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer3.IO;
import org.neodatis.odb.impl.core.layers.layer3.buffer.MultiBufferedIO;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.IOUtil;
import org.neodatis.tool.wrappers.OdbString;
import org.neodatis.tool.wrappers.OdbSystem;
import org.neodatis.tool.wrappers.OdbThread;
import org.neodatis.tool.wrappers.io.OdbFile;

public class MultiBufferedFileIO
extends MultiBufferedIO {
    private static final String LOG_ID = "MultiBufferedFileIO";
    private IO fileWriter;
    public static int nbcalls = 0;
    public static int nbdiffcalls = 0;
    private String wholeFileName;

    public MultiBufferedFileIO(int nbBuffers, String name, String fileName, boolean canWrite, int bufferSize) {
        super(nbBuffers, name, bufferSize, canWrite);
        this.init(fileName, canWrite);
    }

    private void init(String fileName, boolean canWrite) {
        block8: {
            String dataDirectory = OdbSystem.getProperty("data.directory");
            this.wholeFileName = dataDirectory != null ? dataDirectory + "/" + fileName : fileName;
            try {
                if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                    DLogger.info("Opening datatbase file : " + new OdbFile(this.wholeFileName).getFullPath());
                }
                this.fileWriter = this.buildFileWriter(canWrite);
                this.setIoDeviceLength(this.fileWriter.length());
                if (!canWrite) break block8;
                try {
                    this.fileWriter.lockFile();
                }
                catch (Exception e) {
                    throw new ODBRuntimeException(NeoDatisError.ODB_FILE_IS_LOCKED_BY_CURRENT_VIRTUAL_MACHINE.addParameter(this.wholeFileName).addParameter(OdbThread.getCurrentThreadName()).addParameter(String.valueOf(OdbConfiguration.isMultiThread())), (Throwable)e);
                }
                if (!this.fileWriter.isLocked()) {
                    throw new ODBRuntimeException(NeoDatisError.ODB_FILE_IS_LOCKED_BY_EXTERNAL_PROGRAM.addParameter(this.wholeFileName).addParameter(OdbThread.getCurrentThreadName()).addParameter(String.valueOf(OdbConfiguration.isMultiThread())));
                }
            }
            catch (OverlappingFileLockException e1) {
                throw new ODBRuntimeException(NeoDatisError.ODB_FILE_IS_LOCKED_BY_CURRENT_VIRTUAL_MACHINE.addParameter(this.wholeFileName).addParameter(OdbThread.getCurrentThreadName()).addParameter(String.valueOf(OdbConfiguration.isMultiThread())), (Throwable)e1);
            }
            catch (Exception e2) {
                if (e2 instanceof ODBRuntimeException) {
                    throw (ODBRuntimeException)e2;
                }
                throw new ODBRuntimeException((IError)NeoDatisError.INTERNAL_ERROR, (Throwable)e2);
            }
        }
    }

    protected IO buildFileWriter(boolean canWrite) throws IOException {
        try {
            Class ioclass = OdbConfiguration.getIOClass();
            IO io = (IO)ioclass.newInstance();
            io.init(this.wholeFileName, canWrite, OdbConfiguration.getEncryptionPassword());
            return io;
        }
        catch (Exception e) {
            throw new ODBRuntimeException((IError)NeoDatisError.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public void goToPosition(long position) {
        try {
            if (position < 0L) {
                throw new ODBRuntimeException(NeoDatisError.NEGATIVE_POSITION.addParameter(position));
            }
            this.fileWriter.seek(position);
        }
        catch (IOException e) {
            long l = -1L;
            try {
                l = this.fileWriter.length();
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw new ODBRuntimeException(NeoDatisError.GO_TO_POSITION.addParameter(position).addParameter(l), (Throwable)e);
        }
    }

    public long getLength() {
        ++nbcalls;
        return this.getIoDeviceLength();
    }

    public void internalWrite(byte b) {
        try {
            this.fileWriter.write(b);
        }
        catch (IOException e) {
            throw new ODBRuntimeException(e, "Error while writing a byte");
        }
    }

    public void internalWrite(byte[] bs, int size) {
        try {
            this.fileWriter.write(bs, 0, size);
        }
        catch (IOException e) {
            throw new ODBRuntimeException(e, "Error while writing an array of byte");
        }
    }

    public byte internalRead() {
        try {
            int b = this.fileWriter.read();
            if (b == -1) {
                throw new IOException("Enf of file");
            }
            return (byte)b;
        }
        catch (IOException e) {
            throw new ODBRuntimeException(e, "Error while reading a byte");
        }
    }

    public long internalRead(byte[] array, int size) {
        try {
            return this.fileWriter.read(array, 0, size);
        }
        catch (IOException e) {
            throw new ODBRuntimeException(e, "Error while reading an array of byte");
        }
    }

    public void closeIO() {
        boolean b;
        try {
            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                DLogger.debug("Closing file with size " + this.fileWriter.length());
            }
            if (this.fileWriter.isLocked()) {
                this.fileWriter.unlockFile();
            }
            this.fileWriter.close();
        }
        catch (IOException e) {
            DLogger.error(OdbString.exceptionToString(e, true));
        }
        this.fileWriter = null;
        if (this.isForTransaction() && this.automaticDeleteIsEnabled() && !(b = IOUtil.deleteFile(this.wholeFileName))) {
            throw new ODBRuntimeException(NeoDatisError.CAN_NOT_DELETE_FILE.addParameter(this.wholeFileName));
        }
    }

    public void clear() {
        super.clear();
    }

    public boolean delete() {
        return IOUtil.deleteFile(this.wholeFileName);
    }

    public void flushIO() throws IOException {
        this.fileWriter.flushIO();
    }
}

