/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.layers.layer3.crypto;

import java.io.IOException;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer3.IO;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbThread;
import org.neodatis.tool.wrappers.io.OdbFileIO;

public class AesMd5Cypher
implements IO {
    private OdbFileIO fileIO;
    private String fileName;
    private static int CRYPTO_BLOCKSIZE = 16;
    private static int BLOCKSIZE = 2048;
    long currentPosition = 0L;
    Cipher decipher;
    Cipher encipher;

    public void init(String fileName, boolean canWrite, String password) throws Exception {
        this.fileIO = new OdbFileIO();
        this.fileIO.init(fileName, canWrite, password);
        this.fileName = fileName;
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] key = md5.digest(password.getBytes());
        SecretKeySpec skey = new SecretKeySpec(key, "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(md5.digest(key));
        this.encipher = Cipher.getInstance("AES/CTR/NoPadding");
        this.encipher.init(1, (Key)skey, ivSpec);
        this.decipher = Cipher.getInstance("AES/CTR/NoPadding");
        this.decipher.init(2, (Key)skey, ivSpec);
    }

    public void close() throws IOException {
        this.fileIO.close();
        this.fileIO = null;
    }

    public int read() throws IOException {
        byte[] bytes = new byte[1];
        long l = this.read(bytes, 0, 1);
        return bytes[0];
    }

    public long read(byte[] bytes, int offfset, int size) throws IOException {
        int totalread = 0;
        long pos = this.currentPosition;
        int balength = bytes.length;
        long pos1 = pos / (long)BLOCKSIZE * (long)BLOCKSIZE;
        byte[] blockbit = new byte[BLOCKSIZE];
        try {
            this.fileIO.seek(pos1);
            totalread = (int)((long)totalread + this.fileIO.read(blockbit, 0, BLOCKSIZE));
            blockbit = this.decipher.doFinal(blockbit);
            int len1 = BLOCKSIZE - (int)(pos - pos1);
            if (balength < len1) {
                len1 = balength;
            }
            System.arraycopy(blockbit, (int)(pos - pos1), bytes, 0, len1);
            pos += (long)len1;
            int blocks = (balength -= len1) / BLOCKSIZE;
            for (int i = 0; i < blocks; ++i) {
                pos1 = pos / (long)BLOCKSIZE * (long)BLOCKSIZE;
                this.fileIO.seek(pos1);
                totalread = (int)((long)totalread + this.fileIO.read(blockbit, 0, BLOCKSIZE));
                blockbit = this.decipher.doFinal(blockbit);
                len1 = BLOCKSIZE - (int)(pos - pos1);
                if (balength < len1) {
                    len1 = balength;
                }
                System.arraycopy(blockbit, 0, bytes, bytes.length - balength, len1);
                pos += (long)len1;
                balength -= len1;
            }
            if (balength > 0) {
                blockbit = new byte[BLOCKSIZE];
                pos1 = pos / (long)BLOCKSIZE * (long)BLOCKSIZE;
                this.fileIO.seek(pos1);
                totalread = (int)((long)totalread + this.fileIO.read(blockbit, 0, BLOCKSIZE));
                blockbit = this.decipher.doFinal(blockbit);
                len1 = BLOCKSIZE - (int)(pos - pos1);
                if (balength < len1) {
                    len1 = balength;
                }
                System.arraycopy(blockbit, 0, bytes, bytes.length - balength, len1);
                pos += (long)len1;
                balength -= len1;
            }
            this.currentPosition += (long)Math.min(totalread, bytes.length);
            return Math.min(totalread, bytes.length);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void seek(long position) throws IOException {
        try {
            if (position < 0L) {
                throw new ODBRuntimeException(NeoDatisError.NEGATIVE_POSITION.addParameter(position));
            }
            this.currentPosition = position;
            this.fileIO.seek(this.currentPosition);
        }
        catch (IOException e) {
            throw new ODBRuntimeException(NeoDatisError.GO_TO_POSITION.addParameter(position).addParameter(this.fileIO.length()), (Throwable)e);
        }
    }

    public void write(byte b) throws IOException {
        try {
            byte[] bytes = new byte[]{b};
            this.write(bytes, 0, 1);
        }
        catch (IOException e) {
            DLogger.error(e.getMessage() + " - " + OdbThread.getCurrentThreadName());
            throw e;
        }
    }

    public void write(byte[] bytes, int offset, int size) throws IOException {
        try {
            long pos = this.currentPosition;
            int balength = bytes.length;
            long pos1 = pos / (long)BLOCKSIZE * (long)BLOCKSIZE;
            byte[] blockbit = new byte[BLOCKSIZE];
            this.fileIO.seek(pos1);
            if (this.fileIO.read(blockbit, 0, BLOCKSIZE) > 0L) {
                blockbit = this.decipher.doFinal(blockbit);
            }
            this.fileIO.seek(pos1);
            int len1 = BLOCKSIZE - (int)(pos - pos1);
            if (balength < len1) {
                len1 = balength;
            }
            System.arraycopy(bytes, 0, blockbit, (int)(pos - pos1), len1);
            blockbit = this.encipher.doFinal(blockbit);
            this.fileIO.write(blockbit, 0, BLOCKSIZE);
            pos += (long)len1;
            int blocks = (balength -= len1) / BLOCKSIZE;
            for (int i = 0; i < blocks; ++i) {
                pos1 = pos / (long)BLOCKSIZE * (long)BLOCKSIZE;
                this.fileIO.seek(pos1);
                if (this.fileIO.read(blockbit, 0, BLOCKSIZE) > 0L) {
                    blockbit = this.decipher.doFinal(blockbit);
                }
                this.fileIO.seek(pos1);
                len1 = BLOCKSIZE - (int)(pos - pos1);
                if (balength < len1) {
                    len1 = balength;
                }
                System.arraycopy(bytes, bytes.length - balength, blockbit, 0, len1);
                blockbit = this.encipher.doFinal(blockbit);
                this.fileIO.write(blockbit, 0, BLOCKSIZE);
                pos += (long)len1;
                balength -= len1;
            }
            if (balength > 0) {
                blockbit = new byte[BLOCKSIZE];
                pos1 = pos / (long)BLOCKSIZE * (long)BLOCKSIZE;
                this.fileIO.seek(pos1);
                if (this.fileIO.read(blockbit, 0, BLOCKSIZE) > 0L) {
                    blockbit = this.decipher.doFinal(blockbit);
                }
                this.fileIO.seek(pos1);
                len1 = BLOCKSIZE - (int)(pos - pos1);
                if (balength < len1) {
                    len1 = balength;
                }
                System.arraycopy(bytes, bytes.length - balength, blockbit, 0, len1);
                blockbit = this.encipher.doFinal(blockbit);
                this.fileIO.write(blockbit, 0, BLOCKSIZE);
                pos += (long)len1;
                balength -= len1;
            }
            this.currentPosition += (long)bytes.length;
        }
        catch (IOException e) {
            DLogger.error(e.getMessage() + " - " + OdbThread.getCurrentThreadName());
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public long length() throws IOException {
        return this.fileIO.length();
    }

    public boolean lockFile() throws IOException {
        return this.fileIO.lockFile();
    }

    public boolean isLocked() throws IOException {
        return this.fileIO.isLocked();
    }

    public boolean unlockFile() throws IOException {
        return this.fileIO.unlockFile();
    }

    public void flushIO() throws IOException {
        this.fileIO.flushIO();
    }
}

