/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.layers.layer3.engine;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neodatis.btree.IBTree;
import org.neodatis.odb.DatabaseId;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.TransactionId;
import org.neodatis.odb.core.ICoreProvider;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer1.introspector.IClassIntrospector;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ArrayObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.AtomicNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.CIZoneInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoIndex;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoList;
import org.neodatis.odb.core.layers.layer2.meta.CollectionObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.CommittedCIZoneInfo;
import org.neodatis.odb.core.layers.layer2.meta.EnumNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.MapObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.MetaModel;
import org.neodatis.odb.core.layers.layer2.meta.NativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeNullObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NullNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.layers.layer2.meta.ObjectReference;
import org.neodatis.odb.core.layers.layer2.meta.compare.ArrayModifyElement;
import org.neodatis.odb.core.layers.layer2.meta.compare.ChangedAttribute;
import org.neodatis.odb.core.layers.layer2.meta.compare.ChangedNativeAttributeAction;
import org.neodatis.odb.core.layers.layer2.meta.compare.ChangedObjectReferenceAttributeAction;
import org.neodatis.odb.core.layers.layer2.meta.compare.IObjectInfoComparator;
import org.neodatis.odb.core.layers.layer2.meta.compare.NewNonNativeObjectAction;
import org.neodatis.odb.core.layers.layer2.meta.compare.SetAttributeToNullAction;
import org.neodatis.odb.core.layers.layer3.IIdManager;
import org.neodatis.odb.core.layers.layer3.IObjectReader;
import org.neodatis.odb.core.layers.layer3.IObjectWriter;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.layers.layer3.engine.IByteArrayConverter;
import org.neodatis.odb.core.layers.layer3.engine.IFileSystemInterface;
import org.neodatis.odb.core.oid.OIDFactory;
import org.neodatis.odb.core.transaction.ICache;
import org.neodatis.odb.core.transaction.ICrossSessionCache;
import org.neodatis.odb.core.transaction.ISession;
import org.neodatis.odb.core.transaction.ITmpCache;
import org.neodatis.odb.core.trigger.ITriggerManager;
import org.neodatis.odb.impl.core.layers.layer2.meta.compare.ObjectInfoComparator;
import org.neodatis.odb.impl.core.layers.layer2.meta.history.InsertHistoryInfo;
import org.neodatis.odb.impl.core.layers.layer3.engine.StorageEngineConstant;
import org.neodatis.odb.impl.core.oid.OdbClassOID;
import org.neodatis.odb.impl.core.oid.OdbObjectOID;
import org.neodatis.odb.impl.core.oid.TransactionIdImpl;
import org.neodatis.odb.impl.core.transaction.CacheFactory;
import org.neodatis.odb.impl.tool.Cryptographer;
import org.neodatis.odb.impl.tool.UUID;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.DisplayUtility;
import org.neodatis.tool.wrappers.OdbComparable;
import org.neodatis.tool.wrappers.OdbString;
import org.neodatis.tool.wrappers.OdbTime;
import org.neodatis.tool.wrappers.list.IOdbList;

public abstract class AbstractObjectWriter
implements IObjectWriter {
    private static final int NON_NATIVE_HEADER_BLOCK_SIZE = ODBType.INTEGER.getSize() + ODBType.BYTE.getSize() + ODBType.LONG.getSize();
    private static final int NATIVE_HEADER_BLOCK_SIZE = ODBType.INTEGER.getSize() + ODBType.BYTE.getSize() + ODBType.INTEGER.getSize() + ODBType.BOOLEAN.getSize();
    private static byte[] NATIVE_HEADER_BLOCK_SIZE_BYTE = null;
    protected static int nbInPlaceUpdates = 0;
    protected static int nbNormalUpdates = 0;
    public static final String LOG_ID = "ObjectWriter";
    public static final String LOG_ID_DEBUG = "ObjectWriter.debug";
    protected IStorageEngine storageEngine;
    protected IObjectReader objectReader;
    public IClassIntrospector classIntrospector;
    public IFileSystemInterface fsi;
    private int currentDepth;
    protected IIdManager idManager;
    protected ITriggerManager triggerManager;
    protected IByteArrayConverter byteArrayConverter;
    private static int nbCallsToUpdate;
    private boolean isLocalMode;
    protected IObjectInfoComparator comparator;

    public AbstractObjectWriter(IStorageEngine engine) {
        this.storageEngine = engine;
        this.objectReader = this.storageEngine.getObjectReader();
        this.isLocalMode = this.storageEngine.isLocal();
        ICoreProvider provider = OdbConfiguration.getCoreProvider();
        this.byteArrayConverter = provider.getByteArrayConverter();
        this.classIntrospector = provider.getClassIntrospector();
        NATIVE_HEADER_BLOCK_SIZE_BYTE = this.byteArrayConverter.intToByteArray(NATIVE_HEADER_BLOCK_SIZE);
        this.comparator = new ObjectInfoComparator();
    }

    public abstract ISession getSession();

    public abstract IFileSystemInterface buildFSI();

    public void init2() {
        this.fsi = this.buildFSI();
    }

    public void afterInit() {
        this.objectReader = this.storageEngine.getObjectReader();
        this.idManager = OdbConfiguration.getCoreProvider().getClientIdManager(this.storageEngine);
    }

    public void createEmptyDatabaseHeader(long creationDate, String user, String password) {
        this.writeEncrytionFlag(false, false);
        this.writeVersion(false);
        DatabaseId databaseId = this.writeDatabaseId(creationDate, false);
        this.writeReplicationFlag(false, false);
        TransactionIdImpl tid = new TransactionIdImpl(databaseId, 0L, 1L);
        this.storageEngine.setCurrentTransactionId(tid);
        this.writeLastTransactionId(tid);
        this.writeNumberOfClasses(0L, false);
        this.writeFirstClassInfoOID(StorageEngineConstant.NULL_OBJECT_ID, false);
        this.writeLastODBCloseStatus(false, false);
        this.writeDatabaseCharacterEncoding(false);
        this.writeUserAndPassword(user, password, false);
        this.fsi.writeLong(StorageEngineConstant.DATABASE_HEADER_FIRST_ID_BLOCK_POSITION, false, "current id block position", 3);
        this.writeIdBlock(-1L, OdbConfiguration.getIdBlockSize(), (byte)1, 1, -1L, false);
        this.storageEngine.setCurrentIdBlockInfos(StorageEngineConstant.DATABASE_HEADER_FIRST_ID_BLOCK_POSITION, 1, OIDFactory.buildObjectOID(0L));
        this.fsi.flush();
    }

    public void writeUserAndPassword(String user, String password, boolean writeInTransaction) {
        if (user != null && password != null) {
            String encryptedPassword = Cryptographer.encrypt(password);
            this.fsi.writeBoolean(true, writeInTransaction, "has user and password");
            if (user.length() > 20) {
                throw new ODBRuntimeException(NeoDatisError.USER_NAME_TOO_LONG.addParameter(user).addParameter(20));
            }
            if (password.length() > 20) {
                throw new ODBRuntimeException(NeoDatisError.PASSWORD_TOO_LONG.addParameter(20));
            }
            this.fsi.writeString(user, writeInTransaction, true, 50);
            this.fsi.setWritePosition(StorageEngineConstant.DATABASE_HEADER_DATABASE_PASSWORD, writeInTransaction);
            this.fsi.writeString(encryptedPassword, writeInTransaction, true, 50);
        } else {
            this.fsi.writeBoolean(false, writeInTransaction, "database without user and password");
            this.fsi.writeString("no-user", writeInTransaction, true, 50);
            this.fsi.writeString("no-password", writeInTransaction, true, 50);
        }
    }

    public void writeEncrytionFlag(boolean useEncryption, boolean writeInTransaction) {
        this.fsi.setWritePosition(0L, writeInTransaction);
        this.fsi.writeByte(useEncryption ? (byte)1 : 0, writeInTransaction, "encryption flag");
    }

    public void writeVersion(boolean writeInTransaction) {
        this.fsi.setWritePosition(StorageEngineConstant.DATABASE_HEADER_VERSION_POSITION, writeInTransaction);
        this.fsi.writeInt(9, writeInTransaction, "database file format version");
        this.storageEngine.setVersion(9);
    }

    public DatabaseId writeDatabaseId(long creationDate, boolean writeInTransaction) {
        DatabaseId databaseId = UUID.getDatabaseId(creationDate);
        this.fsi.writeLong(databaseId.getIds()[0], writeInTransaction, "database id 1/4", 3);
        this.fsi.writeLong(databaseId.getIds()[1], writeInTransaction, "database id 2/4", 3);
        this.fsi.writeLong(databaseId.getIds()[2], writeInTransaction, "database id 3/4", 3);
        this.fsi.writeLong(databaseId.getIds()[3], writeInTransaction, "database id 4/4", 3);
        this.storageEngine.setDatabaseId(databaseId);
        return databaseId;
    }

    public void writeReplicationFlag(boolean useReplication, boolean writeInTransaction) {
        this.fsi.setWritePosition(StorageEngineConstant.DATABASE_HEADER_USE_REPLICATION_POSITION, writeInTransaction);
        this.fsi.writeByte(useReplication ? (byte)1 : 0, writeInTransaction, "replication flag");
    }

    public void writeLastTransactionId(TransactionId transactionId) {
        this.fsi.setWritePosition(StorageEngineConstant.DATABASE_HEADER_LAST_TRANSACTION_ID, false);
        this.fsi.writeLong(transactionId.getId1(), false, "last transaction id 1/2", 3);
        this.fsi.writeLong(transactionId.getId2(), false, "last transaction id 2/2", 3);
    }

    public void writeNumberOfClasses(long number, boolean writeInTransaction) {
        this.fsi.setWritePosition(StorageEngineConstant.DATABASE_HEADER_NUMBER_OF_CLASSES_POSITION, writeInTransaction);
        this.fsi.writeLong(number, writeInTransaction, "nb classes", 3);
    }

    public void writeLastODBCloseStatus(boolean ok, boolean writeInTransaction) {
        this.fsi.setWritePosition(StorageEngineConstant.DATABASE_HEADER_LAST_CLOSE_STATUS_POSITION, writeInTransaction);
        this.fsi.writeBoolean(ok, writeInTransaction, "odb last close status");
    }

    public void writeDatabaseCharacterEncoding(boolean writeInTransaction) {
        this.fsi.setWritePosition(StorageEngineConstant.DATABASE_HEADER_DATABASE_CHARACTER_ENCODING_POSITION, writeInTransaction);
        if (OdbConfiguration.hasEncoding()) {
            this.fsi.writeString(OdbConfiguration.getDatabaseCharacterEncoding(), writeInTransaction, true, 50);
        } else {
            this.fsi.writeString("no-encoding", writeInTransaction, false, 50);
        }
    }

    public long writeIdBlock(long position, int idBlockSize, byte blockStatus, int blockNumber, long previousBlockPosition, boolean writeInTransaction) {
        if (position == -1L) {
            position = this.fsi.getAvailablePosition();
        }
        this.fsi.setWritePosition(StorageEngineConstant.DATABASE_HEADER_CURRENT_ID_BLOCK_POSITION, writeInTransaction);
        this.fsi.writeLong(position, false, "current id block position", 3);
        this.fsi.setWritePosition(position, writeInTransaction);
        this.fsi.writeInt(idBlockSize, writeInTransaction, "block size");
        this.fsi.writeByte((byte)20, writeInTransaction);
        this.fsi.writeByte(blockStatus, writeInTransaction);
        this.fsi.writeLong(previousBlockPosition, writeInTransaction, "prev block pos", 3);
        this.fsi.writeLong(-1L, writeInTransaction, "next block pos", 3);
        this.fsi.writeInt(blockNumber, writeInTransaction, "id block number");
        this.fsi.writeLong(0L, writeInTransaction, "id block max id", 3);
        this.fsi.setWritePosition(position + (long)OdbConfiguration.getIdBlockSize() - 1L, writeInTransaction);
        this.fsi.writeByte((byte)0, writeInTransaction);
        if (OdbConfiguration.isDebugEnabled(LOG_ID_DEBUG)) {
            DLogger.debug(this.depthToSpaces() + "After create block, available position is " + this.fsi.getAvailablePosition());
        }
        return position;
    }

    public long markIdBlockAsFull(long blockPosition, long nextBlockPosition, boolean writeInTransaction) {
        this.fsi.setWritePosition(blockPosition + StorageEngineConstant.BLOCK_ID_OFFSET_FOR_BLOCK_STATUS, writeInTransaction);
        this.fsi.writeByte((byte)2, writeInTransaction);
        this.fsi.setWritePosition(blockPosition + StorageEngineConstant.BLOCK_ID_OFFSET_FOR_NEXT_BLOCK, writeInTransaction);
        this.fsi.writeLong(nextBlockPosition, writeInTransaction, "next id block pos", 3);
        return blockPosition;
    }

    public long associateIdToObject(byte idType, byte idStatus, long currentBlockIdPosition, OID oid, long objectPosition, boolean writeInTransaction) {
        this.fsi.setWritePosition(currentBlockIdPosition + StorageEngineConstant.BLOCK_ID_OFFSET_FOR_MAX_ID, writeInTransaction);
        this.fsi.writeLong(oid.getObjectId(), writeInTransaction, "id block max id update", 2);
        long l1 = (oid.getObjectId() - 1L) % (long)OdbConfiguration.getNB_IDS_PER_BLOCK();
        long l2 = StorageEngineConstant.BLOCK_ID_OFFSET_FOR_START_OF_REPETITION;
        long idPosition = currentBlockIdPosition + StorageEngineConstant.BLOCK_ID_OFFSET_FOR_START_OF_REPETITION + l1 * (long)OdbConfiguration.getID_BLOCK_REPETITION_SIZE();
        this.fsi.setWritePosition(idPosition, writeInTransaction);
        this.fsi.writeByte(idType, writeInTransaction, "id type");
        this.fsi.writeLong(oid.getObjectId(), writeInTransaction, "oid", 2);
        this.fsi.writeByte(idStatus, writeInTransaction, "id status");
        this.fsi.writeLong(objectPosition, writeInTransaction, "obj pos", 2);
        return idPosition;
    }

    public void updateObjectPositionForObjectOIDWithPosition(long idPosition, long objectPosition, boolean writeInTransaction) {
        this.fsi.setWritePosition(idPosition, writeInTransaction);
        this.fsi.writeByte((byte)1, writeInTransaction, "id type");
        this.fsi.setWritePosition(idPosition + StorageEngineConstant.BLOCK_ID_REPETITION_ID_STATUS, writeInTransaction);
        this.fsi.writeByte((byte)1, writeInTransaction);
        this.fsi.writeLong(objectPosition, writeInTransaction, "Updating object position of id", 2);
    }

    public void updateClassPositionForClassOIDWithPosition(long idPosition, long objectPosition, boolean writeInTransaction) {
        this.fsi.setWritePosition(idPosition, writeInTransaction);
        this.fsi.writeByte((byte)2, writeInTransaction, "id type");
        this.fsi.setWritePosition(idPosition + StorageEngineConstant.BLOCK_ID_REPETITION_ID_STATUS, writeInTransaction);
        this.fsi.writeByte((byte)1, writeInTransaction);
        this.fsi.writeLong(objectPosition, writeInTransaction, "Updating class position of id", 2);
    }

    public void updateStatusForIdWithPosition(long idPosition, byte newStatus, boolean writeInTransaction) {
        this.fsi.setWritePosition(idPosition + StorageEngineConstant.BLOCK_ID_REPETITION_ID_STATUS, writeInTransaction);
        this.fsi.writeByte(newStatus, writeInTransaction, "Updating id status");
    }

    public ClassInfo persistClass(ClassInfo newClassInfo, int lastClassInfoIndex, boolean addClass, boolean addDependentClasses) {
        MetaModel metaModel = this.getSession().getMetaModel();
        OID classInfoId = newClassInfo.getId();
        if (classInfoId == null) {
            classInfoId = this.getIdManager().getNextClassId(-1L);
            newClassInfo.setId(classInfoId);
        }
        long writePosition = this.fsi.getAvailablePosition();
        newClassInfo.setPosition(writePosition);
        this.getIdManager().updateClassPositionForId(classInfoId, writePosition, true);
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("Persisting class into database : " + newClassInfo.getFullClassName() + " with oid " + classInfoId + " at pos " + writePosition);
            DLogger.debug("class " + newClassInfo.getFullClassName() + " has " + newClassInfo.getNumberOfAttributes() + " attributes : " + newClassInfo.getAttributes());
        }
        if (metaModel.getNumberOfClasses() > 0 && lastClassInfoIndex != -2) {
            ClassInfo lastClassinfo = null;
            lastClassinfo = lastClassInfoIndex == -1 ? metaModel.getLastClassInfo() : metaModel.getClassInfo(lastClassInfoIndex);
            lastClassinfo.setNextClassOID(newClassInfo.getId());
            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                DLogger.debug("changing next class oid. of class info " + lastClassinfo.getFullClassName() + " @ " + lastClassinfo.getPosition() + " + offset " + StorageEngineConstant.CLASS_OFFSET_NEXT_CLASS_POSITION + " to " + newClassInfo.getId() + "(" + newClassInfo.getFullClassName() + ")");
            }
            this.fsi.setWritePosition(lastClassinfo.getPosition() + StorageEngineConstant.CLASS_OFFSET_NEXT_CLASS_POSITION, true);
            this.fsi.writeLong(newClassInfo.getId().getObjectId(), true, "next class oid", 2);
            newClassInfo.setPreviousClassOID(lastClassinfo.getId());
        }
        if (addClass) {
            metaModel.addClass(newClassInfo);
        }
        this.writeNumberOfClasses(metaModel.getNumberOfClasses(), true);
        if (newClassInfo.getPreviousClassOID() == null) {
            this.writeFirstClassInfoOID(newClassInfo.getId(), true);
        }
        this.writeClassInfoHeader(newClassInfo, writePosition, false);
        if (addDependentClasses) {
            IOdbList<ClassAttributeInfo> dependingAttributes = newClassInfo.getAllNonNativeAttributes();
            ClassAttributeInfo cai = null;
            for (int i = 0; i < dependingAttributes.size(); ++i) {
                cai = dependingAttributes.get(i);
                try {
                    ClassInfo existingCI = metaModel.getClassInfo(cai.getFullClassname(), false);
                    if (existingCI == null) {
                        this.addClasses(this.classIntrospector.introspect(cai.getFullClassname(), true));
                        continue;
                    }
                    cai.setClassInfo(existingCI);
                    continue;
                }
                catch (Exception e) {
                    throw new ODBRuntimeException(NeoDatisError.CLASS_INTROSPECTION_ERROR.addParameter(cai.getFullClassname()), (Throwable)e);
                }
            }
        }
        this.writeClassInfoBody(newClassInfo, this.fsi.getAvailablePosition(), true);
        return newClassInfo;
    }

    public ClassInfo addClass(ClassInfo newClassInfo, boolean addDependentClasses) {
        ClassInfo classInfo = this.getSession().getMetaModel().getClassInfo(newClassInfo.getFullClassName(), false);
        if (classInfo != null && classInfo.getPosition() != -1L) {
            return classInfo;
        }
        return this.persistClass(newClassInfo, -1, true, addDependentClasses);
    }

    public ClassInfoList addClasses(ClassInfoList classInfoList) {
        Iterator<ClassInfo> iterator = classInfoList.getClassInfos().iterator();
        while (iterator.hasNext()) {
            this.addClass(iterator.next(), true);
        }
        return classInfoList;
    }

    public void writeClassInfoHeader(ClassInfo classInfo, long position, boolean writeInTransaction) {
        OID classId = classInfo.getId();
        if (classId == null) {
            classId = this.idManager.getNextClassId(position);
            classInfo.setId(classId);
        } else {
            this.idManager.updateClassPositionForId(classId, position, true);
        }
        this.fsi.setWritePosition(position, writeInTransaction);
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug(this.depthToSpaces() + "Writing new Class info header at " + position + " : " + classInfo.toString());
        }
        this.fsi.writeInt(0, writeInTransaction, "block size");
        this.fsi.writeByte((byte)1, writeInTransaction, "class header block type");
        this.fsi.writeByte(classInfo.getClassCategory(), writeInTransaction, "Class info category");
        this.fsi.writeLong(classId.getObjectId(), writeInTransaction, "class id", 1);
        this.writeOid(classInfo.getPreviousClassOID(), writeInTransaction, "prev class oid", 1);
        this.writeOid(classInfo.getNextClassOID(), writeInTransaction, "next class oid", 1);
        this.fsi.writeLong(classInfo.getCommitedZoneInfo().getNbObjects(), writeInTransaction, "class nb objects", 1);
        this.writeOid(classInfo.getCommitedZoneInfo().first, writeInTransaction, "class first obj pos", 1);
        this.writeOid(classInfo.getCommitedZoneInfo().last, writeInTransaction, "class last obj pos", 1);
        this.fsi.writeString(classInfo.getFullClassName(), false, writeInTransaction);
        this.fsi.writeInt(classInfo.getMaxAttributeId(), writeInTransaction, "Max attribute id");
        if (classInfo.getAttributesDefinitionPosition() != -1L) {
            this.fsi.writeLong(classInfo.getAttributesDefinitionPosition(), writeInTransaction, "class att def pos", 1);
        } else {
            this.fsi.writeLong(-1L, writeInTransaction, "class att def pos", 1);
        }
        int blockSize = (int)(this.fsi.getPosition() - position);
        this.writeBlockSizeAt(position, blockSize, writeInTransaction, classInfo);
    }

    public void encodeOid(OID oid, byte[] bytes, int offset) {
        if (oid == null) {
            this.byteArrayConverter.longToByteArray(-1L, bytes, offset);
        } else {
            this.byteArrayConverter.longToByteArray(oid.getObjectId(), bytes, offset);
        }
    }

    public void writeOid(OID oid, boolean writeInTransaction, String label, int writeAction) {
        if (oid == null) {
            this.fsi.writeLong(-1L, writeInTransaction, label, writeAction);
        } else {
            this.fsi.writeLong(oid.getObjectId(), writeInTransaction, label, writeAction);
        }
    }

    public void writeClassInfoBody(ClassInfo classInfo, long position, boolean writeInTransaction) {
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug(this.depthToSpaces() + "Writing new Class info body at " + position + " : " + classInfo.toString());
        }
        classInfo.setAttributesDefinitionPosition(position);
        this.writeClassInfoHeader(classInfo, classInfo.getPosition(), writeInTransaction);
        this.fsi.setWritePosition(position, writeInTransaction);
        this.fsi.writeInt(0, writeInTransaction, "block size");
        this.fsi.writeByte((byte)2, writeInTransaction);
        this.fsi.writeLong(classInfo.getAttributes().size(), writeInTransaction, "class nb attributes", 1);
        ClassAttributeInfo cai = null;
        for (int i = 0; i < classInfo.getAttributes().size(); ++i) {
            cai = classInfo.getAttributes().get(i);
            this.writeClassAttributeInfo(cai, writeInTransaction);
        }
        int blockSize = (int)(this.fsi.getPosition() - position);
        this.writeBlockSizeAt(position, blockSize, writeInTransaction, classInfo);
    }

    public long writeClassInfoIndexes(ClassInfo classInfo) {
        boolean writeInTransaction = true;
        long position = this.fsi.getAvailablePosition();
        this.fsi.setWritePosition(position, writeInTransaction);
        ClassInfoIndex cii = null;
        long previousIndexPosition = -1L;
        long currentIndexPosition = position;
        long nextIndexPosition = -1L;
        long currentPosition = -1L;
        for (int i = 0; i < classInfo.getNumberOfIndexes(); ++i) {
            currentIndexPosition = this.fsi.getPosition();
            cii = classInfo.getIndex(i);
            this.fsi.writeInt(0, writeInTransaction, "block size");
            this.fsi.writeByte((byte)21, true, "Index block type");
            this.fsi.writeLong(previousIndexPosition, writeInTransaction, "prev index pos", 2);
            this.fsi.writeLong(-1L, writeInTransaction, "next index pos", 2);
            this.fsi.writeString(cii.getName(), false, writeInTransaction);
            this.fsi.writeBoolean(cii.isUnique(), writeInTransaction, "index is unique");
            this.fsi.writeByte(cii.getStatus(), writeInTransaction, "index status");
            this.fsi.writeLong(cii.getCreationDate(), writeInTransaction, "creation date", 1);
            this.fsi.writeLong(cii.getLastRebuild(), writeInTransaction, "last rebuild", 1);
            this.fsi.writeInt(cii.getAttributeIds().length, writeInTransaction, "number of fields");
            for (int j = 0; j < cii.getAttributeIds().length; ++j) {
                this.fsi.writeInt(cii.getAttributeIds()[j], writeInTransaction, "attr id");
            }
            currentPosition = this.fsi.getPosition();
            int blockSize = (int)(this.fsi.getPosition() - currentIndexPosition);
            this.writeBlockSizeAt(currentIndexPosition, blockSize, writeInTransaction, classInfo);
            nextIndexPosition = i + 1 < classInfo.getNumberOfIndexes() ? currentPosition : -1L;
            this.fsi.setWritePosition(currentIndexPosition + (long)ODBType.INTEGER.getSize() + (long)ODBType.BYTE.getSize() + (long)ODBType.LONG.getSize(), writeInTransaction);
            this.fsi.writeLong(nextIndexPosition, writeInTransaction, "next index pos", 2);
            previousIndexPosition = currentIndexPosition;
            this.fsi.setWritePosition(currentPosition, writeInTransaction);
        }
        return position;
    }

    public void updateClassInfo(ClassInfo classInfo, boolean writeInTransaction) {
        IOdbList<ClassAttributeInfo> dependingAttributes = classInfo.getAllNonNativeAttributes();
        MetaModel metaModel = this.getSession().getMetaModel();
        ClassAttributeInfo cai = null;
        for (int i = 0; i < dependingAttributes.size(); ++i) {
            cai = dependingAttributes.get(i);
            try {
                ClassInfo existingCI = metaModel.getClassInfo(cai.getFullClassname(), false);
                if (existingCI == null) {
                    this.addClasses(this.classIntrospector.introspect(cai.getFullClassname(), true));
                    continue;
                }
                cai.setClassInfo(existingCI);
                continue;
            }
            catch (Exception e) {
                throw new ODBRuntimeException(NeoDatisError.CLASS_INTROSPECTION_ERROR.addParameter(cai.getFullClassname()), (Throwable)e);
            }
        }
        classInfo.setAttributesDefinitionPosition(-1L);
        long newCiPosition = this.fsi.getAvailablePosition();
        classInfo.setPosition(newCiPosition);
        this.writeClassInfoHeader(classInfo, newCiPosition, writeInTransaction);
        this.writeClassInfoBody(classInfo, this.fsi.getAvailablePosition(), writeInTransaction);
    }

    public void writeFirstClassInfoOID(OID classInfoID, boolean inTransaction) {
        long positionToWrite = StorageEngineConstant.DATABASE_HEADER_FIRST_CLASS_OID;
        this.fsi.setWritePosition(positionToWrite, inTransaction);
        this.writeOid(classInfoID, inTransaction, "first class info oid", 1);
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug(this.depthToSpaces() + "Updating first class info oid at " + positionToWrite + " with oid " + classInfoID);
        }
    }

    private void updateNextClassInfoPositionOfClassInfo(long classInfoPosition, long newCiPosition) {
        this.fsi.setWritePosition(classInfoPosition + StorageEngineConstant.CLASS_OFFSET_NEXT_CLASS_POSITION, true);
        this.fsi.writeLong(newCiPosition, true, "new next ci position", 1);
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug(this.depthToSpaces() + "Updating next class info of class info at " + classInfoPosition + " with " + classInfoPosition);
        }
    }

    private void updatePreviousClassInfoPositionOfClassInfo(long classInfoPosition, long newCiPosition) {
        this.fsi.setWritePosition(classInfoPosition + StorageEngineConstant.CLASS_OFFSET_PREVIOUS_CLASS_POSITION, true);
        this.fsi.writeLong(newCiPosition, true, "new prev ci position", 1);
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug(this.depthToSpaces() + "Updating prev class info of class info at " + classInfoPosition + " with " + classInfoPosition);
        }
    }

    private void writeClassAttributeInfo(ClassAttributeInfo cai, boolean writeInTransaction) {
        this.fsi.writeInt(cai.getId(), writeInTransaction, "attribute id");
        this.fsi.writeBoolean(cai.isNative(), writeInTransaction);
        if (cai.isNative()) {
            this.fsi.writeInt(cai.getAttributeType().getId(), writeInTransaction, "att odb type id");
            if (cai.getAttributeType().isArray()) {
                this.fsi.writeInt(cai.getAttributeType().getSubType().getId(), writeInTransaction, "att array sub type");
                if (cai.getAttributeType().getSubType().isNonNative()) {
                    this.fsi.writeLong(this.storageEngine.getSession(true).getMetaModel().getClassInfo(cai.getAttributeType().getSubType().getName(), true).getId().getObjectId(), writeInTransaction, "class info id of array subtype", 1);
                }
            }
            if (cai.getAttributeType().isEnum()) {
                this.fsi.writeLong(this.storageEngine.getSession(true).getMetaModel().getClassInfo(cai.getFullClassname(), true).getId().getObjectId(), writeInTransaction, "class info id", 1);
            }
        } else {
            this.fsi.writeLong(this.storageEngine.getSession(true).getMetaModel().getClassInfo(cai.getFullClassname(), true).getId().getObjectId(), writeInTransaction, "class info id", 1);
        }
        this.fsi.writeString(cai.getName(), false, writeInTransaction);
        this.fsi.writeBoolean(cai.isIndex(), writeInTransaction);
    }

    private long writeNativeObjectInfo(NativeObjectInfo noi, long position, boolean updatePointers, boolean writeInTransaction) {
        if (OdbConfiguration.isDebugEnabled(LOG_ID_DEBUG)) {
            DLogger.debug(this.depthToSpaces() + "Writing native object at " + position + " : Type=" + ODBType.getNameFromId(noi.getOdbTypeId()) + " | Value=" + noi.toString());
        }
        if (noi.isAtomicNativeObject()) {
            return this.writeAtomicNativeObject((AtomicNativeObjectInfo)noi, writeInTransaction);
        }
        if (noi.isNull()) {
            this.writeNullNativeObjectHeader(noi.getOdbTypeId(), writeInTransaction);
            return position;
        }
        if (noi.isCollectionObject()) {
            return this.writeCollection((CollectionObjectInfo)noi, writeInTransaction);
        }
        if (noi.isMapObject()) {
            return this.writeMap((MapObjectInfo)noi, writeInTransaction);
        }
        if (noi.isArrayObject()) {
            return this.writeArray((ArrayObjectInfo)noi, writeInTransaction);
        }
        if (noi.isEnumObject()) {
            return this.writeEnumNativeObject((EnumNativeObjectInfo)noi, writeInTransaction);
        }
        throw new ODBRuntimeException(NeoDatisError.NATIVE_TYPE_NOT_SUPPORTED.addParameter(noi.getOdbTypeId()));
    }

    public OID writeNonNativeObjectInfo(OID existingOid, NonNativeObjectInfo objectInfo, long position, boolean writeDataInTransaction, boolean isNewObject) {
        OID oid;
        String className;
        boolean hasObject;
        ISession lsession = this.getSession();
        ICache cache = lsession.getCache();
        boolean bl = hasObject = objectInfo.getObject() != null;
        if (isNewObject && !this.isLocalMode) {
            this.triggerManager.manageInsertTriggerBefore(objectInfo.getClassInfo().getFullClassName(), objectInfo);
        }
        if (objectInfo.isNull()) {
            return StorageEngineConstant.NULL_OBJECT_ID;
        }
        MetaModel metaModel = lsession.getMetaModel();
        if (!metaModel.existClass(className = objectInfo.getClassInfo().getFullClassName())) {
            this.addClass(objectInfo.getClassInfo(), true);
        }
        if (position == -1L) {
            position = this.fsi.getAvailablePosition();
            objectInfo.setPosition(position);
        }
        if ((oid = existingOid) == null) {
            if (this.idManager.mustShift()) {
                oid = this.idManager.getNextObjectId(position);
                position = this.fsi.getAvailablePosition();
                this.idManager.updateObjectPositionForOid(oid, position, false);
            } else {
                oid = this.idManager.getNextObjectId(position);
            }
        } else {
            this.idManager.updateObjectPositionForOid(oid, position, true);
            cache.savePositionOfObjectWithOid(oid, position);
        }
        cache.updateIdOfInsertingObject(objectInfo.getObject(), oid);
        if (isNewObject) {
            cache.addOIDToUnconnectedZone(oid);
            if (OdbConfiguration.reconnectObjectsToSession()) {
                ICrossSessionCache crossSessionCache = CacheFactory.getCrossSessionCache(this.storageEngine.getBaseIdentification().getIdentification());
                crossSessionCache.addObject(objectInfo.getObject(), oid);
            }
        }
        objectInfo.setOid(oid);
        if (isNewObject && this.triggerManager.hasOidTriggersFor(className)) {
            this.triggerManager.manageOidTrigger(objectInfo, oid);
        }
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug(this.depthToSpaces() + "Start Writing non native object of type " + objectInfo.getClassInfo().getFullClassName() + " at " + position + " , oid = " + oid + " : " + objectInfo.toString());
        }
        if (objectInfo.getClassInfo() == null || objectInfo.getClassInfo().getId() == null) {
            if (objectInfo.getClassInfo() != null) {
                ClassInfo clinfo = this.storageEngine.getSession(true).getMetaModel().getClassInfo(objectInfo.getClassInfo().getFullClassName(), true);
                objectInfo.setClassInfo(clinfo);
            } else {
                throw new ODBRuntimeException(NeoDatisError.UNDEFINED_CLASS_INFO.addParameter(objectInfo.toString()));
            }
        }
        ClassInfo classInfo = this.addClass(objectInfo.getClassInfo(), true);
        objectInfo.setClassInfo(classInfo);
        if (isNewObject) {
            this.manageNewObjectPointers(objectInfo, classInfo, position, metaModel);
        }
        if (OdbConfiguration.saveHistory()) {
            classInfo.addHistory(new InsertHistoryInfo("insert", oid, position, objectInfo.getPreviousObjectOID(), objectInfo.getNextObjectOID()));
        }
        this.fsi.setWritePosition(position, writeDataInTransaction);
        objectInfo.setPosition(position);
        int nbAttributes = objectInfo.getClassInfo().getAttributes().size();
        int tsize = 7 * ODBType.SIZE_OF_LONG + 3 * ODBType.SIZE_OF_INT + 2 * ODBType.SIZE_OF_BYTE;
        byte[] bytes = new byte[tsize];
        this.byteArrayConverter.intToByteArray(0, bytes, 0);
        bytes[4] = 4;
        this.encodeOid(oid, bytes, 5);
        this.byteArrayConverter.longToByteArray(classInfo.getId().getObjectId(), bytes, 13);
        this.encodeOid(objectInfo.getPreviousObjectOID(), bytes, 21);
        this.encodeOid(objectInfo.getNextObjectOID(), bytes, 29);
        this.byteArrayConverter.longToByteArray(objectInfo.getHeader().getCreationDate(), bytes, 37);
        this.byteArrayConverter.longToByteArray(OdbTime.getCurrentTimeInMs(), bytes, 45);
        this.byteArrayConverter.intToByteArray(objectInfo.getHeader().getObjectVersion(), bytes, 53);
        this.byteArrayConverter.longToByteArray(-1L, bytes, 57);
        this.byteArrayConverter.booleanToByteArray(false, bytes, 65);
        this.byteArrayConverter.intToByteArray(nbAttributes, bytes, 66);
        this.fsi.writeBytes(bytes, writeDataInTransaction, "NonNativeObjectInfoHeader");
        long attributePositionStart = this.fsi.getPosition();
        int attributeSize = ODBType.SIZE_OF_INT + ODBType.SIZE_OF_LONG;
        byte[] abytes = new byte[nbAttributes * attributeSize];
        this.fsi.writeBytes(abytes, writeDataInTransaction, "Empty Attributes");
        long[] attributesIdentification = new long[nbAttributes];
        int[] attributeIds = new int[nbAttributes];
        ClassAttributeInfo cai = null;
        AbstractObjectInfo aoi2 = null;
        long nativeAttributePosition = -1L;
        OID nonNativeAttributeOid = null;
        long maxWritePosition = this.fsi.getPosition();
        for (int i = 0; i < nbAttributes; ++i) {
            cai = classInfo.getAttributeInfo(i);
            attributeIds[i] = cai.getId();
            aoi2 = objectInfo.getAttributeValueFromId(cai.getId());
            if (aoi2 == null) {
                aoi2 = cai.isNative() ? new NullNativeObjectInfo(cai.getAttributeType().getId()) : new NonNativeNullObjectInfo(cai.getClassInfo());
            }
            if (aoi2.isNative()) {
                attributesIdentification[i] = nativeAttributePosition = this.internalStoreObject((NativeObjectInfo)aoi2);
            } else {
                if (aoi2.isObjectReference()) {
                    ObjectReference or = (ObjectReference)aoi2;
                    nonNativeAttributeOid = or.getOid();
                } else {
                    nonNativeAttributeOid = this.storeObject(null, (NonNativeObjectInfo)aoi2);
                }
                attributesIdentification[i] = nonNativeAttributeOid != null ? -nonNativeAttributeOid.getObjectId() : 0L;
            }
            long p = this.fsi.getPosition();
            if (p <= maxWritePosition) continue;
            maxWritePosition = p;
        }
        objectInfo.getHeader().setAttributesIdentification(attributesIdentification);
        objectInfo.getHeader().setAttributesIds(attributeIds);
        long positionAfterWrite = maxWritePosition;
        this.fsi.setWritePosition(attributePositionStart, writeDataInTransaction);
        abytes = new byte[attributesIdentification.length * attributeSize];
        for (int i = 0; i < attributesIdentification.length; ++i) {
            this.byteArrayConverter.intToByteArray(attributeIds[i], abytes, i * attributeSize);
            this.byteArrayConverter.longToByteArray(attributesIdentification[i], abytes, i * attributeSize + ODBType.SIZE_OF_INT);
            AbstractObjectInfo aoi = objectInfo.getAttributeValueFromId(attributeIds[i]);
            if (aoi == null || !aoi.isNonNativeObject() || attributesIdentification[i] <= 0L) continue;
            throw new ODBRuntimeException(NeoDatisError.NON_NATIVE_ATTRIBUTE_STORED_BY_POSITION_INSTEAD_OF_OID.addParameter(classInfo.getAttributeInfo(i).getName()).addParameter(classInfo.getFullClassName()).addParameter(attributesIdentification[i]));
        }
        this.fsi.writeBytes(abytes, writeDataInTransaction, "Filled Attributes");
        this.fsi.setWritePosition(positionAfterWrite, writeDataInTransaction);
        int blockSize = (int)(positionAfterWrite - position);
        try {
            this.writeBlockSizeAt(position, blockSize, writeDataInTransaction, objectInfo);
        }
        catch (ODBRuntimeException e) {
            DLogger.debug("Error while writing block size. pos after write " + positionAfterWrite + " / start pos = " + position);
            throw e;
        }
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug(this.depthToSpaces() + "  Attributes positions of object with oid " + oid + " are " + DisplayUtility.longArrayToString(attributesIdentification));
            DLogger.debug(this.depthToSpaces() + "End Writing non native object at " + position + " with oid " + oid + " - prev oid=" + objectInfo.getPreviousObjectOID() + " / next oid=" + objectInfo.getNextObjectOID());
            if (OdbConfiguration.isDebugEnabled(LOG_ID_DEBUG)) {
                DLogger.debug(" - current buffer : " + this.fsi.getIo().toString());
            }
        }
        if (isNewObject) {
            this.manageIndexesForInsert(oid, objectInfo);
            if (hasObject) {
                this.triggerManager.manageInsertTriggerAfter(objectInfo.getClassInfo().getFullClassName(), objectInfo.getObject(), oid);
            } else {
                this.triggerManager.manageInsertTriggerAfter(objectInfo.getClassInfo().getFullClassName(), objectInfo, oid);
            }
        }
        return oid;
    }

    public OID writeNonNativeObjectInfoOld(OID existingOid, NonNativeObjectInfo objectInfo, long position, boolean writeDataInTransaction, boolean isNewObject) {
        OID oid;
        boolean hasObject;
        ISession lsession = this.getSession();
        ICache cache = lsession.getCache();
        boolean bl = hasObject = objectInfo.getObject() != null;
        if (isNewObject) {
            if (hasObject) {
                this.triggerManager.manageInsertTriggerBefore(objectInfo.getClassInfo().getFullClassName(), objectInfo.getObject());
            } else {
                this.triggerManager.manageInsertTriggerBefore(objectInfo.getClassInfo().getFullClassName(), objectInfo);
            }
        }
        if (objectInfo.isNull()) {
            return StorageEngineConstant.NULL_OBJECT_ID;
        }
        MetaModel metaModel = lsession.getMetaModel();
        if (!metaModel.existClass(objectInfo.getClassInfo().getFullClassName())) {
            this.addClass(objectInfo.getClassInfo(), true);
        }
        if (position == -1L) {
            position = this.fsi.getAvailablePosition();
            objectInfo.setPosition(position);
        }
        if ((oid = existingOid) == null) {
            if (this.idManager.mustShift()) {
                oid = this.idManager.getNextObjectId(position);
                position = this.fsi.getAvailablePosition();
                this.idManager.updateObjectPositionForOid(oid, position, false);
            } else {
                oid = this.idManager.getNextObjectId(position);
            }
        } else {
            this.idManager.updateObjectPositionForOid(oid, position, true);
            cache.savePositionOfObjectWithOid(oid, position);
        }
        cache.updateIdOfInsertingObject(objectInfo.getObject(), oid);
        if (isNewObject) {
            cache.addOIDToUnconnectedZone(oid);
            if (OdbConfiguration.reconnectObjectsToSession()) {
                ICrossSessionCache crossSessionCache = CacheFactory.getCrossSessionCache(this.storageEngine.getBaseIdentification().getIdentification());
                crossSessionCache.addObject(objectInfo.getObject(), oid);
            }
        }
        objectInfo.setOid(oid);
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug(this.depthToSpaces() + "Start Writing non native object of type " + objectInfo.getClassInfo().getFullClassName() + " at " + position + " , oid = " + oid + " : " + objectInfo.toString());
        }
        if (objectInfo.getClassInfo() == null || objectInfo.getClassInfo().getId() == null) {
            if (objectInfo.getClassInfo() != null) {
                ClassInfo clinfo = this.storageEngine.getSession(true).getMetaModel().getClassInfo(objectInfo.getClassInfo().getFullClassName(), true);
                objectInfo.setClassInfo(clinfo);
            } else {
                throw new ODBRuntimeException(NeoDatisError.UNDEFINED_CLASS_INFO.addParameter(objectInfo.toString()));
            }
        }
        ClassInfo classInfo = this.addClass(objectInfo.getClassInfo(), true);
        objectInfo.setClassInfo(classInfo);
        if (isNewObject) {
            this.manageNewObjectPointers(objectInfo, classInfo, position, metaModel);
        }
        if (OdbConfiguration.saveHistory()) {
            classInfo.addHistory(new InsertHistoryInfo("insert", oid, position, objectInfo.getPreviousObjectOID(), objectInfo.getNextObjectOID()));
        }
        this.fsi.setWritePosition(position, writeDataInTransaction);
        objectInfo.setPosition(position);
        this.fsi.writeInt(0, writeDataInTransaction, "block size");
        this.fsi.writeByte((byte)4, writeDataInTransaction, "object block type");
        this.fsi.writeLong(oid.getObjectId(), writeDataInTransaction, "oid", 1);
        this.fsi.writeLong(classInfo.getId().getObjectId(), writeDataInTransaction, "class info id", 1);
        this.writeOid(objectInfo.getPreviousObjectOID(), writeDataInTransaction, "prev instance", 1);
        this.writeOid(objectInfo.getNextObjectOID(), writeDataInTransaction, "next instance", 1);
        this.fsi.writeLong(objectInfo.getHeader().getCreationDate(), writeDataInTransaction, "creation date", 1);
        this.fsi.writeLong(OdbTime.getCurrentTimeInMs(), writeDataInTransaction, "update date", 1);
        this.fsi.writeInt(objectInfo.getHeader().getObjectVersion(), writeDataInTransaction, "object version number");
        this.fsi.writeLong(-1L, writeDataInTransaction, "object reference pointer", 1);
        this.fsi.writeBoolean(false, writeDataInTransaction, "is syncronized with external db");
        int nbAttributes = objectInfo.getClassInfo().getAttributes().size();
        this.fsi.writeInt(nbAttributes, writeDataInTransaction, "nb attr");
        long attributePositionStart = this.fsi.getPosition();
        for (int i = 0; i < nbAttributes; ++i) {
            this.fsi.writeInt(0, writeDataInTransaction, "attr id -1");
            this.fsi.writeLong(0L, writeDataInTransaction, "att pos", 1);
        }
        long[] attributesIdentification = new long[nbAttributes];
        int[] attributeIds = new int[nbAttributes];
        ClassAttributeInfo cai = null;
        AbstractObjectInfo aoi2 = null;
        long nativeAttributePosition = -1L;
        OID nonNativeAttributeOid = null;
        long maxWritePosition = this.fsi.getPosition();
        for (int i = 0; i < nbAttributes; ++i) {
            cai = classInfo.getAttributeInfo(i);
            attributeIds[i] = cai.getId();
            aoi2 = objectInfo.getAttributeValueFromId(cai.getId());
            if (aoi2 == null) {
                aoi2 = cai.isNative() ? new NullNativeObjectInfo(cai.getAttributeType().getId()) : new NonNativeNullObjectInfo(cai.getClassInfo());
            }
            if (aoi2.isNative()) {
                attributesIdentification[i] = nativeAttributePosition = this.internalStoreObject((NativeObjectInfo)aoi2);
            } else {
                if (aoi2.isObjectReference()) {
                    ObjectReference or = (ObjectReference)aoi2;
                    nonNativeAttributeOid = or.getOid();
                } else {
                    nonNativeAttributeOid = this.storeObject(null, (NonNativeObjectInfo)aoi2);
                }
                attributesIdentification[i] = nonNativeAttributeOid != null ? -nonNativeAttributeOid.getObjectId() : 0L;
            }
            long p = this.fsi.getPosition();
            if (p <= maxWritePosition) continue;
            maxWritePosition = p;
        }
        objectInfo.getHeader().setAttributesIdentification(attributesIdentification);
        objectInfo.getHeader().setAttributesIds(attributeIds);
        long positionAfterWrite = maxWritePosition;
        this.fsi.setWritePosition(attributePositionStart, writeDataInTransaction);
        for (int i = 0; i < attributesIdentification.length; ++i) {
            this.fsi.writeInt(attributeIds[i], writeDataInTransaction, "attr id");
            this.fsi.writeLong(attributesIdentification[i], writeDataInTransaction, "att real pos", 1);
            if (!objectInfo.getAttributeValueFromId(attributeIds[i]).isNonNativeObject() || attributesIdentification[i] <= 0L) continue;
            throw new ODBRuntimeException(NeoDatisError.NON_NATIVE_ATTRIBUTE_STORED_BY_POSITION_INSTEAD_OF_OID.addParameter(classInfo.getAttributeInfo(i).getName()).addParameter(classInfo.getFullClassName()).addParameter(attributesIdentification[i]));
        }
        this.fsi.setWritePosition(positionAfterWrite, writeDataInTransaction);
        int blockSize = (int)(positionAfterWrite - position);
        try {
            this.writeBlockSizeAt(position, blockSize, writeDataInTransaction, objectInfo);
        }
        catch (ODBRuntimeException e) {
            DLogger.debug("Error while writing block size. pos after write " + positionAfterWrite + " / start pos = " + position);
            throw e;
        }
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug(this.depthToSpaces() + "  Attributes positions of object with oid " + oid + " are " + DisplayUtility.longArrayToString(attributesIdentification));
            DLogger.debug(this.depthToSpaces() + "End Writing non native object at " + position + " with oid " + oid + " - prev oid=" + objectInfo.getPreviousObjectOID() + " / next oid=" + objectInfo.getNextObjectOID());
            if (OdbConfiguration.isDebugEnabled(LOG_ID_DEBUG)) {
                DLogger.debug(" - current buffer : " + this.fsi.getIo().toString());
            }
        }
        if (isNewObject) {
            this.manageIndexesForInsert(oid, objectInfo);
            if (hasObject) {
                this.triggerManager.manageInsertTriggerAfter(objectInfo.getClassInfo().getFullClassName(), objectInfo.getObject(), oid);
            } else {
                this.triggerManager.manageInsertTriggerAfter(objectInfo.getClassInfo().getFullClassName(), objectInfo, oid);
            }
        }
        return oid;
    }

    private void manageNewObjectPointers(NonNativeObjectInfo objectInfo, ClassInfo classInfo, long position, MetaModel metaModel) {
        boolean isFirstUncommitedObject;
        ICache cache = this.storageEngine.getSession(true).getCache();
        boolean bl = isFirstUncommitedObject = !classInfo.getUncommittedZoneInfo().hasObjects();
        if (isFirstUncommitedObject) {
            classInfo.getUncommittedZoneInfo().first = objectInfo.getOid();
            OID lastCommittedObjectOid = classInfo.getCommitedZoneInfo().last;
            if (lastCommittedObjectOid != null) {
                ObjectInfoHeader oih = cache.getObjectInfoHeaderFromOid(lastCommittedObjectOid, false);
                if (oih == null && this.getSession().hasBeenCommitted()) {
                    oih = this.objectReader.readObjectInfoHeaderFromOid(lastCommittedObjectOid, false);
                }
                if (oih == null) {
                    throw new ODBRuntimeException(NeoDatisError.OBJECT_WITH_OID_DOES_NOT_EXIST.addParameter(lastCommittedObjectOid));
                }
                oih.setNextObjectOID(objectInfo.getOid());
                objectInfo.setPreviousInstanceOID(lastCommittedObjectOid);
            }
        } else {
            ObjectInfoHeader oip = classInfo.getLastObjectInfoHeader();
            if (oip == null) {
                throw new ODBRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("last OIP is null in manageNewObjectPointers oid=" + objectInfo.getOid()));
            }
            if (oip.getNextObjectOID() != objectInfo.getOid()) {
                oip.setNextObjectOID(objectInfo.getOid());
                this.updateNextObjectFieldOfObjectInfo(oip.getOid(), oip.getNextObjectOID(), false);
                objectInfo.setPreviousInstanceOID(oip.getOid());
                oip.setClassInfoId(classInfo.getId());
                this.storageEngine.getSession(true).getCache().addObjectInfo(oip);
            }
        }
        classInfo.getUncommittedZoneInfo().last = objectInfo.getOid();
        classInfo.getUncommittedZoneInfo().increaseNbObjects();
        classInfo.setLastObjectInfoHeader(objectInfo.getHeader());
        this.storageEngine.getSession(true).getMetaModel().addChangedClass(classInfo);
    }

    public int manageIndexesForInsert(OID oid, NonNativeObjectInfo nnoi) {
        IOdbList<ClassInfoIndex> indexes = nnoi.getClassInfo().getIndexes();
        ClassInfoIndex index = null;
        for (int i = 0; i < indexes.size(); ++i) {
            index = indexes.get(i);
            try {
                OdbComparable key = index.computeKey(nnoi);
                int hc = key.hashCode();
                index.getBTree().insert(key, oid);
            }
            catch (Exception e) {
                this.getSession().rollback();
                throw new ODBRuntimeException(NeoDatisError.ERROR_WHILE_MANAGING_INDEX.addParameter(index.getName()), (Throwable)e);
            }
            if (index.getBTree().getSize() == nnoi.getClassInfo().getNumberOfObjects()) continue;
            throw new ODBRuntimeException(NeoDatisError.BTREE_SIZE_DIFFERS_FROM_CLASS_ELEMENT_NUMBER.addParameter(index.getBTree().getSize()).addParameter(nnoi.getClassInfo().getNumberOfObjects()));
        }
        return indexes.size();
    }

    public int manageIndexesForDelete(OID oid, NonNativeObjectInfo nnoi) {
        IOdbList<ClassInfoIndex> indexes = nnoi.getClassInfo().getIndexes();
        ClassInfoIndex index = null;
        for (int i = 0; i < indexes.size(); ++i) {
            index = indexes.get(i);
            index.getBTree().delete(index.computeKey(nnoi), oid);
            if (index.getBTree().getSize() == nnoi.getClassInfo().getNumberOfObjects()) continue;
            throw new ODBRuntimeException(NeoDatisError.BTREE_SIZE_DIFFERS_FROM_CLASS_ELEMENT_NUMBER.addParameter(index.getBTree().getSize()).addParameter(nnoi.getClassInfo().getNumberOfObjects()));
        }
        return indexes.size();
    }

    public int manageIndexesForUpdate(OID oid, NonNativeObjectInfo nnoi, NonNativeObjectInfo oldMetaRepresentation) {
        IOdbList<ClassInfoIndex> indexes = oldMetaRepresentation.getClassInfo().getIndexes();
        ClassInfoIndex index = null;
        OdbComparable oldKey = null;
        OdbComparable newKey = null;
        for (int i = 0; i < indexes.size(); ++i) {
            index = indexes.get(i);
            oldKey = index.computeKey(oldMetaRepresentation);
            if (oldKey.compareTo(newKey = index.computeKey(nnoi)) == 0) continue;
            IBTree btree = index.getBTree();
            Object old = btree.delete(oldKey, oid);
            btree.insert(newKey, oid);
            if (index.getBTree().getSize() == nnoi.getClassInfo().getNumberOfObjects()) continue;
            throw new ODBRuntimeException(NeoDatisError.BTREE_SIZE_DIFFERS_FROM_CLASS_ELEMENT_NUMBER.addParameter(index.getBTree().getSize()).addParameter(nnoi.getClassInfo().getNumberOfObjects()));
        }
        return indexes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OID insertNonNativeObject(OID oid, NonNativeObjectInfo nnoi, boolean isNewObject) {
        Object object;
        ClassInfo ci;
        block4: {
            ci = nnoi.getClassInfo();
            object = nnoi.getObject();
            OID cachedOid = this.getSession().getCache().idOfInsertingObject(object);
            if (cachedOid == null) break block4;
            OID oID = cachedOid;
            return oID;
        }
        ci = this.addClass(ci, true);
        nnoi.setClassInfo(ci);
        this.getSession().getCache().startInsertingObjectWithOid(object, oid, nnoi);
        OID newOid = this.writeNonNativeObjectInfo(oid, nnoi, -1L, false, isNewObject);
        if (newOid != StorageEngineConstant.NULL_OBJECT_ID) {
            this.getSession().getCache().addObject(newOid, object, nnoi.getHeader());
        }
        OID oID = newOid;
        return oID;
    }

    private long insertNativeObject(NativeObjectInfo noi) {
        long writePosition = this.fsi.getAvailablePosition();
        this.fsi.setWritePosition(writePosition, true);
        long position = this.writeNativeObjectInfo(noi, writePosition, true, false);
        return position;
    }

    public OID storeObject(OID oid, NonNativeObjectInfo nnoi) {
        ICrossSessionCache crossSessionCache;
        Object object = nnoi.getObject();
        boolean mustUpdate = false;
        ICache cache = this.getSession().getCache();
        if (object != null) {
            OID cacheOid = cache.idOfInsertingObject(object);
            if (cacheOid != null) {
                return cacheOid;
            }
            mustUpdate = cache.existObject(object);
        }
        if (!mustUpdate) {
            boolean bl = mustUpdate = nnoi.getOid() != StorageEngineConstant.NULL_OBJECT_ID;
        }
        if (!mustUpdate && OdbConfiguration.reconnectObjectsToSession() && (crossSessionCache = CacheFactory.getCrossSessionCache(this.storageEngine.getBaseIdentification().getIdentification())).existObject(object)) {
            this.storageEngine.reconnect(object);
            mustUpdate = true;
        }
        if (mustUpdate) {
            return this.updateNonNativeObjectInfo(nnoi, false);
        }
        return this.insertNonNativeObject(oid, nnoi, true);
    }

    long internalStoreObject(NativeObjectInfo noi) {
        return this.insertNativeObject(noi);
    }

    public OID updateObject(AbstractObjectInfo aoi, boolean forceUpdate) {
        if (aoi.isNonNativeObject()) {
            return this.updateNonNativeObjectInfo((NonNativeObjectInfo)aoi, forceUpdate);
        }
        if (aoi.isNative()) {
            return this.updateObject(aoi, forceUpdate);
        }
        throw new ODBRuntimeException(NeoDatisError.ABSTRACT_OBJECT_INFO_TYPE_NOT_SUPPORTED.addParameter(aoi.getClass().getName()));
    }

    public OID updateNonNativeObjectInfo(NonNativeObjectInfo nnoi, boolean forceUpdate) {
        OID oID;
        OID oid;
        block53: {
            NonNativeObjectInfo oldMetaRepresentation;
            Object object;
            boolean hasObject;
            block54: {
                long currentPosition;
                boolean objectIsInConnectedZone;
                ObjectInfoHeader lastHeader;
                ICache cache;
                ISession lsession;
                boolean objectHasChanged;
                long nbNonConnectedObjects;
                long nbConnectedObjects;
                boolean withIndex;
                String message;
                block44: {
                    OID oID2;
                    block51: {
                        block52: {
                            int nbAppliedChanges;
                            block48: {
                                OID oID3;
                                block49: {
                                    block50: {
                                        ITmpCache tmpCache;
                                        long positionBeforeWrite;
                                        block45: {
                                            OID oID4;
                                            block46: {
                                                block47: {
                                                    ++nbCallsToUpdate;
                                                    hasObject = true;
                                                    message = null;
                                                    object = nnoi.getObject();
                                                    oid = nnoi.getOid();
                                                    if (object == null) {
                                                        hasObject = false;
                                                    }
                                                    withIndex = !nnoi.getClassInfo().getIndexes().isEmpty();
                                                    oldMetaRepresentation = null;
                                                    nbConnectedObjects = nnoi.getClassInfo().getCommitedZoneInfo().getNbObjects();
                                                    nbNonConnectedObjects = nnoi.getClassInfo().getUncommittedZoneInfo().getNbObjects();
                                                    objectHasChanged = false;
                                                    lsession = this.getSession();
                                                    positionBeforeWrite = this.fsi.getPosition();
                                                    tmpCache = lsession.getTmpCache();
                                                    cache = lsession.getCache();
                                                    lastHeader = cache.getObjectInfoHeaderFromOid(oid, false);
                                                    if (lastHeader == null && lsession.hasBeenCommitted()) {
                                                        lastHeader = this.objectReader.readObjectInfoHeaderFromOid(oid, false);
                                                    }
                                                    if (lastHeader == null) {
                                                        throw new ODBRuntimeException(NeoDatisError.UNEXPECTED_SITUATION.addParameter("Header is null in update"));
                                                    }
                                                    if (lastHeader.getOid() == null) {
                                                        throw new ODBRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("Header oid is null for oid " + oid));
                                                    }
                                                    objectIsInConnectedZone = cache.objectWithIdIsInCommitedZone(oid);
                                                    currentPosition = lastHeader.getPosition();
                                                    if (!this.isLocalMode) {
                                                        long lastCommitedObjectPosition = this.idManager.getObjectPositionWithOid(oid, false);
                                                        if (lastCommitedObjectPosition > 0L) {
                                                            currentPosition = lastCommitedObjectPosition;
                                                        }
                                                        nnoi.getHeader().setObjectVersion(lastHeader.getObjectVersion());
                                                        nnoi.getHeader().setUpdateDate(lastHeader.getUpdateDate());
                                                    }
                                                    if (nnoi.getPosition() == -1L) {
                                                        nnoi.getHeader().setPosition(currentPosition);
                                                    }
                                                    if (!forceUpdate && currentPosition == -1L) {
                                                        throw new ODBRuntimeException(NeoDatisError.INSTANCE_POSITION_IS_NEGATIVE.addParameter(currentPosition).addParameter(oid).addParameter("In Object Info Header"));
                                                    }
                                                    if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                                                        message = this.depthToSpaces() + "start updating object at " + currentPosition + ", oid=" + oid + " : " + (nnoi != null ? nnoi.toString() : "null");
                                                        DLogger.debug(message);
                                                    }
                                                    if (!hasObject) {
                                                        this.storageEngine.getTriggerManager().manageUpdateTriggerBefore(nnoi.getClassInfo().getFullClassName(), null, nnoi, oid);
                                                    }
                                                    nbAppliedChanges = 0;
                                                    if (forceUpdate) break block44;
                                                    OID cachedOid = cache.idOfInsertingObject(object);
                                                    if (cachedOid == null) break block45;
                                                    oID4 = cachedOid;
                                                    Object var35_27 = null;
                                                    if (!objectHasChanged) break block46;
                                                    if (!withIndex) break block47;
                                                    this.manageIndexesForUpdate(oid, nnoi, oldMetaRepresentation);
                                                }
                                                if (hasObject) {
                                                    this.storageEngine.getTriggerManager().manageUpdateTriggerAfter(nnoi.getClassInfo().getFullClassName(), oldMetaRepresentation, object, oid);
                                                } else {
                                                    this.storageEngine.getTriggerManager().manageUpdateTriggerAfter(nnoi.getClassInfo().getFullClassName(), oldMetaRepresentation, nnoi, oid);
                                                }
                                            }
                                            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                                                DLogger.debug(this.depthToSpaces() + "end updating object with oid=" + oid + " at pos " + nnoi.getPosition() + " => " + nnoi.toString());
                                            }
                                            return oID4;
                                        }
                                        try {
                                            boolean useCache = !objectIsInConnectedZone;
                                            oldMetaRepresentation = this.objectReader.readNonNativeObjectInfoFromPosition(null, oid, currentPosition, useCache, false);
                                            tmpCache.clearObjectInfos();
                                        }
                                        catch (ODBRuntimeException e) {
                                            throw new ODBRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("Error while reading old Object Info of oid " + oid + " at pos " + currentPosition), (Throwable)e);
                                        }
                                        int onDiskVersion = oldMetaRepresentation.getHeader().getObjectVersion();
                                        long onDiskUpdateDate = oldMetaRepresentation.getHeader().getUpdateDate();
                                        int inCacheVersion = lastHeader.getObjectVersion();
                                        long inCacheUpdateDate = lastHeader.getUpdateDate();
                                        if (onDiskUpdateDate > inCacheUpdateDate || onDiskVersion > inCacheVersion) {
                                            // empty if block
                                        }
                                        nnoi.setHeader(lastHeader);
                                        nnoi.getHeader().incrementVersionAndUpdateDate();
                                        nnoi.getHeader().setCreationDate(oldMetaRepresentation.getHeader().getCreationDate());
                                        oldMetaRepresentation.setObject(nnoi.getObject());
                                        this.comparator.clear();
                                        objectHasChanged = this.comparator.hasChanged(oldMetaRepresentation, nnoi);
                                        if (objectHasChanged) break block48;
                                        this.fsi.setWritePosition(positionBeforeWrite, true);
                                        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                                            DLogger.debug(this.depthToSpaces() + "updateObject : Object is unchanged - doing nothing");
                                        }
                                        oID3 = oid;
                                        Object var35_28 = null;
                                        if (!objectHasChanged) break block49;
                                        if (!withIndex) break block50;
                                        this.manageIndexesForUpdate(oid, nnoi, oldMetaRepresentation);
                                    }
                                    if (hasObject) {
                                        this.storageEngine.getTriggerManager().manageUpdateTriggerAfter(nnoi.getClassInfo().getFullClassName(), oldMetaRepresentation, object, oid);
                                    } else {
                                        this.storageEngine.getTriggerManager().manageUpdateTriggerAfter(nnoi.getClassInfo().getFullClassName(), oldMetaRepresentation, nnoi, oid);
                                    }
                                }
                                if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                                    DLogger.debug(this.depthToSpaces() + "end updating object with oid=" + oid + " at pos " + nnoi.getPosition() + " => " + nnoi.toString());
                                }
                                return oID3;
                            }
                            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                                DLogger.debug(this.depthToSpaces() + "\tmax recursion level is " + this.comparator.getMaxObjectRecursionLevel());
                                DLogger.debug(this.depthToSpaces() + "\tattribute actions are : " + this.comparator.getChangedAttributeActions());
                                DLogger.debug(this.depthToSpaces() + "\tnew objects are : " + this.comparator.getNewObjects());
                            }
                            if (!OdbConfiguration.inPlaceUpdate() || !this.comparator.supportInPlaceUpdate() || (nbAppliedChanges = this.manageInPlaceUpdate(this.comparator, object, oid, lastHeader, cache, objectIsInConnectedZone)) != this.comparator.getNbChanges()) break block44;
                            ++nbInPlaceUpdates;
                            this.updateUpdateTimeAndObjectVersionNumber(lastHeader, true);
                            cache.addObject(oid, object, lastHeader);
                            oID2 = oid;
                            Object var35_29 = null;
                            if (!objectHasChanged) break block51;
                            if (!withIndex) break block52;
                            this.manageIndexesForUpdate(oid, nnoi, oldMetaRepresentation);
                        }
                        if (hasObject) {
                            this.storageEngine.getTriggerManager().manageUpdateTriggerAfter(nnoi.getClassInfo().getFullClassName(), oldMetaRepresentation, object, oid);
                        } else {
                            this.storageEngine.getTriggerManager().manageUpdateTriggerAfter(nnoi.getClassInfo().getFullClassName(), oldMetaRepresentation, nnoi, oid);
                        }
                    }
                    if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                        DLogger.debug(this.depthToSpaces() + "end updating object with oid=" + oid + " at pos " + nnoi.getPosition() + " => " + nnoi.toString());
                    }
                    return oID2;
                }
                try {
                    if (oldMetaRepresentation == null && withIndex) {
                        oldMetaRepresentation = this.objectReader.readNonNativeObjectInfoFromPosition(null, oid, currentPosition, false, false);
                    }
                    ++nbNormalUpdates;
                    if (hasObject) {
                        cache.startInsertingObjectWithOid(object, oid, nnoi);
                    }
                    ClassInfo ci = lsession.getMetaModel().getClassInfoFromId(lastHeader.getClassInfoId());
                    if (hasObject) {
                        cache.endInsertingObject(object);
                    }
                    OID previousObjectOID = lastHeader.getPreviousObjectOID();
                    OID nextObjectOid = lastHeader.getNextObjectOID();
                    if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                        DLogger.debug(this.depthToSpaces() + "Updating object " + nnoi.toString());
                        DLogger.debug(this.depthToSpaces() + "position =  " + currentPosition + " | prev instance = " + previousObjectOID + " | next instance = " + nextObjectOid);
                    }
                    nnoi.setPreviousInstanceOID(previousObjectOID);
                    nnoi.setNextObjectOID(nextObjectOid);
                    this.markAsDeleted(currentPosition, oid, objectIsInConnectedZone);
                    oid = this.insertNonNativeObject(oid, nnoi, false);
                    long positionAfterWrite = this.fsi.getPosition();
                    if (hasObject) {
                        cache.addObject(oid, object, nnoi.getHeader());
                    }
                    this.fsi.setWritePosition(positionAfterWrite, true);
                    long nbConnectedObjectsAfter = nnoi.getClassInfo().getCommitedZoneInfo().getNbObjects();
                    long nbNonConnectedObjectsAfter = nnoi.getClassInfo().getUncommittedZoneInfo().getNbObjects();
                    if (nbConnectedObjectsAfter != nbConnectedObjects || nbNonConnectedObjectsAfter != nbNonConnectedObjects) {
                        // empty if block
                    }
                    oID = oid;
                    Object var35_30 = null;
                    if (!objectHasChanged) break block53;
                    if (!withIndex) break block54;
                    this.manageIndexesForUpdate(oid, nnoi, oldMetaRepresentation);
                }
                catch (Exception e) {
                    try {
                        message = this.depthToSpaces() + "Error updating object " + nnoi.toString() + " : " + OdbString.exceptionToString(e, true);
                        DLogger.error(message);
                        throw new ODBRuntimeException(e, message);
                    }
                    catch (Throwable throwable) {
                        block55: {
                            Object var35_31 = null;
                            if (objectHasChanged) {
                                if (withIndex) {
                                    this.manageIndexesForUpdate(oid, nnoi, oldMetaRepresentation);
                                }
                                if (hasObject) {
                                    this.storageEngine.getTriggerManager().manageUpdateTriggerAfter(nnoi.getClassInfo().getFullClassName(), oldMetaRepresentation, object, oid);
                                } else {
                                    this.storageEngine.getTriggerManager().manageUpdateTriggerAfter(nnoi.getClassInfo().getFullClassName(), oldMetaRepresentation, nnoi, oid);
                                }
                            }
                            if (!OdbConfiguration.isDebugEnabled(LOG_ID)) break block55;
                            DLogger.debug(this.depthToSpaces() + "end updating object with oid=" + oid + " at pos " + nnoi.getPosition() + " => " + nnoi.toString());
                        }
                        throw throwable;
                    }
                }
            }
            if (hasObject) {
                this.storageEngine.getTriggerManager().manageUpdateTriggerAfter(nnoi.getClassInfo().getFullClassName(), oldMetaRepresentation, object, oid);
            } else {
                this.storageEngine.getTriggerManager().manageUpdateTriggerAfter(nnoi.getClassInfo().getFullClassName(), oldMetaRepresentation, nnoi, oid);
            }
        }
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug(this.depthToSpaces() + "end updating object with oid=" + oid + " at pos " + nnoi.getPosition() + " => " + nnoi.toString());
        }
        return oID;
    }

    private void updateUpdateTimeAndObjectVersionNumber(ObjectInfoHeader header, boolean writeInTransaction) {
        long objectPosition = header.getPosition();
        this.fsi.setWritePosition(objectPosition + StorageEngineConstant.OBJECT_OFFSET_UPDATE_DATE, writeInTransaction);
        this.fsi.writeLong(header.getUpdateDate(), writeInTransaction, "update date time", 1);
        this.fsi.writeInt(header.getObjectVersion(), writeInTransaction, "object version");
    }

    protected ObjectInfoHeader getObjectInfoHeader(OID oid, ICache cache) {
        ObjectInfoHeader oih = cache.getObjectInfoHeaderFromOid(oid, false);
        if (oih == null) {
            oih = this.objectReader.readObjectInfoHeaderFromOid(oid, false);
        }
        return oih;
    }

    public ObjectInfoHeader updateNextObjectPreviousPointersInCache(OID nextObjectOID, OID previousObjectOID, ICache cache) {
        ObjectInfoHeader oip = cache.getObjectInfoHeaderFromOid(nextObjectOID, false);
        if (oip == null) {
            oip = this.objectReader.readObjectInfoHeaderFromOid(nextObjectOID, false);
            cache.addObjectInfo(oip);
        }
        oip.setPreviousObjectOID(previousObjectOID);
        return oip;
    }

    public ObjectInfoHeader updatePreviousObjectNextPointersInCache(OID nextObjectOID, OID previousObjectOID, ICache cache) {
        ObjectInfoHeader oip = cache.getObjectInfoHeaderFromOid(previousObjectOID, false);
        if (oip == null) {
            oip = this.objectReader.readObjectInfoHeaderFromOid(previousObjectOID, false);
            cache.addObjectInfo(oip);
        }
        oip.setNextObjectOID(nextObjectOID);
        return oip;
    }

    private int manageInPlaceUpdate(IObjectInfoComparator objectComparator, Object object, OID oid, ObjectInfoHeader header, ICache cache, boolean objectIsInConnectedZone) throws Exception {
        int i;
        boolean canUpdateInPlace = true;
        boolean writeInTransaction = objectIsInConnectedZone;
        int nbAppliedChanges = 0;
        if (objectComparator.getChangedAttributeActions().size() > 0) {
            ChangedNativeAttributeAction caa = null;
            List<ChangedAttribute> actions = objectComparator.getChangedAttributeActions();
            for (i = 0; i < actions.size(); ++i) {
                if (actions.get(i) instanceof ChangedNativeAttributeAction) {
                    caa = (ChangedNativeAttributeAction)actions.get(i);
                    if (caa.reallyCantDoInPlaceUpdate()) {
                        canUpdateInPlace = false;
                        break;
                    }
                    this.fsi.setWritePosition(caa.getUpdatePosition(), true);
                    this.writeAtomicNativeObject((AtomicNativeObjectInfo)caa.getNoiWithNewValue(), writeInTransaction);
                } else if (actions.get(i) instanceof ChangedObjectReferenceAttributeAction) {
                    ChangedObjectReferenceAttributeAction coraa = (ChangedObjectReferenceAttributeAction)actions.get(i);
                    this.updateObjectReference(coraa.getUpdatePosition(), coraa.getNewId(), writeInTransaction);
                }
                ++nbAppliedChanges;
            }
            if (canUpdateInPlace && OdbConfiguration.isDebugEnabled(LOG_ID)) {
                DLogger.debug(this.depthToSpaces() + "Sucessfull in place updating");
            }
        }
        if (canUpdateInPlace) {
            NewNonNativeObjectAction nnnoa = null;
            for (int i2 = 0; i2 < objectComparator.getNewObjectMetaRepresentations().size(); ++i2) {
                nnnoa = objectComparator.getNewObjectMetaRepresentation(i2);
                if (cache.idOfInsertingObject(nnnoa) != null) continue;
                OID ooid = nnnoa.getNnoi().getOid();
                if (ooid == null) {
                    ooid = this.insertNonNativeObject(null, nnnoa.getNnoi(), true);
                }
                this.updateObjectReference(nnnoa.getUpdatePosition(), ooid, writeInTransaction);
                ++nbAppliedChanges;
            }
            SetAttributeToNullAction satna = null;
            for (i = 0; i < objectComparator.getAttributeToSetToNull().size(); ++i) {
                satna = objectComparator.getAttributeToSetToNull().get(i);
                this.updateObjectReference(satna.getUpdatePosition(), StorageEngineConstant.NULL_OBJECT_ID, writeInTransaction);
                ++nbAppliedChanges;
            }
            ArrayModifyElement ame = null;
            for (int i3 = 0; i3 < objectComparator.getArrayChanges().size() && (ame = objectComparator.getArrayChanges().get(i3)).supportInPlaceUpdate(); ++i3) {
                this.fsi.setReadPosition(ame.getArrayPositionDefinition());
                long arrayPosition = this.fsi.readLong();
                this.updateArrayElement(arrayPosition, ame.getArrayElementIndexToChange(), (NativeObjectInfo)ame.getNewValue(), writeInTransaction);
                ++nbAppliedChanges;
            }
        }
        return nbAppliedChanges;
    }

    private boolean canDoInPlaceUpdate(long updatePosition, String value) {
        this.fsi.setReadPosition(updatePosition + StorageEngineConstant.NATIVE_OBJECT_OFFSET_DATA_AREA);
        int totalSize = this.fsi.readInt("String total size");
        int stringNumberOfBytes = this.byteArrayConverter.getNumberOfBytesOfAString(value, true);
        return totalSize >= stringNumberOfBytes;
    }

    public String depthToSpaces() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.currentDepth; ++i) {
            buffer.append("  ");
        }
        return buffer.toString();
    }

    private void writeBlockSizeAt(long writePosition, int blockSize, boolean writeInTransaction, Object object) {
        if (blockSize < 0) {
            throw new ODBRuntimeException(NeoDatisError.NEGATIVE_BLOCK_SIZE.addParameter(writePosition).addParameter(blockSize).addParameter(object.toString()));
        }
        long currentPosition = this.fsi.getPosition();
        this.fsi.setWritePosition(writePosition, writeInTransaction);
        this.fsi.writeInt(blockSize, writeInTransaction, "block size");
        this.fsi.setWritePosition(currentPosition, writeInTransaction);
    }

    private long writeCollection(CollectionObjectInfo coi, boolean writeInTransaction) {
        long firstObjectPosition = 0L;
        long startPosition = this.fsi.getPosition();
        this.writeNativeObjectHeader(coi.getOdbTypeId(), coi.isNull(), (byte)8, writeInTransaction);
        if (coi.isNull()) {
            return startPosition;
        }
        Collection<AbstractObjectInfo> collection = coi.getCollection();
        int collectionSize = collection.size();
        Iterator<AbstractObjectInfo> iterator = collection.iterator();
        this.fsi.writeString(coi.getRealCollectionClassName(), false, writeInTransaction);
        this.fsi.writeInt(collectionSize, writeInTransaction, "collection size");
        long[] attributeIdentifications = new long[collectionSize];
        firstObjectPosition = this.fsi.getPosition();
        for (int i = 0; i < collectionSize; ++i) {
            this.fsi.writeLong(0L, writeInTransaction, "collection element pos ", 1);
        }
        int currentElement = 0;
        AbstractObjectInfo element = null;
        while (iterator.hasNext()) {
            element = iterator.next();
            attributeIdentifications[currentElement] = this.internalStoreObjectWrapper(element);
            ++currentElement;
        }
        long positionAfterWrite = this.fsi.getPosition();
        this.fsi.setWritePosition(firstObjectPosition, writeInTransaction);
        for (int i = 0; i < collectionSize; ++i) {
            this.fsi.writeLong(attributeIdentifications[i], writeInTransaction, "collection element real pos ", 1);
        }
        this.fsi.setWritePosition(positionAfterWrite, writeInTransaction);
        return startPosition;
    }

    private long writeArray(ArrayObjectInfo aoi, boolean writeInTransaction) {
        long firstObjectPosition = 0L;
        long startPosition = this.fsi.getPosition();
        this.writeNativeObjectHeader(aoi.getOdbTypeId(), aoi.isNull(), (byte)9, writeInTransaction);
        if (aoi.isNull()) {
            return startPosition;
        }
        Object[] array = aoi.getArray();
        int arraySize = array.length;
        this.fsi.writeString(aoi.getRealArrayComponentClassName(), false, writeInTransaction);
        this.fsi.writeInt(arraySize, writeInTransaction, "array size");
        long[] attributeIdentifications = new long[arraySize];
        firstObjectPosition = this.fsi.getPosition();
        for (int i = 0; i < arraySize; ++i) {
            this.fsi.writeLong(0L, writeInTransaction, "array element pos ", 1);
        }
        AbstractObjectInfo element = null;
        for (int i = 0; i < arraySize; ++i) {
            element = (AbstractObjectInfo)array[i];
            attributeIdentifications[i] = element == null || element.isNull() ? 0L : this.internalStoreObjectWrapper(element);
        }
        long positionAfterWrite = this.fsi.getPosition();
        this.fsi.setWritePosition(firstObjectPosition, writeInTransaction);
        for (int i = 0; i < arraySize; ++i) {
            this.fsi.writeLong(attributeIdentifications[i], writeInTransaction, "array real element pos", 1);
        }
        this.fsi.setWritePosition(positionAfterWrite, writeInTransaction);
        return startPosition;
    }

    private long writeMap(MapObjectInfo moi, boolean writeInTransaction) {
        long firstObjectPosition = 0L;
        long startPosition = this.fsi.getPosition();
        this.writeNativeObjectHeader(moi.getOdbTypeId(), moi.isNull(), (byte)10, writeInTransaction);
        if (moi.isNull()) {
            return startPosition;
        }
        Map<AbstractObjectInfo, AbstractObjectInfo> map = moi.getMap();
        int mapSize = map.size();
        Iterator<AbstractObjectInfo> keys = map.keySet().iterator();
        this.fsi.writeString(moi.getRealMapClassName(), false, writeInTransaction);
        this.fsi.writeInt(mapSize, writeInTransaction, "map size");
        long[] positions = new long[mapSize * 2];
        firstObjectPosition = this.fsi.getPosition();
        for (int i = 0; i < mapSize * 2; ++i) {
            this.fsi.writeLong(0L, writeInTransaction, "map element pos", 1);
        }
        int currentElement = 0;
        while (keys.hasNext()) {
            AbstractObjectInfo key = keys.next();
            AbstractObjectInfo value = map.get(key);
            ODBType keyType = ODBType.getFromClass(key.getClass());
            ODBType valueType = ODBType.getFromClass(value.getClass());
            positions[currentElement++] = this.internalStoreObjectWrapper(key);
            positions[currentElement++] = this.internalStoreObjectWrapper(value);
        }
        long positionAfterWrite = this.fsi.getPosition();
        this.fsi.setWritePosition(firstObjectPosition, writeInTransaction);
        for (int i = 0; i < mapSize * 2; ++i) {
            this.fsi.writeLong(positions[i], writeInTransaction, "map real element pos", 1);
        }
        this.fsi.setWritePosition(positionAfterWrite, writeInTransaction);
        return startPosition;
    }

    private long internalStoreObjectWrapper(AbstractObjectInfo aoi) {
        if (aoi.isNative()) {
            return this.internalStoreObject((NativeObjectInfo)aoi);
        }
        if (aoi.isNonNativeObject()) {
            OID oid = this.storeObject(null, (NonNativeObjectInfo)aoi);
            return -oid.getObjectId();
        }
        ObjectReference objectReference = (ObjectReference)aoi;
        if (objectReference.getOid() == null) {
            OID oid = this.storeObject(null, objectReference.getNnoi());
            return -oid.getObjectId();
        }
        return -objectReference.getOid().getObjectId();
    }

    protected void writeNullNativeObjectHeader(int OdbTypeId, boolean writeInTransaction) {
        this.writeNativeObjectHeader(OdbTypeId, true, (byte)77, writeInTransaction);
    }

    protected void writeNonNativeNullObjectHeader(OID classInfoId, boolean writeInTransaction) {
        this.fsi.writeInt(NON_NATIVE_HEADER_BLOCK_SIZE, writeInTransaction, "block size");
        this.fsi.writeByte((byte)7, writeInTransaction);
        this.fsi.writeLong(classInfoId.getObjectId(), writeInTransaction, "null non native obj class info position", 1);
    }

    protected void writeNativeObjectHeader(int odbTypeId, boolean isNull, byte blockType, boolean writeDataInTransaction) {
        byte[] bytes = new byte[10];
        bytes[0] = NATIVE_HEADER_BLOCK_SIZE_BYTE[0];
        bytes[1] = NATIVE_HEADER_BLOCK_SIZE_BYTE[1];
        bytes[2] = NATIVE_HEADER_BLOCK_SIZE_BYTE[2];
        bytes[3] = NATIVE_HEADER_BLOCK_SIZE_BYTE[3];
        bytes[4] = blockType;
        byte[] bytesTypeId = this.byteArrayConverter.intToByteArray(odbTypeId);
        bytes[5] = bytesTypeId[0];
        bytes[6] = bytesTypeId[1];
        bytes[7] = bytesTypeId[2];
        bytes[8] = bytesTypeId[3];
        bytes[9] = this.byteArrayConverter.booleanToByteArray(isNull)[0];
        this.fsi.writeBytes(bytes, writeDataInTransaction, "NativeObjectHeader");
    }

    public long safeOverWriteAtomicNativeObject(long position, AtomicNativeObjectInfo newAnoi, boolean writeInTransaction) throws NumberFormatException, IOException {
        if (ODBType.hasFixSize(newAnoi.getOdbTypeId())) {
            this.fsi.setWritePosition(position, writeInTransaction);
            return this.writeAtomicNativeObject(newAnoi, writeInTransaction);
        }
        if (ODBType.isStringOrBigDicemalOrBigInteger(newAnoi.getOdbTypeId())) {
            boolean canUpdate;
            this.fsi.setReadPosition(position + StorageEngineConstant.NATIVE_OBJECT_OFFSET_DATA_AREA);
            int totalSize = this.fsi.readInt("String total size");
            int stringNumberOfBytes = this.byteArrayConverter.getNumberOfBytesOfAString(newAnoi.getObject().toString(), true);
            boolean bl = canUpdate = totalSize >= stringNumberOfBytes;
            if (canUpdate) {
                this.fsi.setWritePosition(position, writeInTransaction);
                return this.writeAtomicNativeObject(newAnoi, writeInTransaction, totalSize);
            }
        }
        return -1L;
    }

    public long writeEnumNativeObject(EnumNativeObjectInfo anoi, boolean writeInTransaction) {
        long startPosition = this.fsi.getPosition();
        int odbTypeId = anoi.getOdbTypeId();
        this.writeNativeObjectHeader(odbTypeId, anoi.isNull(), (byte)3, writeInTransaction);
        ClassInfo enumCi = anoi.getEnumClassInfo();
        if (enumCi == null) {
            System.out.println("");
        }
        this.fsi.writeLong(enumCi.getId().getObjectId(), writeInTransaction, "enum class info id", 1);
        this.fsi.writeString(anoi.getObject().toString(), writeInTransaction, true, -1);
        return startPosition;
    }

    public long writeAtomicNativeObject(AtomicNativeObjectInfo anoi, boolean writeInTransaction) {
        return this.writeAtomicNativeObject(anoi, writeInTransaction, -1);
    }

    public long writeAtomicNativeObject(AtomicNativeObjectInfo anoi, boolean writeInTransaction, int totalSpaceIfString) {
        long startPosition = this.fsi.getPosition();
        int odbTypeId = anoi.getOdbTypeId();
        this.writeNativeObjectHeader(odbTypeId, anoi.isNull(), (byte)3, writeInTransaction);
        if (anoi.isNull()) {
            this.fsi.ensureSpaceFor(anoi.getOdbType());
            return startPosition;
        }
        Object object = anoi.getObject();
        switch (odbTypeId) {
            case 20: 
            case 90: {
                this.fsi.writeByte((Byte)object, writeInTransaction);
                break;
            }
            case 10: 
            case 160: {
                this.fsi.writeBoolean((Boolean)object, writeInTransaction);
                break;
            }
            case 150: {
                this.fsi.writeChar(((Character)object).charValue(), writeInTransaction);
                break;
            }
            case 30: {
                this.fsi.writeChar(object.toString().charAt(0), writeInTransaction);
                break;
            }
            case 70: 
            case 130: {
                this.fsi.writeFloat(((Float)object).floatValue(), writeInTransaction);
                break;
            }
            case 80: 
            case 140: {
                this.fsi.writeDouble((Double)object, writeInTransaction);
                break;
            }
            case 50: 
            case 110: {
                this.fsi.writeInt((Integer)object, writeInTransaction, "native attr");
                break;
            }
            case 60: 
            case 120: {
                this.fsi.writeLong((Long)object, writeInTransaction, "native attr", 1);
                break;
            }
            case 40: 
            case 100: {
                this.fsi.writeShort((Short)object, writeInTransaction);
                break;
            }
            case 200: {
                this.fsi.writeBigDecimal((BigDecimal)object, writeInTransaction);
                break;
            }
            case 190: {
                this.fsi.writeBigInteger((BigInteger)object, writeInTransaction);
                break;
            }
            case 170: 
            case 171: 
            case 172: {
                this.fsi.writeDate((Date)object, writeInTransaction);
                break;
            }
            case 173: 
            case 174: {
                Calendar c = (Calendar)object;
                this.fsi.writeDate(c.getTime(), writeInTransaction);
                break;
            }
            case 210: {
                this.fsi.writeString((String)object, writeInTransaction, true, totalSpaceIfString);
                break;
            }
            case 180: {
                long oid = ((OdbObjectOID)object).getObjectId();
                this.fsi.writeLong(oid, writeInTransaction, "ODB OID", 1);
                break;
            }
            case 181: {
                long ooid = ((OdbObjectOID)object).getObjectId();
                this.fsi.writeLong(ooid, writeInTransaction, "ODB OID", 1);
                break;
            }
            case 182: {
                long coid = ((OdbClassOID)object).getObjectId();
                this.fsi.writeLong(coid, writeInTransaction, "ODB OID", 1);
                break;
            }
            default: {
                throw new RuntimeException("native type with odb type id " + odbTypeId + " (" + ODBType.getNameFromId(odbTypeId) + ") for attribute ? is not suported");
            }
        }
        return startPosition;
    }

    public void updatePreviousObjectFieldOfObjectInfo(OID objectOID, OID previousObjectOID, boolean writeInTransaction) {
        long objectPosition = this.idManager.getObjectPositionWithOid(objectOID, true);
        this.fsi.setWritePosition(objectPosition + StorageEngineConstant.OBJECT_OFFSET_PREVIOUS_OBJECT_OID, writeInTransaction);
        this.writeOid(previousObjectOID, writeInTransaction, "prev object position", 2);
    }

    public void updateNextObjectFieldOfObjectInfo(OID objectOID, OID nextObjectOID, boolean writeInTransaction) {
        long objectPosition = this.idManager.getObjectPositionWithOid(objectOID, true);
        this.fsi.setWritePosition(objectPosition + StorageEngineConstant.OBJECT_OFFSET_NEXT_OBJECT_OID, writeInTransaction);
        this.writeOid(nextObjectOID, writeInTransaction, "next object oid of object info", 2);
    }

    public int markAsDeleted(long currentPosition, OID oid, boolean writeInTransaction) {
        this.fsi.setReadPosition(currentPosition);
        int blockSize = this.fsi.readInt();
        this.fsi.setWritePosition(currentPosition + StorageEngineConstant.NATIVE_OBJECT_OFFSET_BLOCK_TYPE, writeInTransaction);
        this.fsi.writeByte((byte)6, writeInTransaction);
        this.storeFreeSpace(currentPosition, blockSize);
        return blockSize;
    }

    public void storeFreeSpace(long currentPosition, int blockSize) {
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("Storing free space at position " + currentPosition + " | block size = " + blockSize);
        }
    }

    protected void markAsAPointerTo(OID oid, long currentPosition, long newObjectPosition) {
        throw new ODBRuntimeException(NeoDatisError.FOUND_POINTER.addParameter(oid.getObjectId()).addParameter(newObjectPosition));
    }

    public void updateInstanceFieldsOfClassInfo(ClassInfo classInfo, boolean writeInTransaction) {
        long currentPosition = this.fsi.getPosition();
        if (OdbConfiguration.isDebugEnabled(LOG_ID_DEBUG)) {
            DLogger.debug(this.depthToSpaces() + "Start of updateInstanceFieldsOfClassInfo for " + classInfo.getFullClassName());
        }
        long position = classInfo.getPosition() + StorageEngineConstant.CLASS_OFFSET_CLASS_NB_OBJECTS;
        this.fsi.setWritePosition(position, writeInTransaction);
        long nbObjects = classInfo.getNumberOfObjects();
        this.fsi.writeLong(nbObjects, writeInTransaction, "class info update nb objects", 2);
        this.writeOid(classInfo.getCommitedZoneInfo().first, writeInTransaction, "class info update first obj oid", 2);
        this.writeOid(classInfo.getCommitedZoneInfo().last, writeInTransaction, "class info update last obj oid", 2);
        if (OdbConfiguration.isDebugEnabled(LOG_ID_DEBUG)) {
            DLogger.debug(this.depthToSpaces() + "End of updateInstanceFieldsOfClassInfo for " + classInfo.getFullClassName());
        }
        this.fsi.setWritePosition(currentPosition, writeInTransaction);
    }

    protected void updateLastInstanceFieldOfClassInfoWithId(OID classInfoId, long lastInstancePosition) {
        long currentPosition = this.fsi.getPosition();
        long classInfoPosition = this.idManager.getObjectPositionWithOid(classInfoId, true);
        this.fsi.setWritePosition(classInfoPosition + StorageEngineConstant.CLASS_OFFSET_CLASS_LAST_OBJECT_POSITION, true);
        this.fsi.writeLong(lastInstancePosition, true, "class info update last instance field", 2);
        this.fsi.setWritePosition(currentPosition, true);
    }

    protected void updateFirstInstanceFieldOfClassInfoWithId(OID classInfoId, long firstInstancePosition) {
        long currentPosition = this.fsi.getPosition();
        long classInfoPosition = this.idManager.getObjectPositionWithOid(classInfoId, true);
        this.fsi.setWritePosition(classInfoPosition + StorageEngineConstant.CLASS_OFFSET_CLASS_FIRST_OBJECT_POSITION, true);
        this.fsi.writeLong(firstInstancePosition, true, "class info update first instance field", 2);
        this.fsi.setWritePosition(currentPosition, true);
    }

    protected void updateNbObjectsFieldOfClassInfo(OID classInfoId, long nbObjects) {
        long currentPosition = this.fsi.getPosition();
        long classInfoPosition = this.getSession().getMetaModel().getClassInfoFromId(classInfoId).getPosition();
        this.fsi.setWritePosition(classInfoPosition + StorageEngineConstant.CLASS_OFFSET_CLASS_NB_OBJECTS, true);
        this.fsi.writeLong(nbObjects, true, "class info update nb objects", 2);
        this.fsi.setWritePosition(currentPosition, true);
    }

    public void updateObjectReference(long positionWhereTheReferenceIsStored, OID newOid, boolean writeInTransaction) {
        long position = positionWhereTheReferenceIsStored;
        if (position < 0L) {
            throw new ODBRuntimeException(NeoDatisError.NEGATIVE_POSITION.addParameter(position));
        }
        this.fsi.setWritePosition(position, writeInTransaction);
        long oid = 0L;
        if (newOid != null) {
            oid = -newOid.getObjectId();
        }
        this.fsi.writeLong(oid, writeInTransaction, "object reference", 2);
    }

    private boolean updateArrayElement(long arrayPosition, int arrayElementIndexToChange, NativeObjectInfo newValue, boolean writeInTransaction) throws Exception {
        long offset = ODBType.INTEGER.getSize() + ODBType.BYTE.getSize() + ODBType.INTEGER.getSize() + ODBType.BOOLEAN.getSize();
        this.fsi.setReadPosition(arrayPosition + offset);
        String arrayElementClassName = this.fsi.readString(false);
        ODBType arrayElementType = ODBType.getFromName(arrayElementClassName);
        if (!arrayElementType.isAtomicNative() || !arrayElementType.hasFixSize()) {
            return false;
        }
        Object a = null;
        int arraySize = this.fsi.readInt();
        if (arrayElementIndexToChange >= arraySize) {
            throw new ODBRuntimeException(NeoDatisError.INPLACE_UPDATE_NOT_POSSIBLE_FOR_ARRAY.addParameter(arraySize).addParameter(arrayElementIndexToChange));
        }
        long skip = arrayElementIndexToChange * ODBType.LONG.getSize();
        this.fsi.setReadPosition(this.fsi.getPosition() + skip);
        long elementArrayPosition = this.fsi.readLong();
        this.fsi.setWritePosition(elementArrayPosition, writeInTransaction);
        this.writeNativeObjectInfo(newValue, elementArrayPosition, true, writeInTransaction);
        return true;
    }

    public void flush() {
        this.fsi.flush();
    }

    public IIdManager getIdManager() {
        return this.idManager;
    }

    public void close() {
        this.objectReader = null;
        if (this.idManager != null) {
            this.idManager.clear();
            this.idManager = null;
        }
        this.storageEngine = null;
        this.fsi.close();
        this.fsi = null;
    }

    public static int getNbInPlaceUpdates() {
        return nbInPlaceUpdates;
    }

    public static void setNbInPlaceUpdates(int nbInPlaceUpdates) {
        AbstractObjectWriter.nbInPlaceUpdates = nbInPlaceUpdates;
    }

    public static int getNbNormalUpdates() {
        return nbNormalUpdates;
    }

    public static void setNbNormalUpdates(int nbNormalUpdates) {
        AbstractObjectWriter.nbNormalUpdates = nbNormalUpdates;
    }

    public static void resetNbUpdates() {
        nbInPlaceUpdates = 0;
        nbNormalUpdates = 0;
    }

    public IFileSystemInterface getFsi() {
        return this.fsi;
    }

    public OID delete(ObjectInfoHeader header) {
        ISession lsession = this.getSession();
        ICache cache = lsession.getCache();
        long objectPosition = header.getPosition();
        OID classInfoId = header.getClassInfoId();
        OID oid = header.getOid();
        ClassInfo ci = this.getSession().getMetaModel().getClassInfoFromId(classInfoId);
        boolean withIndex = !ci.getIndexes().isEmpty();
        NonNativeObjectInfo nnoi = null;
        if (withIndex) {
            nnoi = this.objectReader.readNonNativeObjectInfoFromPosition(ci, header.getOid(), objectPosition, true, false);
        }
        boolean objectIsInConnectedZone = cache.objectWithIdIsInCommitedZone(header.getOid());
        this.triggerManager.manageDeleteTriggerBefore(ci.getFullClassName(), null, header.getOid());
        long nbObjects = ci.getNumberOfObjects();
        OID previousObjectOID = header.getPreviousObjectOID();
        OID nextObjectOID = header.getNextObjectOID();
        boolean isFirstObject = previousObjectOID == null;
        boolean isLastObject = nextObjectOID == null;
        boolean mustUpdatePreviousObjectPointers = false;
        boolean mustUpdateNextObjectPointers = false;
        boolean mustUpdateLastObjectOfCI = false;
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("\nDeleting object with id " + header.getOid() + " - In connected zone =" + objectIsInConnectedZone + " -  with index =" + withIndex + " , type=" + ci.getFullClassName());
            DLogger.debug("position =  " + objectPosition + " | prev oid = " + previousObjectOID + " | next oid = " + nextObjectOID);
            DLogger.debug("isFirst=" + isFirstObject + "| isLast=" + isLastObject + " | nbObjects=" + ci.getNumberOfObjects());
            DLogger.debug("\n");
        }
        CommittedCIZoneInfo commitedZI = ci.getCommitedZoneInfo();
        if (isFirstObject || isLastObject) {
            if (isFirstObject) {
                if (objectIsInConnectedZone) {
                    ci.getCommitedZoneInfo().first = nextObjectOID;
                } else {
                    ci.getUncommittedZoneInfo().first = nextObjectOID;
                }
                if (nextObjectOID != null) {
                    this.updatePreviousObjectFieldOfObjectInfo(nextObjectOID, null, objectIsInConnectedZone);
                    mustUpdateNextObjectPointers = true;
                }
            }
            if (isLastObject) {
                if (objectIsInConnectedZone) {
                    ci.getCommitedZoneInfo().last = previousObjectOID;
                } else {
                    ci.getUncommittedZoneInfo().last = previousObjectOID;
                }
                if (previousObjectOID != null) {
                    this.updateNextObjectFieldOfObjectInfo(previousObjectOID, null, objectIsInConnectedZone);
                    mustUpdatePreviousObjectPointers = true;
                    mustUpdateLastObjectOfCI = true;
                }
            }
        } else {
            this.updateNextObjectFieldOfObjectInfo(previousObjectOID, nextObjectOID, objectIsInConnectedZone);
            this.updatePreviousObjectFieldOfObjectInfo(nextObjectOID, previousObjectOID, objectIsInConnectedZone);
            mustUpdateNextObjectPointers = true;
            mustUpdatePreviousObjectPointers = true;
        }
        if (mustUpdateNextObjectPointers) {
            this.updateNextObjectPreviousPointersInCache(nextObjectOID, previousObjectOID, cache);
        }
        if (mustUpdatePreviousObjectPointers) {
            ObjectInfoHeader oih = this.updatePreviousObjectNextPointersInCache(nextObjectOID, previousObjectOID, cache);
            if (mustUpdateLastObjectOfCI) {
                ci.setLastObjectInfoHeader(oih);
            }
        }
        MetaModel metaModel = lsession.getMetaModel();
        metaModel.addChangedClass(ci);
        if (objectIsInConnectedZone) {
            ((CIZoneInfo)commitedZI).decreaseNbObjects();
        } else {
            ci.getUncommittedZoneInfo().decreaseNbObjects();
        }
        boolean isLastObjectOfCommitedZone = oid.equals(commitedZI.last);
        if (isLastObjectOfCommitedZone) {
            ObjectInfoHeader oih = this.objectReader.readObjectInfoHeaderFromOid(oid, true);
            commitedZI.last = oih.getPreviousObjectOID();
            if (commitedZI.last == null && ((CIZoneInfo)commitedZI).hasObjects()) {
                throw new ODBRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("The last object of the commited zone has been deleted but the Zone still have objects : nbobjects=" + ((CIZoneInfo)commitedZI).getNbObjects()));
            }
        }
        CIZoneInfo uncommitedZI = ci.getUncommittedZoneInfo();
        boolean isFirstObjectOfUncommitedZone = oid.equals(uncommitedZI.first);
        if (isFirstObjectOfUncommitedZone) {
            if (uncommitedZI.hasObjects()) {
                ObjectInfoHeader oih = this.objectReader.readObjectInfoHeaderFromOid(oid, true);
                uncommitedZI.first = oih.getNextObjectOID();
            } else {
                uncommitedZI.first = null;
            }
        }
        if (isFirstObject && isLastObject) {
            ci.setLastObjectInfoHeader(null);
        }
        this.getIdManager().updateIdStatus(header.getOid(), (byte)2);
        this.markAsDeleted(objectPosition, header.getOid(), objectIsInConnectedZone);
        cache.markIdAsDeleted(header.getOid());
        if (withIndex) {
            this.manageIndexesForDelete(header.getOid(), nnoi);
        }
        this.triggerManager.manageDeleteTriggerAfter(ci.getFullClassName(), null, header.getOid());
        return header.getOid();
    }

    public void setTriggerManager(ITriggerManager triggerManager) {
        this.triggerManager = triggerManager;
    }
}

