/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.transaction;

import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.MetaModel;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.layers.layer2.meta.SessionMetaModel;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.layers.layer3.engine.IFileSystemInterface;
import org.neodatis.odb.core.transaction.ICache;
import org.neodatis.odb.core.transaction.ISession;
import org.neodatis.odb.core.transaction.ITmpCache;
import org.neodatis.odb.core.transaction.ITransaction;

public abstract class Session
implements Comparable,
ISession {
    protected ICache cache = this.buildCache();
    protected ITmpCache tmpCache = this.buildTmpCache();
    protected boolean rollbacked;
    public String id;
    protected String baseIdentification;
    protected MetaModel metaModel;
    protected boolean hasBeenCommitted;

    public Session(String id, String baseIdentification) {
        this.id = id;
        this.baseIdentification = baseIdentification;
    }

    public abstract ICache buildCache();

    public abstract ITmpCache buildTmpCache();

    public ICache getCache() {
        return this.cache;
    }

    public ITmpCache getTmpCache() {
        return this.tmpCache;
    }

    public void rollback() {
        this.clearCache();
        this.rollbacked = true;
    }

    public void close() {
        this.clear();
    }

    public void clearCache() {
        this.cache.clear(false);
    }

    public boolean isRollbacked() {
        return this.rollbacked;
    }

    public void clear() {
        this.cache.clear(true);
        if (this.metaModel != null) {
            this.metaModel.clear();
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String sessionId) {
        this.id = sessionId;
    }

    public abstract IStorageEngine getStorageEngine();

    public abstract boolean transactionIsPending();

    public abstract void commit();

    public abstract ITransaction getTransaction();

    public abstract void setFileSystemInterfaceToApplyTransaction(IFileSystemInterface var1);

    public String toString() {
        ITransaction transaction = null;
        transaction = this.getTransaction();
        if (transaction == null) {
            return "name=" + this.baseIdentification + " sid=" + this.id + " - no transaction";
        }
        int n = transaction.getNumberOfWriteActions();
        return "name=" + this.baseIdentification + " - sid=" + this.id + " - Nb Actions = " + n;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Session)) {
            return false;
        }
        ISession session = (ISession)obj;
        return this.getId().equals(session.getId());
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof Session)) {
            return -100;
        }
        ISession session = (ISession)o;
        return this.getId().compareTo(session.getId());
    }

    public String getBaseIdentification() {
        return this.baseIdentification;
    }

    public MetaModel getMetaModel() {
        if (this.metaModel == null) {
            this.metaModel = new SessionMetaModel();
            try {
                this.getStorageEngine().getObjectReader().readMetaModel(this.metaModel, true);
            }
            catch (Exception e) {
                throw new ODBRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("Session.getMetaModel"), (Throwable)e);
            }
        }
        return this.metaModel;
    }

    public void setMetaModel(MetaModel metaModel2) {
        this.metaModel = metaModel2;
    }

    public void setBaseIdentification(String baseIdentification) {
        this.baseIdentification = baseIdentification;
    }

    public void removeObjectFromCache(Object object) {
        this.cache.removeObject(object);
    }

    public void addObjectToCache(OID oid, Object object, ObjectInfoHeader oih) {
        if (object == null) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_NULL_OBJECT.addParameter(object));
        }
        if (oid == null) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_NULL_OID.addParameter(oid));
        }
        if (oih == null) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_NULL_OBJECT.addParameter(oih));
        }
        this.cache.addObject(oid, object, oih);
    }

    public boolean hasBeenCommitted() {
        return this.hasBeenCommitted;
    }

    public void setHasBeenCommitted(boolean hasBeenCommitted) {
        this.hasBeenCommitted = hasBeenCommitted;
    }
}

