/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.tool.mutex;

import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbThread;
import org.neodatis.tool.wrappers.OdbTime;

public class Mutex {
    private String name;
    protected boolean inUse;
    protected int nbOwners;
    private boolean debug;

    protected Mutex(String name) {
        this.name = name;
        this.inUse = false;
        this.nbOwners = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mutex acquire(String who) throws InterruptedException {
        if (this.debug) {
            DLogger.info("Thread " + OdbThread.getCurrentThreadName() + " - " + who + " : Trying to acquire mutex " + this.name);
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Mutex mutex = this;
        synchronized (mutex) {
            try {
                while (this.inUse) {
                    this.wait();
                }
                if (this.nbOwners != 0) {
                    throw new InterruptedException("nb owners != 0 - " + this.nbOwners);
                }
                this.inUse = true;
                ++this.nbOwners;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
        if (this.debug) {
            DLogger.info("Thread " + OdbThread.getCurrentThreadName() + " - " + who + " : Mutex " + this.name + " acquired!");
        }
        return this;
    }

    public synchronized void release(String who) {
        if (this.debug) {
            DLogger.info("Thread " + OdbThread.getCurrentThreadName() + " - " + who + " : Releasing mutex " + this.name);
        }
        this.inUse = false;
        --this.nbOwners;
        if (this.nbOwners < 0) {
            throw new ODBRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("Nb owner is negative in release(" + who + ")"));
        }
        this.notify();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean attempt(long msecs) throws InterruptedException {
        block20: {
            block19: {
                block18: {
                    block17: {
                        if (this.debug) {
                            DLogger.info("Thread " + OdbThread.getCurrentThreadName() + " : Trying to acquire(atempt) mutex " + this.name);
                        }
                        try {
                            if (Thread.interrupted()) {
                                throw new InterruptedException();
                            }
                            var3_2 = this;
                            synchronized (var3_2) {
                                if (!this.inUse) {
                                    this.inUse = true;
                                    ++this.nbOwners;
                                    var4_3 = true;
                                    // MONITOREXIT @DISABLED, blocks:[0, 16, 7] lbl12 : MonitorExitStatement: MONITOREXIT : var3_2
                                    var11_6 = null;
                                    if (this.debug == false) return var4_3;
                                    break block17;
                                }
                                if (msecs <= 0L) {
                                    var4_4 = false;
                                    // MONITOREXIT @DISABLED, blocks:[0, 7, 15] lbl19 : MonitorExitStatement: MONITOREXIT : var3_2
                                    break block18;
                                }
                                waitTime = msecs;
                                start = OdbTime.getCurrentTimeInMs();
                                while (true) {
                                    try {
                                        this.wait(waitTime);
                                        if (this.inUse) continue;
                                        this.inUse = true;
                                        ++this.nbOwners;
                                        var8_12 = true;
                                        break block19;
                                    }
                                    catch (InterruptedException ex) {
                                        this.notify();
                                        throw ex;
                                    }
                                    break;
                                }
                                {
                                    if ((waitTime = msecs - (OdbTime.getCurrentTimeInMs() - start)) > 0L) ** continue;
                                    var8_13 = false;
                                }
                            }
                            break block20;
                        }
                        catch (Throwable var10_15) {
                            var11_10 = null;
                            if (this.debug == false) throw var10_15;
                            DLogger.info("Thread " + OdbThread.getCurrentThreadName() + " : Mutex " + this.name + " acquired! (by attempt)");
                            throw var10_15;
                        }
                    }
                    DLogger.info("Thread " + OdbThread.getCurrentThreadName() + " : Mutex " + this.name + " acquired! (by attempt)");
                    return var4_3;
                }
                var11_7 = null;
                if (this.debug == false) return var4_4;
                DLogger.info("Thread " + OdbThread.getCurrentThreadName() + " : Mutex " + this.name + " acquired! (by attempt)");
                return var4_4;
            }
            var11_8 = null;
            if (this.debug == false) return var8_12;
            DLogger.info("Thread " + OdbThread.getCurrentThreadName() + " : Mutex " + this.name + " acquired! (by attempt)");
            return var8_12;
        }
        var11_9 = null;
        if (this.debug == false) return var8_13;
        DLogger.info("Thread " + OdbThread.getCurrentThreadName() + " : Mutex " + this.name + " acquired! (by attempt)");
        return var8_13;
    }

    public String getName() {
        return this.name;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public int getNbOwners() {
        return this.nbOwners;
    }
}

