/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.commandLine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.commandLine.command.CommandProvider;

public class CommandFactory {
    private static final String[] COMMAND_CLASSES = new String[]{"Import", "add", "annotate", "checkout", "commit", "diff", "export", "locbundlecheck", "log", "rannotate", "remove", "rlog", "rtag", "status", "tag", "update"};
    private static CommandFactory instance;
    private Map commandProvidersByNames;

    private CommandFactory() {
        this.createCommandProviders();
    }

    private void createCommandProviders() {
        this.commandProvidersByNames = new HashMap();
        String string = CommandFactory.class.getPackage().getName() + ".command.";
        for (int i = 0; i < COMMAND_CLASSES.length; ++i) {
            try {
                Class<?> clazz = Class.forName(string + COMMAND_CLASSES[i]);
                CommandProvider commandProvider = (CommandProvider)clazz.newInstance();
                this.commandProvidersByNames.put(commandProvider.getName(), commandProvider);
                String[] stringArray = commandProvider.getSynonyms();
                for (int j = 0; j < stringArray.length; ++j) {
                    this.commandProvidersByNames.put(stringArray[j], commandProvider);
                }
                continue;
            }
            catch (Exception exception) {
                System.err.println("Creation of command '" + COMMAND_CLASSES[i] + "' failed:");
                exception.printStackTrace(System.err);
            }
        }
    }

    public static synchronized CommandFactory getDefault() {
        if (instance == null) {
            instance = new CommandFactory();
        }
        return instance;
    }

    public Command createCommand(String string, String[] stringArray, int n, GlobalOptions globalOptions, String string2) throws IllegalArgumentException {
        CommandProvider commandProvider = (CommandProvider)this.commandProvidersByNames.get(string);
        if (commandProvider == null) {
            throw new IllegalArgumentException("Unknown command: '" + string + "'");
        }
        return commandProvider.createCommand(stringArray, n, globalOptions, string2);
    }

    public CommandProvider getCommandProvider(String string) {
        return (CommandProvider)this.commandProvidersByNames.get(string);
    }

    public CommandProvider[] getCommandProviders() {
        HashSet hashSet = new HashSet(this.commandProvidersByNames.values());
        return hashSet.toArray(new CommandProvider[0]);
    }
}

