/*
 * Decompiled with CFR 0.152.
 */
package ninja.servlet;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.servlet.ServletModule;
import java.util.Optional;
import ninja.Bootstrap;
import ninja.Context;
import ninja.servlet.NinjaServletContext;
import ninja.servlet.NinjaServletDispatcher;
import ninja.utils.NinjaPropertiesImpl;
import ninja.utils.SwissKnife;

public class NinjaServletBootstrap
extends Bootstrap {
    public NinjaServletBootstrap(NinjaPropertiesImpl ninjaProperties, Optional<Module> overrideModule) {
        super(ninjaProperties, overrideModule);
    }

    protected void configure() throws Exception {
        super.configure();
        this.addModule((Module)new AbstractModule(){

            protected void configure() {
                this.bind(Context.class).to(NinjaServletContext.class);
            }
        });
        String servletModuleClassName = this.ninjaBaseDirectoryResolver.resolveApplicationClassName("conf.ServletModule");
        if (SwissKnife.doesClassExist((String)servletModuleClassName, (Object)((Object)this))) {
            Class<?> servletModuleClass = Class.forName(servletModuleClassName);
            ServletModule servletModule = (ServletModule)servletModuleClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.addModule((Module)servletModule);
        } else {
            ServletModule servletModule = new ServletModule(){

                protected void configureServlets() {
                    this.bind(NinjaServletDispatcher.class).asEagerSingleton();
                    this.serve("/*", new String[0]).with(NinjaServletDispatcher.class);
                }
            };
            this.addModule((Module)servletModule);
        }
    }
}

