/*
 * Decompiled with CFR 0.152.
 */
package ninja.standalone;

import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.EventListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ninja.servlet.NinjaServletFilter;
import ninja.servlet.NinjaServletListener;
import ninja.standalone.AbstractStandalone;
import ninja.standalone.StandaloneHelper;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NinjaJetty
extends AbstractStandalone<NinjaJetty> {
    private static final Logger log = LoggerFactory.getLogger(NinjaJetty.class);
    public static final String KEY_NINJA_JETTY_CONFIGURATION = "ninja.jetty.configuration";
    public static final String DEFAULT_JETTY_CONFIGURATION = null;
    protected final NinjaServletListener ninjaServletListener = new NinjaServletListener();
    protected Server jetty;
    protected ServletContextHandler contextHandler;
    protected String jettyConfiguration;

    public NinjaJetty() {
        super("NinjaJetty");
    }

    public static void main(String[] args) {
        new NinjaJetty().run();
    }

    protected void doConfigure() throws Exception {
        this.jettyConfiguration(this.overlayedNinjaProperties.get(KEY_NINJA_JETTY_CONFIGURATION, this.jettyConfiguration, DEFAULT_JETTY_CONFIGURATION));
        if (this.jettyConfiguration != null) {
            String[] configs;
            for (String config : configs = this.jettyConfiguration.split(",")) {
                this.jetty = this.buildServerOrApplyConfiguration(config, this.jetty);
            }
            this.tryToSetHostAndPortFromJetty();
        } else {
            this.jetty = new Server();
            if (this.port > -1) {
                ServerConnector http = new ServerConnector(this.jetty);
                http.setPort(this.port.intValue());
                http.setIdleTimeout(this.idleTimeout.longValue());
                if (this.host != null) {
                    http.setHost(this.host);
                }
                this.jetty.addConnector((Connector)http);
            }
            if (this.sslPort > -1) {
                HttpConfiguration httpConfig = new HttpConfiguration();
                httpConfig.setSecureScheme("https");
                httpConfig.setSecurePort(this.sslPort.intValue());
                httpConfig.setOutputBufferSize(32768);
                HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
                httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                this.createSSLContext();
                SslContextFactory sslContextFactory = new SslContextFactory();
                sslContextFactory.setKeyStore(StandaloneHelper.loadKeyStore((URI)this.sslKeystoreUri, (char[])this.sslKeystorePassword.toCharArray()));
                sslContextFactory.setKeyManagerPassword(this.sslKeystorePassword);
                sslContextFactory.setTrustStore(StandaloneHelper.loadKeyStore((URI)this.sslTruststoreUri, (char[])this.sslTruststorePassword.toCharArray()));
                ServerConnector https = new ServerConnector(this.jetty, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
                https.setPort(this.sslPort.intValue());
                https.setIdleTimeout(this.idleTimeout.longValue());
                this.jetty.addConnector((Connector)https);
            }
        }
        this.ninjaServletListener.setNinjaProperties(this.ninjaProperties);
        if (this.overrideModuleOpt.isPresent()) {
            this.ninjaServletListener.setOverrideModule((Module)this.overrideModuleOpt.get());
        }
        this.contextHandler = new ServletContextHandler((HandlerContainer)this.jetty, this.getContextPath());
        this.contextHandler.addEventListener((EventListener)this.ninjaServletListener);
        this.contextHandler.addFilter(NinjaServletFilter.class, "/*", null);
        this.contextHandler.addServlet(DefaultServlet.class, "/");
        WebSocketServerContainerInitializer.configureContext((ServletContextHandler)this.contextHandler);
        this.contextHandler.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        this.contextHandler.setErrorHandler((ErrorHandler)new SilentErrorHandler());
    }

    public void doStart() throws Exception {
        String version = this.jetty.getClass().getPackage().getImplementationVersion();
        try {
            this.logger.info("Trying to start jetty v{} {}", (Object)version, (Object)this.getLoggableIdentifier());
            this.jetty.start();
        }
        catch (Exception e) {
            throw this.tryToUnwrapInjectorException(e);
        }
        this.logger.info("Started jetty v{} {}", (Object)version, (Object)this.getLoggableIdentifier());
    }

    public void doJoin() throws Exception {
        this.jetty.join();
    }

    public void doShutdown() {
        try {
            if (this.contextHandler != null) {
                this.contextHandler.stop();
                this.contextHandler.destroy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.jetty != null) {
                this.logger.info("Trying to stop jetty {}", (Object)this.getLoggableIdentifier());
                this.jetty.stop();
                this.jetty.destroy();
                this.logger.info("Stopped jetty {}", (Object)this.getLoggableIdentifier());
            }
        }
        catch (Exception e) {
            log.error("Unable to cleanly stop jetty", (Throwable)e);
        }
    }

    public String getJettyConfigureation() {
        return this.jettyConfiguration;
    }

    public NinjaJetty jettyConfiguration(String jettyConfiguration) {
        this.jettyConfiguration = jettyConfiguration;
        return this;
    }

    public Injector getInjector() {
        this.checkConfigured();
        return this.ninjaServletListener.getInjector();
    }

    private void tryToSetHostAndPortFromJetty() {
        Connector[] connectors = this.jetty.getConnectors();
        if (connectors != null && connectors.length > 0 && connectors[0] instanceof ServerConnector) {
            ServerConnector connector = (ServerConnector)connectors[0];
            this.host(connector.getHost());
            this.port(connector.getPort());
        }
    }

    private Server buildServerOrApplyConfiguration(String jettyConfiguration, Server server) throws Exception {
        Resource jettyConfigurationFile = Resource.newResource((String)jettyConfiguration);
        if (!(jettyConfigurationFile != null && jettyConfigurationFile.exists() || (jettyConfigurationFile = Resource.newClassPathResource((String)jettyConfiguration)) != null && jettyConfigurationFile.exists())) {
            throw new FileNotFoundException("Unable to find jetty configuration file either locally or on classpath '" + jettyConfiguration + "'");
        }
        this.logger.info("Applying jetty configuration '{}'", (Object)jettyConfigurationFile);
        try (InputStream is = jettyConfigurationFile.getInputStream();){
            XmlConfiguration configuration = new XmlConfiguration(is);
            if (server == null) {
                Server server2 = (Server)configuration.configure();
                return server2;
            }
            Server server3 = (Server)configuration.configure((Object)server);
            return server3;
        }
    }

    public static class SilentErrorHandler
    extends ErrorPageErrorHandler {
        private static final Logger log = LoggerFactory.getLogger(SilentErrorHandler.class);
        final String DEFAULT_RESPONSE_HTML = "<html>\n  <head>\n    <meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\"/>\n    <title>Oops. An error occurred.</title>\n  </head>\n  <body>\n    <h1>Oops. An error occurred.</h1>\n    <p>Please contact support if error persists.</p>\n  </body>\n</html>";

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            log.error("An error occurred that cannot be handled by Ninja {}. Responsing with default error page.", (Object)target);
            response.getWriter().append("<html>\n  <head>\n    <meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\"/>\n    <title>Oops. An error occurred.</title>\n  </head>\n  <body>\n    <h1>Oops. An error occurred.</h1>\n    <p>Please contact support if error persists.</p>\n  </body>\n</html>");
        }
    }
}

