/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Optional;
import ninja.jpa.JpaInitializer;
import ninja.jpa.JpaModule;
import ninja.utils.NinjaMode;
import ninja.utils.NinjaModeHelper;
import ninja.utils.NinjaProperties;
import ninja.utils.NinjaPropertiesImpl;
import org.junit.After;
import org.junit.Before;

public abstract class NinjaDaoTestBase {
    private JpaInitializer jpaInitializer;
    private Injector injector;
    private NinjaMode ninjaMode;

    public NinjaDaoTestBase() {
        Optional mode = NinjaModeHelper.determineModeFromSystemProperties();
        this.ninjaMode = mode.isPresent() ? (NinjaMode)mode.get() : NinjaMode.test;
    }

    public NinjaDaoTestBase(NinjaMode testMode) {
        this.ninjaMode = testMode;
    }

    @Before
    public final void initialize() {
        NinjaPropertiesImpl ninjaProperties = new NinjaPropertiesImpl(this.ninjaMode);
        this.injector = Guice.createInjector((Module[])new Module[]{new JpaModule((NinjaProperties)ninjaProperties)});
        this.jpaInitializer = (JpaInitializer)this.injector.getInstance(JpaInitializer.class);
        this.jpaInitializer.start();
    }

    @After
    public final void stop() {
        this.jpaInitializer.stop();
    }

    protected <T> T getInstance(Class<T> clazz) {
        return (T)this.injector.getInstance(clazz);
    }
}

