/*
 * Decompiled with CFR 0.152.
 */
package ninja.utils;

import com.google.inject.Injector;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import ninja.standalone.Standalone;
import ninja.standalone.StandaloneHelper;
import ninja.utils.NinjaMode;

public class NinjaTestServer
implements Closeable {
    private final Standalone<Standalone> standalone;

    public NinjaTestServer() {
        this(NinjaMode.test);
    }

    public NinjaTestServer(NinjaMode ninjaMode) {
        this(ninjaMode, StandaloneHelper.resolveStandaloneClass());
    }

    public NinjaTestServer(NinjaMode ninjaMode, int port) {
        this(ninjaMode, StandaloneHelper.resolveStandaloneClass(), port);
    }

    public NinjaTestServer(NinjaMode ninjaMode, Class<? extends Standalone> standaloneClass) {
        this(ninjaMode, standaloneClass, StandaloneHelper.findAvailablePort((int)1000, (int)10000));
    }

    public NinjaTestServer(NinjaMode ninjaMode, Class<? extends Standalone> standaloneClass, int port) {
        this.standalone = StandaloneHelper.create(standaloneClass);
        try {
            this.standalone.port(port).ninjaMode(ninjaMode);
            this.standalone.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public NinjaTestServer ninjaMode(NinjaMode ninjaMode) {
        this.standalone.ninjaMode(ninjaMode);
        return this;
    }

    @Deprecated
    public NinjaMode getNinjaMode() {
        return this.standalone.getNinjaMode();
    }

    public Injector getInjector() {
        return this.standalone.getInjector();
    }

    public String getServerUrl() {
        return (String)this.standalone.getServerUrls().get(0);
    }

    public String getBaseUrl() {
        return (String)this.standalone.getBaseUrls().get(0);
    }

    @Deprecated
    public String getServerAddress() {
        return (String)this.standalone.getServerUrls().get(0) + "/";
    }

    @Deprecated
    public URI getServerAddressAsUri() {
        try {
            return new URI(this.getServerAddress());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public void shutdown() {
        this.standalone.shutdown();
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }
}

