/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.activity;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityLinkBuilder;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.runtime.api.Framework;

public class ActivityReplyMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String activityReplyId;
    private final String actor;
    private final String displayActor;
    private final String displayActorLink;
    private final String message;
    private final long publishedDate;

    public ActivityReplyMessage(String activityReplyId, String actor, String displayActor, String displayActorLink, String message, long publishedDate) {
        this.activityReplyId = activityReplyId;
        this.actor = actor;
        this.displayActor = displayActor;
        this.displayActorLink = displayActorLink;
        this.message = message;
        this.publishedDate = publishedDate;
    }

    public String getActivityReplyId() {
        return this.activityReplyId;
    }

    public String getActor() {
        return this.actor;
    }

    public String getDisplayActor() {
        return this.displayActor;
    }

    public String getDisplayActorLink() {
        return this.displayActorLink;
    }

    public String getMessage() {
        return this.message;
    }

    public long getPublishedDate() {
        return this.publishedDate;
    }

    public Map<String, Object> toMap(CoreSession session, Locale locale) throws ClientException {
        return this.toMap(session, locale, null);
    }

    public Map<String, Object> toMap(CoreSession session, Locale locale, String activityLinkBuilderName) throws ClientException {
        ActivityLinkBuilder activityLinkBuilder = ((ActivityStreamService)Framework.getLocalService(ActivityStreamService.class)).getActivityLinkBuilder(activityLinkBuilderName);
        DateFormat dateFormat = DateFormat.getDateInstance(2, locale);
        HashMap<String, Object> o = new HashMap<String, Object>();
        o.put("id", this.getActivityReplyId());
        o.put("actor", this.getActor());
        o.put("displayActor", this.getDisplayActor());
        o.put("displayActorLink", this.getDisplayActorLink());
        if (ActivityHelper.isUser(this.getActor())) {
            String actorUsername = ActivityHelper.getUsername(this.getActor());
            o.put("actorAvatarURL", activityLinkBuilder.getUserAvatarURL(session, actorUsername));
        }
        o.put("activityMessage", this.getMessage());
        o.put("publishedDate", dateFormat.format(new Date(this.getPublishedDate())));
        return o;
    }
}

