/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.activity;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityBuilder;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.SystemPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.ShallowDocumentModel;
import org.nuxeo.runtime.api.Framework;

public class ActivityStreamListener
implements PostCommitEventListener {
    public void handleEvent(EventBundle events) throws ClientException {
        if (events.containsEventName("documentCreated") || events.containsEventName("documentModified") || events.containsEventName("documentRemoved")) {
            List<Event> filteredEvents = this.filterDuplicateEvents(events);
            for (Event event : filteredEvents) {
                this.handleEvent(event);
            }
        }
    }

    private List<Event> filterDuplicateEvents(EventBundle events) {
        List<Event> filteredEvents = new ArrayList<Event>();
        for (Event event : events) {
            filteredEvents = this.removeEventIfExist(filteredEvents, event);
            filteredEvents.add(event);
        }
        return filteredEvents;
    }

    private List<Event> removeEventIfExist(List<Event> events, Event event) {
        EventContext eventContext = event.getContext();
        if (eventContext instanceof DocumentEventContext) {
            DocumentModel doc = ((DocumentEventContext)eventContext).getSourceDocument();
            Iterator<Event> it = events.iterator();
            while (it.hasNext()) {
                Event filteredEvent = it.next();
                EventContext filteredEventContext = filteredEvent.getContext();
                if (!(filteredEventContext instanceof DocumentEventContext)) continue;
                DocumentModel filteredEventDoc = ((DocumentEventContext)filteredEventContext).getSourceDocument();
                if (!event.getName().equals(filteredEvent.getName()) || !doc.getRef().equals(filteredEventDoc.getRef())) continue;
                it.remove();
                break;
            }
        }
        return events;
    }

    private void handleEvent(Event event) throws ClientException {
        EventContext eventContext = event.getContext();
        if (eventContext instanceof DocumentEventContext && ("documentCreated".equals(event.getName()) || "documentRemoved".equals(event.getName()) || "documentModified".equals(event.getName()))) {
            DocumentEventContext docEventContext = (DocumentEventContext)eventContext;
            DocumentModel doc = docEventContext.getSourceDocument();
            if (doc instanceof ShallowDocumentModel || doc.hasFacet("HiddenInNavigation") || doc.isProxy() || doc.isVersion()) {
                return;
            }
            if (docEventContext.getPrincipal() instanceof SystemPrincipal) {
                return;
            }
            ActivityStreamService activityStreamService = (ActivityStreamService)Framework.getLocalService(ActivityStreamService.class);
            Activity activity = this.toActivity(docEventContext, event);
            activityStreamService.addActivity(activity);
            CoreSession session = docEventContext.getCoreSession();
            for (DocumentRef ref : this.getParentSuperSpaceRefs(session, doc)) {
                String context = ActivityHelper.createDocumentActivityObject(session.getRepositoryName(), ref.toString());
                activity = this.toActivity(docEventContext, event, context);
                activityStreamService.addActivity(activity);
            }
        }
    }

    private Activity toActivity(DocumentEventContext docEventContext, Event event) {
        return this.toActivity(docEventContext, event, null);
    }

    private Activity toActivity(DocumentEventContext docEventContext, Event event, String context) {
        Principal principal = docEventContext.getPrincipal();
        DocumentModel doc = docEventContext.getSourceDocument();
        return new ActivityBuilder().actor(ActivityHelper.createUserActivityObject(principal)).displayActor(ActivityHelper.generateDisplayName(principal)).verb(event.getName()).object(ActivityHelper.createDocumentActivityObject(doc)).displayObject(ActivityHelper.getDocumentTitle(doc)).target(ActivityHelper.createDocumentActivityObject(doc.getRepositoryName(), doc.getParentRef().toString())).displayTarget(this.getDocumentTitle(docEventContext.getCoreSession(), doc.getParentRef())).context(context).build();
    }

    private String getDocumentTitle(CoreSession session, DocumentRef docRef) {
        try {
            DocumentModel doc = session.getDocument(docRef);
            return ActivityHelper.getDocumentTitle(doc);
        }
        catch (ClientException e) {
            return docRef.toString();
        }
    }

    private List<DocumentRef> getParentSuperSpaceRefs(CoreSession session, final DocumentModel doc) throws ClientException {
        final ArrayList<DocumentRef> parents = new ArrayList<DocumentRef>();
        new UnrestrictedSessionRunner(session){

            public void run() throws ClientException {
                List parentDocuments = this.session.getParentDocuments(doc.getRef());
                for (DocumentModel parent : parentDocuments) {
                    if (!parent.hasFacet("SuperSpace")) continue;
                    parents.add(parent.getRef());
                }
            }
        }.runUnrestricted();
        return parents;
    }
}

