/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.activity;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.platform.ui.web.rest.api.URLPolicyService;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.user.center.profile.UserProfileService;
import org.nuxeo.runtime.api.Framework;

public class ActivityMessageHelper {
    public static Pattern HTTP_URL_PATTERN = Pattern.compile("\\b(https?://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])");

    private ActivityMessageHelper() {
    }

    public static String getDocumentLink(String documentActivityObject, String displayValue) {
        documentActivityObject = StringEscapeUtils.escapeHtml((String)documentActivityObject);
        displayValue = StringEscapeUtils.escapeHtml((String)displayValue);
        String link = "<a href=\"%s\" target=\"_top\">%s</a>";
        return String.format(link, ActivityMessageHelper.getDocumentURL(ActivityHelper.getRepositoryName(documentActivityObject), ActivityHelper.getDocumentId(documentActivityObject)), displayValue);
    }

    public static String getDocumentURL(String repositoryName, String documentId) {
        DocumentLocationImpl docLoc = new DocumentLocationImpl(repositoryName, (DocumentRef)new IdRef(documentId));
        DocumentViewImpl docView = new DocumentViewImpl((DocumentLocation)docLoc, "view_documents");
        URLPolicyService urlPolicyService = (URLPolicyService)Framework.getLocalService(URLPolicyService.class);
        return urlPolicyService.getUrlFromDocumentView("id", (DocumentView)docView, VirtualHostHelper.getContextPathProperty());
    }

    public static String getUserProfileLink(String userActivityObject, String displayValue) {
        userActivityObject = StringEscapeUtils.escapeHtml((String)userActivityObject);
        displayValue = StringEscapeUtils.escapeHtml((String)displayValue);
        String link = "<span class=\"username\"><a href=\"%s\" target=\"_top\" title=\"%s\">%s</a></span>";
        String username = ActivityHelper.getUsername(userActivityObject);
        return String.format(link, ActivityMessageHelper.getUserProfileURL(username), username, displayValue);
    }

    public static String getUserProfileURL(String username) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", username);
        DocumentViewImpl docView = new DocumentViewImpl(null, null, params);
        URLPolicyService urlPolicyService = (URLPolicyService)Framework.getLocalService(URLPolicyService.class);
        return VirtualHostHelper.getContextPathProperty() + "/" + urlPolicyService.getUrlFromDocumentView("user", (DocumentView)docView, null);
    }

    public static String getUserAvatarURL(CoreSession session, String username) {
        UserProfileService userProfileService = (UserProfileService)Framework.getLocalService(UserProfileService.class);
        DocumentModel profile = userProfileService.getUserProfileDocument(username, session);
        Blob avatar = (Blob)profile.getPropertyValue("userprofile:avatar");
        if (avatar != null) {
            DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
            String filename = username + "." + FilenameUtils.getExtension((String)avatar.getFilename());
            return VirtualHostHelper.getContextPathProperty() + "/" + downloadService.getDownloadUrl(profile, "userprofile:avatar", filename);
        }
        return VirtualHostHelper.getContextPathProperty() + "/icons/missing_avatar.png";
    }

    public static String replaceURLsByLinks(String message) {
        String escapedMessage = StringEscapeUtils.escapeHtml((String)message);
        Matcher m = HTTP_URL_PATTERN.matcher(escapedMessage);
        StringBuffer sb = new StringBuffer(escapedMessage.length());
        while (m.find()) {
            String url = m.group(1);
            m.appendReplacement(sb, ActivityMessageHelper.computeLinkFor(url));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static String computeLinkFor(String url) {
        return "<a href=\"" + url + "\" target=\"_top\">" + url + "</a>";
    }
}

