/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.comprehend;

import com.amazonaws.services.comprehend.AmazonComprehend;
import com.amazonaws.services.comprehend.AmazonComprehendClientBuilder;
import com.amazonaws.services.comprehend.model.DetectSentimentRequest;
import com.amazonaws.services.comprehend.model.DetectSentimentResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ai.comprehend.ComprehendService;
import org.nuxeo.runtime.aws.NuxeoAWSCredentialsProvider;
import org.nuxeo.runtime.aws.NuxeoAWSRegionProvider;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class ComprehendServiceImpl
extends DefaultComponent
implements ComprehendService {
    private static final Log log = LogFactory.getLog(ComprehendServiceImpl.class);
    protected volatile AmazonComprehend client;

    public void stop(ComponentContext context) throws InterruptedException {
        super.stop(context);
        this.client = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AmazonComprehend getClient() {
        AmazonComprehend localClient = this.client;
        if (localClient == null) {
            ComprehendServiceImpl comprehendServiceImpl = this;
            synchronized (comprehendServiceImpl) {
                localClient = this.client;
                if (localClient == null) {
                    AmazonComprehendClientBuilder builder = (AmazonComprehendClientBuilder)((AmazonComprehendClientBuilder)AmazonComprehendClientBuilder.standard().withCredentials(NuxeoAWSCredentialsProvider.getInstance())).withRegion(NuxeoAWSRegionProvider.getInstance().getRegion());
                    this.client = localClient = (AmazonComprehend)builder.build();
                }
            }
        }
        return localClient;
    }

    @Override
    public DetectSentimentResult detectSentiment(String text, String languageCode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Calling DetectSentiment for " + text));
        }
        DetectSentimentRequest detectSentimentRequest = new DetectSentimentRequest().withText(text).withLanguageCode(languageCode);
        DetectSentimentResult detectSentimentResult = this.getClient().detectSentiment(detectSentimentRequest);
        if (log.isDebugEnabled()) {
            log.debug((Object)("DetectSentimentResult is " + detectSentimentResult));
        }
        return detectSentimentResult;
    }
}

