/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.enrichment;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.rekognition.model.BoundingBox;
import com.amazonaws.services.rekognition.model.Celebrity;
import com.amazonaws.services.rekognition.model.ComparedFace;
import com.amazonaws.services.rekognition.model.RecognizeCelebritiesResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nuxeo.ai.enrichment.AbstractEnrichmentService;
import org.nuxeo.ai.enrichment.EnrichmentCachable;
import org.nuxeo.ai.enrichment.EnrichmentDescriptor;
import org.nuxeo.ai.enrichment.EnrichmentHelper;
import org.nuxeo.ai.enrichment.EnrichmentMetadata;
import org.nuxeo.ai.enrichment.EnrichmentUtils;
import org.nuxeo.ai.enrichment.FatalEnrichmentError;
import org.nuxeo.ai.metadata.AIMetadata;
import org.nuxeo.ai.pipes.services.JacksonUtil;
import org.nuxeo.ai.pipes.types.BlobTextFromDocument;
import org.nuxeo.ai.rekognition.RekognitionService;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.runtime.api.Framework;

public class DetectCelebritiesEnrichmentService
extends AbstractEnrichmentService
implements EnrichmentCachable {
    public static final String DEFAULT_CONFIDENCE = "70";
    protected float minConfidence;

    public void init(EnrichmentDescriptor descriptor) {
        super.init(descriptor);
        this.minConfidence = Float.parseFloat(descriptor.options.getOrDefault("minConfidence", DEFAULT_CONFIDENCE));
    }

    public Collection<EnrichmentMetadata> enrich(BlobTextFromDocument blobTextFromDoc) {
        ArrayList<EnrichmentMetadata> enriched = new ArrayList<EnrichmentMetadata>();
        try {
            for (Map.Entry blob : blobTextFromDoc.getBlobs().entrySet()) {
                RecognizeCelebritiesResult result = ((RekognitionService)Framework.getService(RekognitionService.class)).detectCelebrityFaces((ManagedBlob)blob.getValue());
                if (result == null || result.getCelebrityFaces().isEmpty() && result.getUnrecognizedFaces().isEmpty()) continue;
                enriched.addAll(this.processResults(blobTextFromDoc, (String)blob.getKey(), result));
            }
            return enriched;
        }
        catch (AmazonServiceException e) {
            throw EnrichmentHelper.isFatal(e) ? new FatalEnrichmentError((Throwable)e) : e;
        }
    }

    protected Collection<EnrichmentMetadata> processResults(BlobTextFromDocument blobTextFromDoc, String propName, RecognizeCelebritiesResult result) {
        List tags = Stream.concat(result.getCelebrityFaces().stream().map(this::newCelebrityTag), result.getUnrecognizedFaces().stream().map(this::newFaceTag)).filter(Objects::nonNull).collect(Collectors.toList());
        String raw = JacksonUtil.toJsonString(jg -> {
            jg.writeObjectField("celebrityFaces", (Object)result.getCelebrityFaces());
            jg.writeObjectField("unrecognizedFaces", (Object)result.getUnrecognizedFaces());
            jg.writeStringField("orientationCorrection", result.getOrientationCorrection());
        });
        String rawKey = this.saveJsonAsRawBlob(raw);
        return Collections.singletonList(new EnrichmentMetadata.Builder(this.kind, this.name, blobTextFromDoc).withTags(tags).withRawKey(rawKey).withDocumentProperties(Collections.singleton(propName)).build());
    }

    protected AIMetadata.Tag newCelebrityTag(Celebrity celebrity) {
        BoundingBox box = celebrity.getFace().getBoundingBox();
        if (celebrity.getMatchConfidence().floatValue() >= this.minConfidence) {
            return new AIMetadata.Tag(celebrity.getName(), this.kind, celebrity.getId(), new AIMetadata.Box(box.getWidth().floatValue(), box.getHeight().floatValue(), box.getLeft().floatValue(), box.getTop().floatValue()), null, celebrity.getMatchConfidence().floatValue() / 100.0f);
        }
        return null;
    }

    protected AIMetadata.Tag newFaceTag(ComparedFace faceDetail) {
        BoundingBox box = faceDetail.getBoundingBox();
        if (faceDetail.getConfidence().floatValue() >= this.minConfidence) {
            return new AIMetadata.Tag("face", "/tagging/face", null, new AIMetadata.Box(box.getWidth().floatValue(), box.getHeight().floatValue(), box.getLeft().floatValue(), box.getTop().floatValue()), null, faceDetail.getConfidence().floatValue() / 100.0f);
        }
        return null;
    }

    public String getCacheKey(BlobTextFromDocument blobTextFromDoc) {
        return EnrichmentUtils.makeKeyUsingBlobDigests((BlobTextFromDocument)blobTextFromDoc, (String)this.name);
    }
}

