/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.enrichment;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.rekognition.model.Attribute;
import com.amazonaws.services.rekognition.model.BoundingBox;
import com.amazonaws.services.rekognition.model.DetectFacesResult;
import com.amazonaws.services.rekognition.model.FaceDetail;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.nuxeo.ai.enrichment.AbstractEnrichmentService;
import org.nuxeo.ai.enrichment.EnrichmentCachable;
import org.nuxeo.ai.enrichment.EnrichmentDescriptor;
import org.nuxeo.ai.enrichment.EnrichmentHelper;
import org.nuxeo.ai.enrichment.EnrichmentMetadata;
import org.nuxeo.ai.enrichment.EnrichmentUtils;
import org.nuxeo.ai.enrichment.FatalEnrichmentError;
import org.nuxeo.ai.metadata.AIMetadata;
import org.nuxeo.ai.pipes.services.JacksonUtil;
import org.nuxeo.ai.pipes.types.BlobTextFromDocument;
import org.nuxeo.ai.rekognition.RekognitionService;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.runtime.api.Framework;

public class DetectFacesEnrichmentService
extends AbstractEnrichmentService
implements EnrichmentCachable {
    public static final String ATTRIBUTES_OPTION = "attribute";
    public static final String DEFAULT_CONFIDENCE = "70";
    public static final String DEFAULT_ATTRIBUTES = "ALL";
    protected float minConfidence;
    protected Attribute attribute;

    public void init(EnrichmentDescriptor descriptor) {
        super.init(descriptor);
        this.attribute = Attribute.valueOf((String)descriptor.options.getOrDefault(ATTRIBUTES_OPTION, DEFAULT_ATTRIBUTES));
        this.minConfidence = Float.parseFloat(descriptor.options.getOrDefault("minConfidence", DEFAULT_CONFIDENCE));
    }

    public Collection<EnrichmentMetadata> enrich(BlobTextFromDocument blobTextFromDoc) {
        ArrayList<EnrichmentMetadata> enriched = new ArrayList<EnrichmentMetadata>();
        try {
            for (Map.Entry blob : blobTextFromDoc.getBlobs().entrySet()) {
                DetectFacesResult result = ((RekognitionService)Framework.getService(RekognitionService.class)).detectFaces((ManagedBlob)blob.getValue(), this.attribute);
                if (result == null || result.getFaceDetails().isEmpty()) continue;
                enriched.addAll(this.processResults(blobTextFromDoc, (String)blob.getKey(), result));
            }
            return enriched;
        }
        catch (AmazonServiceException e) {
            throw EnrichmentHelper.isFatal(e) ? new FatalEnrichmentError((Throwable)e) : e;
        }
    }

    protected Collection<EnrichmentMetadata> processResults(BlobTextFromDocument blobTextFromDoc, String propName, DetectFacesResult result) {
        ArrayList<EnrichmentMetadata> metadata = new ArrayList<EnrichmentMetadata>();
        String raw = JacksonUtil.toJsonString(jg -> {
            jg.writeObjectField("faceDetails", (Object)result.getFaceDetails());
            jg.writeStringField("orientationCorrection", result.getOrientationCorrection());
        });
        String rawKey = this.saveJsonAsRawBlob(raw);
        List tags = result.getFaceDetails().stream().map(this::newFaceTag).filter(Objects::nonNull).collect(Collectors.toList());
        metadata.add((EnrichmentMetadata)new EnrichmentMetadata.Builder(this.kind, this.name, blobTextFromDoc).withTags(tags).withRawKey(rawKey).withDocumentProperties(Collections.singleton(propName)).build());
        return metadata;
    }

    protected AIMetadata.Tag newFaceTag(FaceDetail faceDetail) {
        BoundingBox box = faceDetail.getBoundingBox();
        if (faceDetail.getConfidence().floatValue() >= this.minConfidence) {
            List<AIMetadata.Label> labels = this.collectLabels(faceDetail);
            return new AIMetadata.Tag("face", this.kind, null, new AIMetadata.Box(box.getWidth().floatValue(), box.getHeight().floatValue(), box.getLeft().floatValue(), box.getTop().floatValue()), labels, faceDetail.getConfidence().floatValue());
        }
        return null;
    }

    protected List<AIMetadata.Label> collectLabels(FaceDetail faceDetail) {
        ArrayList<AIMetadata.Label> labels = new ArrayList<AIMetadata.Label>();
        if (faceDetail.getSmile() != null && faceDetail.getSmile().getValue().booleanValue() && faceDetail.getSmile().getConfidence().floatValue() > this.minConfidence) {
            labels.add(new AIMetadata.Label("smile", faceDetail.getSmile().getConfidence().floatValue() / 100.0f));
        }
        if (faceDetail.getEyeglasses() != null && faceDetail.getEyeglasses().getValue().booleanValue() && faceDetail.getEyeglasses().getConfidence().floatValue() > this.minConfidence) {
            labels.add(new AIMetadata.Label("eyeglasses", faceDetail.getEyeglasses().getConfidence().floatValue() / 100.0f));
        }
        if (faceDetail.getSunglasses() != null && faceDetail.getSunglasses().getValue().booleanValue() && faceDetail.getSunglasses().getConfidence().floatValue() > this.minConfidence) {
            labels.add(new AIMetadata.Label("sunglasses", faceDetail.getSunglasses().getConfidence().floatValue() / 100.0f));
        }
        if (faceDetail.getBeard() != null && faceDetail.getBeard().getValue().booleanValue() && faceDetail.getBeard().getConfidence().floatValue() > this.minConfidence) {
            labels.add(new AIMetadata.Label("beard", faceDetail.getBeard().getConfidence().floatValue() / 100.0f));
        }
        if (faceDetail.getMustache() != null && faceDetail.getMustache().getValue().booleanValue() && faceDetail.getMustache().getConfidence().floatValue() > this.minConfidence) {
            labels.add(new AIMetadata.Label("mustache", faceDetail.getMustache().getConfidence().floatValue() / 100.0f));
        }
        if (faceDetail.getEyesOpen() != null && faceDetail.getEyesOpen().getValue().booleanValue() && faceDetail.getEyesOpen().getConfidence().floatValue() > this.minConfidence) {
            labels.add(new AIMetadata.Label("eyesOpen", faceDetail.getEyesOpen().getConfidence().floatValue() / 100.0f));
        }
        if (faceDetail.getMouthOpen() != null && faceDetail.getMouthOpen().getValue().booleanValue() && faceDetail.getMouthOpen().getConfidence().floatValue() > this.minConfidence) {
            labels.add(new AIMetadata.Label("mouthOpen", faceDetail.getMouthOpen().getConfidence().floatValue() / 100.0f));
        }
        if (faceDetail.getGender() != null && faceDetail.getGender().getConfidence().floatValue() > this.minConfidence) {
            labels.add(new AIMetadata.Label(faceDetail.getGender().getValue().toLowerCase(), faceDetail.getGender().getConfidence().floatValue() / 100.0f));
        }
        if (faceDetail.getEmotions() != null && !faceDetail.getEmotions().isEmpty()) {
            faceDetail.getEmotions().forEach(emotion -> {
                if (emotion.getConfidence().floatValue() > this.minConfidence) {
                    labels.add(new AIMetadata.Label(emotion.getType().toLowerCase(), emotion.getConfidence().floatValue() / 100.0f));
                }
            });
        }
        return labels;
    }

    public String getCacheKey(BlobTextFromDocument blobTextFromDoc) {
        return EnrichmentUtils.makeKeyUsingBlobDigests((BlobTextFromDocument)blobTextFromDoc, (String)this.name);
    }
}

