/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.translate;

import com.amazonaws.services.translate.AmazonTranslate;
import com.amazonaws.services.translate.AmazonTranslateClientBuilder;
import com.amazonaws.services.translate.model.TranslateTextRequest;
import com.amazonaws.services.translate.model.TranslateTextResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ai.translate.TranslateService;
import org.nuxeo.runtime.aws.NuxeoAWSCredentialsProvider;
import org.nuxeo.runtime.aws.NuxeoAWSRegionProvider;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class TranslateServiceImpl
extends DefaultComponent
implements TranslateService {
    private static final Log log = LogFactory.getLog(TranslateServiceImpl.class);
    protected volatile AmazonTranslate client;

    public void stop(ComponentContext context) throws InterruptedException {
        super.stop(context);
        this.client = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AmazonTranslate getClient() {
        AmazonTranslate localClient = this.client;
        if (localClient == null) {
            TranslateServiceImpl translateServiceImpl = this;
            synchronized (translateServiceImpl) {
                localClient = this.client;
                if (localClient == null) {
                    AmazonTranslateClientBuilder builder = (AmazonTranslateClientBuilder)((AmazonTranslateClientBuilder)AmazonTranslateClientBuilder.standard().withCredentials(NuxeoAWSCredentialsProvider.getInstance())).withRegion(NuxeoAWSRegionProvider.getInstance().getRegion());
                    this.client = localClient = (AmazonTranslate)builder.build();
                }
            }
        }
        return localClient;
    }

    @Override
    public TranslateTextResult translateText(String text, String sourceLanguageCode, String targetLanguageCode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Calling Translate for " + text));
        }
        TranslateTextRequest request = new TranslateTextRequest().withText(text).withSourceLanguageCode(sourceLanguageCode).withTargetLanguageCode(targetLanguageCode);
        return this.getClient().translateText(request);
    }
}

