/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import com.amazonaws.services.rekognition.model.Image;
import com.amazonaws.services.rekognition.model.S3Object;
import org.nuxeo.ai.rekognition.RekognitionHelper;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.storage.sql.S3BinaryManager;

public class RekognitionHelperWithS3
implements RekognitionHelper {
    protected RekognitionHelper fallBackHelper;

    public RekognitionHelperWithS3(RekognitionHelper fallBackHelper) {
        this.fallBackHelper = fallBackHelper;
    }

    public S3Object getS3Object(S3BinaryManager s3BinaryManager, String key) {
        return new S3Object().withName(key).withBucket(s3BinaryManager.bucketName);
    }

    @Override
    public Image getImage(BlobProvider blobProvider, String blobKey) {
        if (blobProvider instanceof S3BinaryManager) {
            S3BinaryManager s3BinaryManager = (S3BinaryManager)blobProvider;
            S3Object s3Object = this.getS3Object(s3BinaryManager, blobKey);
            return new Image().withS3Object(s3Object);
        }
        return this.fallBackHelper.getImage(blobProvider, blobKey);
    }
}

