/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.enrichment;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.rekognition.model.BoundingBox;
import com.amazonaws.services.rekognition.model.DetectTextResult;
import com.amazonaws.services.rekognition.model.TextDetection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.nuxeo.ai.enrichment.AbstractEnrichmentService;
import org.nuxeo.ai.enrichment.EnrichmentCachable;
import org.nuxeo.ai.enrichment.EnrichmentDescriptor;
import org.nuxeo.ai.enrichment.EnrichmentHelper;
import org.nuxeo.ai.enrichment.EnrichmentMetadata;
import org.nuxeo.ai.enrichment.EnrichmentUtils;
import org.nuxeo.ai.enrichment.FatalEnrichmentError;
import org.nuxeo.ai.metadata.AIMetadata;
import org.nuxeo.ai.pipes.services.JacksonUtil;
import org.nuxeo.ai.pipes.types.BlobTextFromDocument;
import org.nuxeo.ai.rekognition.RekognitionService;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.runtime.api.Framework;

public class DetectTextEnrichmentService
extends AbstractEnrichmentService
implements EnrichmentCachable {
    public static final String TEXT_TYPES = "textTypes";
    public static final String DEFAULT_CONFIDENCE = "70";
    public static final String DEFAULT_TEXT_TYPES = "LINE,WORD";
    protected float minConfidence;
    protected Set<String> textTypes;

    public void init(EnrichmentDescriptor descriptor) {
        super.init(descriptor);
        Map options = descriptor.options;
        String textList = options.getOrDefault(TEXT_TYPES, DEFAULT_TEXT_TYPES);
        this.textTypes = new HashSet<String>(Arrays.asList(textList.split(",")));
        this.minConfidence = Float.parseFloat(options.getOrDefault("minConfidence", DEFAULT_CONFIDENCE));
    }

    protected AIMetadata.Tag newTag(TextDetection textD) {
        if (textD.getConfidence().floatValue() >= this.minConfidence && this.textTypes.contains(textD.getType())) {
            BoundingBox box = textD.getGeometry().getBoundingBox();
            return new AIMetadata.Tag(textD.getDetectedText(), this.kind, null, new AIMetadata.Box(box.getWidth().floatValue(), box.getHeight().floatValue(), box.getLeft().floatValue(), box.getTop().floatValue()), null, textD.getConfidence().floatValue() / 100.0f);
        }
        return null;
    }

    public Collection<EnrichmentMetadata> enrich(BlobTextFromDocument blobTextFromDoc) {
        ArrayList<EnrichmentMetadata> enriched = new ArrayList<EnrichmentMetadata>();
        try {
            for (Map.Entry blob : blobTextFromDoc.getBlobs().entrySet()) {
                DetectTextResult result = ((RekognitionService)Framework.getService(RekognitionService.class)).detectText((ManagedBlob)blob.getValue());
                if (result == null || result.getTextDetections().isEmpty()) continue;
                enriched.addAll(this.processResults(blobTextFromDoc, (String)blob.getKey(), result));
            }
            return enriched;
        }
        catch (AmazonServiceException e) {
            throw EnrichmentHelper.isFatal(e) ? new FatalEnrichmentError((Throwable)e) : e;
        }
    }

    protected Collection<EnrichmentMetadata> processResults(BlobTextFromDocument blobTextFromDoc, String propName, DetectTextResult result) {
        List tags = result.getTextDetections().stream().map(this::newTag).filter(Objects::nonNull).collect(Collectors.toList());
        String raw = JacksonUtil.toJsonString(jg -> jg.writeObjectField("textDetections", (Object)result.getTextDetections()));
        String rawKey = this.saveJsonAsRawBlob(raw);
        return Collections.singletonList(new EnrichmentMetadata.Builder(this.kind, this.name, blobTextFromDoc).withTags(tags).withRawKey(rawKey).withDocumentProperties(Collections.singleton(propName)).build());
    }

    public String getCacheKey(BlobTextFromDocument blobTextFromDoc) {
        return EnrichmentUtils.makeKeyUsingBlobDigests((BlobTextFromDocument)blobTextFromDoc, (String)this.name);
    }
}

