/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.enrichment;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkClientException;
import com.amazonaws.services.rekognition.model.DetectModerationLabelsResult;
import com.amazonaws.services.rekognition.model.ModerationLabel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.jodah.failsafe.RetryPolicy;
import org.nuxeo.ai.enrichment.AbstractEnrichmentService;
import org.nuxeo.ai.enrichment.EnrichmentCachable;
import org.nuxeo.ai.enrichment.EnrichmentDescriptor;
import org.nuxeo.ai.enrichment.EnrichmentHelper;
import org.nuxeo.ai.enrichment.EnrichmentMetadata;
import org.nuxeo.ai.enrichment.EnrichmentUtils;
import org.nuxeo.ai.enrichment.FatalEnrichmentError;
import org.nuxeo.ai.metadata.AIMetadata;
import org.nuxeo.ai.pipes.services.JacksonUtil;
import org.nuxeo.ai.pipes.types.BlobTextFromDocument;
import org.nuxeo.ai.rekognition.RekognitionService;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.runtime.api.Framework;

public class DetectUnsafeImagesEnrichmentService
extends AbstractEnrichmentService
implements EnrichmentCachable {
    public static final String MINIMUM_CONFIDENCE = "minConfidence";
    public static final String DEFAULT_CONFIDENCE = "70";
    protected float minConfidence;

    protected AIMetadata.Label newLabel(ModerationLabel l) {
        if (l.getConfidence().floatValue() >= this.minConfidence) {
            return new AIMetadata.Label(l.getName(), l.getConfidence().floatValue() / 100.0f);
        }
        return null;
    }

    public void init(EnrichmentDescriptor descriptor) {
        super.init(descriptor);
        Map options = descriptor.options;
        this.minConfidence = Float.parseFloat(options.getOrDefault(MINIMUM_CONFIDENCE, DEFAULT_CONFIDENCE));
    }

    public Collection<EnrichmentMetadata> enrich(BlobTextFromDocument blobTextFromDoc) {
        ArrayList<EnrichmentMetadata> enriched = new ArrayList<EnrichmentMetadata>();
        try {
            for (Map.Entry blob : blobTextFromDoc.getBlobs().entrySet()) {
                DetectModerationLabelsResult result = ((RekognitionService)Framework.getService(RekognitionService.class)).detectUnsafeImages((ManagedBlob)blob.getValue());
                if (result == null || result.getModerationLabels().isEmpty()) continue;
                enriched.addAll(this.processResult(blobTextFromDoc, (String)blob.getKey(), result));
            }
            return enriched;
        }
        catch (AmazonServiceException e) {
            throw EnrichmentHelper.isFatal(e) ? new FatalEnrichmentError((Throwable)e) : e;
        }
    }

    public RetryPolicy getRetryPolicy() {
        return super.getRetryPolicy().abortOn(SdkClientException.class);
    }

    protected Collection<EnrichmentMetadata> processResult(BlobTextFromDocument blobTextFromDoc, String propName, DetectModerationLabelsResult result) {
        List labels = result.getModerationLabels().stream().map(this::newLabel).filter(Objects::nonNull).collect(Collectors.toList());
        String raw = JacksonUtil.toJsonString(jg -> jg.writeObjectField("labels", (Object)result.getModerationLabels()));
        String rawKey = this.saveJsonAsRawBlob(raw);
        return Collections.singletonList(new EnrichmentMetadata.Builder(this.kind, this.name, blobTextFromDoc).withLabels(labels).withRawKey(rawKey).withDocumentProperties(Collections.singleton(propName)).build());
    }

    public String getCacheKey(BlobTextFromDocument blobTextFromDoc) {
        return EnrichmentUtils.makeKeyUsingBlobDigests((BlobTextFromDocument)blobTextFromDoc, (String)this.name);
    }
}

