/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.enrichment;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkClientException;
import com.amazonaws.services.rekognition.model.DetectLabelsResult;
import com.amazonaws.services.rekognition.model.Label;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.jodah.failsafe.RetryPolicy;
import org.nuxeo.ai.enrichment.AbstractEnrichmentService;
import org.nuxeo.ai.enrichment.EnrichmentCachable;
import org.nuxeo.ai.enrichment.EnrichmentDescriptor;
import org.nuxeo.ai.enrichment.EnrichmentHelper;
import org.nuxeo.ai.enrichment.EnrichmentMetadata;
import org.nuxeo.ai.enrichment.EnrichmentUtils;
import org.nuxeo.ai.enrichment.FatalEnrichmentError;
import org.nuxeo.ai.metadata.AIMetadata;
import org.nuxeo.ai.pipes.services.JacksonUtil;
import org.nuxeo.ai.pipes.types.BlobTextFromDocument;
import org.nuxeo.ai.rekognition.RekognitionService;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.runtime.api.Framework;

public class LabelsEnrichmentService
extends AbstractEnrichmentService
implements EnrichmentCachable {
    public static final String MINIMUM_CONFIDENCE = "minConfidence";
    public static final String DEFAULT_MAX_RESULTS = "200";
    public static final String DEFAULT_CONFIDENCE = "70";
    protected int maxResults;
    protected float minConfidence;

    protected static AIMetadata.Label newLabel(Label l) {
        return new AIMetadata.Label(l.getName(), l.getConfidence().floatValue() / 100.0f);
    }

    public void init(EnrichmentDescriptor descriptor) {
        super.init(descriptor);
        Map options = descriptor.options;
        this.maxResults = Integer.parseInt(options.getOrDefault("maxResults", DEFAULT_MAX_RESULTS));
        this.minConfidence = Float.parseFloat(options.getOrDefault(MINIMUM_CONFIDENCE, DEFAULT_CONFIDENCE));
    }

    public RetryPolicy getRetryPolicy() {
        return super.getRetryPolicy().abortOn(SdkClientException.class);
    }

    public Collection<EnrichmentMetadata> enrich(BlobTextFromDocument blobTextFromDoc) {
        ArrayList<EnrichmentMetadata> enriched = new ArrayList<EnrichmentMetadata>();
        try {
            for (Map.Entry blob : blobTextFromDoc.getBlobs().entrySet()) {
                DetectLabelsResult result = ((RekognitionService)Framework.getService(RekognitionService.class)).detectLabels((ManagedBlob)blob.getValue(), this.maxResults, this.minConfidence);
                if (result == null || result.getLabels().isEmpty()) continue;
                enriched.addAll(this.processResult(blobTextFromDoc, (String)blob.getKey(), result));
            }
            return enriched;
        }
        catch (AmazonServiceException e) {
            throw EnrichmentHelper.isFatal(e) ? new FatalEnrichmentError((Throwable)e) : e;
        }
    }

    protected Collection<EnrichmentMetadata> processResult(BlobTextFromDocument blobTextFromDoc, String propName, DetectLabelsResult result) {
        List labels = result.getLabels().stream().map(LabelsEnrichmentService::newLabel).filter(Objects::nonNull).collect(Collectors.toList());
        String raw = JacksonUtil.toJsonString(jg -> {
            jg.writeObjectField("labels", (Object)result.getLabels());
            jg.writeStringField("orientationCorrection", result.getOrientationCorrection());
        });
        String rawKey = this.saveJsonAsRawBlob(raw);
        return Collections.singletonList(new EnrichmentMetadata.Builder(this.kind, this.name, blobTextFromDoc).withLabels(labels).withRawKey(rawKey).withDocumentProperties(Collections.singleton(propName)).build());
    }

    public String getCacheKey(BlobTextFromDocument blobTextFromDoc) {
        return EnrichmentUtils.makeKeyUsingBlobDigests((BlobTextFromDocument)blobTextFromDoc, (String)this.name);
    }
}

