/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.enrichment;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.comprehend.model.DetectSentimentResult;
import com.amazonaws.services.comprehend.model.SentimentScore;
import com.amazonaws.services.comprehend.model.SentimentType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.jodah.failsafe.RetryPolicy;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ai.comprehend.ComprehendService;
import org.nuxeo.ai.enrichment.AbstractEnrichmentService;
import org.nuxeo.ai.enrichment.EnrichmentCachable;
import org.nuxeo.ai.enrichment.EnrichmentDescriptor;
import org.nuxeo.ai.enrichment.EnrichmentHelper;
import org.nuxeo.ai.enrichment.EnrichmentMetadata;
import org.nuxeo.ai.enrichment.EnrichmentUtils;
import org.nuxeo.ai.enrichment.FatalEnrichmentError;
import org.nuxeo.ai.metadata.AIMetadata;
import org.nuxeo.ai.pipes.services.JacksonUtil;
import org.nuxeo.ai.pipes.types.BlobTextFromDocument;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.api.Framework;

public class SentimentEnrichmentService
extends AbstractEnrichmentService
implements EnrichmentCachable {
    public static final String LANGUAGE_CODE = "language";
    public static final String DEFAULT_LANGUAGE = "en";
    protected String languageCode;

    public void init(EnrichmentDescriptor descriptor) {
        super.init(descriptor);
        this.languageCode = descriptor.options.getOrDefault(LANGUAGE_CODE, DEFAULT_LANGUAGE);
    }

    public Collection<EnrichmentMetadata> enrich(BlobTextFromDocument blobTextFromDoc) {
        ArrayList<EnrichmentMetadata> enriched = new ArrayList<EnrichmentMetadata>();
        try {
            for (Map.Entry prop : blobTextFromDoc.getProperties().entrySet()) {
                DetectSentimentResult result = ((ComprehendService)Framework.getService(ComprehendService.class)).detectSentiment((String)prop.getValue(), this.languageCode);
                if (result == null || !StringUtils.isNotEmpty((CharSequence)result.getSentiment())) continue;
                enriched.addAll(this.processResult(blobTextFromDoc, (String)prop.getKey(), result));
            }
            return enriched;
        }
        catch (AmazonServiceException e) {
            throw EnrichmentHelper.isFatal(e) ? new FatalEnrichmentError((Throwable)e) : e;
        }
    }

    protected Collection<EnrichmentMetadata> processResult(BlobTextFromDocument blobTextFromDoc, String propName, DetectSentimentResult result) {
        List<AIMetadata.Label> labels = this.getSentimentLabel(result);
        String raw = JacksonUtil.toJsonString(jg -> {
            jg.writeObjectField("sentimentScore", (Object)result.getSentimentScore());
            jg.writeStringField("sentiment", result.getSentiment());
        });
        String rawKey = this.saveJsonAsRawBlob(raw);
        return Collections.singletonList(new EnrichmentMetadata.Builder(this.kind, this.name, blobTextFromDoc).withLabels(labels).withRawKey(rawKey).withDocumentProperties(Collections.singleton(propName)).build());
    }

    public List<AIMetadata.Label> getSentimentLabel(DetectSentimentResult result) {
        Float confidence;
        SentimentType sentiment;
        ArrayList<AIMetadata.Label> labels = new ArrayList<AIMetadata.Label>(1);
        SentimentScore sentimentScore = result.getSentimentScore();
        try {
            sentiment = SentimentType.valueOf((String)result.getSentiment().toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new NuxeoException((Throwable)e);
        }
        switch (sentiment) {
            case POSITIVE: {
                confidence = sentimentScore.getPositive();
                break;
            }
            case NEGATIVE: {
                confidence = sentimentScore.getNegative();
                break;
            }
            case MIXED: {
                confidence = sentimentScore.getMixed();
                break;
            }
            case NEUTRAL: {
                confidence = sentimentScore.getNeutral();
                break;
            }
            default: {
                throw new NuxeoException("Invalid sentiment: " + sentiment);
            }
        }
        if (confidence == null) {
            throw new NuxeoException(String.format("A %s sentiment has been returned without any confidence score", sentiment));
        }
        labels.add(new AIMetadata.Label(sentiment.toString(), confidence.floatValue() / 100.0f));
        return labels;
    }

    public RetryPolicy getRetryPolicy() {
        return super.getRetryPolicy().abortOn(throwable -> throwable.getMessage().contains("is not authorized to perform"));
    }

    public String getCacheKey(BlobTextFromDocument blobTextFromDoc) {
        return EnrichmentUtils.makeKeyUsingProperties((BlobTextFromDocument)blobTextFromDoc, (String)this.name);
    }
}

