/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.enrichment;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.translate.model.TranslateTextResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ai.enrichment.AbstractEnrichmentService;
import org.nuxeo.ai.enrichment.EnrichmentCachable;
import org.nuxeo.ai.enrichment.EnrichmentDescriptor;
import org.nuxeo.ai.enrichment.EnrichmentHelper;
import org.nuxeo.ai.enrichment.EnrichmentMetadata;
import org.nuxeo.ai.enrichment.EnrichmentUtils;
import org.nuxeo.ai.enrichment.FatalEnrichmentError;
import org.nuxeo.ai.metadata.AIMetadata;
import org.nuxeo.ai.metadata.Suggestion;
import org.nuxeo.ai.pipes.services.JacksonUtil;
import org.nuxeo.ai.pipes.types.BlobTextFromDocument;
import org.nuxeo.ai.translate.TranslateService;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.api.Framework;

public class TranslateEnrichmentService
extends AbstractEnrichmentService
implements EnrichmentCachable {
    public static final String SOURCE_LANGUAGE_CODE = "sourceLanguage";
    public static final String TARGET_LANGUAGE_CODE = "targetLanguage";
    public static final String DEFAULT_SOURCE_LANGUAGE = "en";
    public static final String DEFAULT_TARGET_LANGUAGE = "es";
    public static final float CONFIDENCE = 0.95f;
    protected String sourceLanguageCode;
    protected String targetLanguageCode;

    public void init(EnrichmentDescriptor descriptor) {
        super.init(descriptor);
        this.sourceLanguageCode = descriptor.options.getOrDefault(SOURCE_LANGUAGE_CODE, DEFAULT_SOURCE_LANGUAGE);
        this.targetLanguageCode = descriptor.options.getOrDefault(TARGET_LANGUAGE_CODE, DEFAULT_TARGET_LANGUAGE);
    }

    public Collection<EnrichmentMetadata> enrich(BlobTextFromDocument blobTextFromDoc) {
        try {
            return Collections.singletonList(this.translate(blobTextFromDoc));
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected EnrichmentMetadata translate(BlobTextFromDocument blobTextFromDoc) throws IOException {
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        ArrayList<String> raw = new ArrayList<String>();
        for (Map.Entry textEntry : blobTextFromDoc.getProperties().entrySet()) {
            try {
                TranslateTextResult result = ((TranslateService)Framework.getService(TranslateService.class)).translateText((String)textEntry.getValue(), this.sourceLanguageCode, this.targetLanguageCode);
                if (result == null || !StringUtils.isNotEmpty((CharSequence)result.getTranslatedText())) continue;
                suggestions.add(this.processSuggestion((String)textEntry.getKey(), result));
                raw.add(this.processRaw((String)textEntry.getValue(), result));
            }
            catch (AmazonServiceException e) {
                throw EnrichmentHelper.isFatal(e) ? new FatalEnrichmentError((Throwable)e) : e;
            }
        }
        EnrichmentMetadata.Builder builder = new EnrichmentMetadata.Builder(this.kind, this.name, blobTextFromDoc);
        if (!raw.isEmpty()) {
            String rawKey = this.saveJsonAsRawBlob(JacksonUtil.MAPPER.writeValueAsString(raw));
            builder.withRawKey(rawKey);
        }
        return (EnrichmentMetadata)builder.withSuggestions(suggestions).build();
    }

    public String getCacheKey(BlobTextFromDocument blobTextFromDoc) {
        return EnrichmentUtils.makeKeyUsingProperties((BlobTextFromDocument)blobTextFromDoc, (String)this.name);
    }

    protected String processRaw(String text, TranslateTextResult result) {
        return JacksonUtil.toJsonString(jg -> {
            jg.writeObjectField("source", (Object)result.getSourceLanguageCode());
            jg.writeObjectField("target", (Object)result.getTargetLanguageCode());
            jg.writeStringField("text", text);
            jg.writeStringField("translated", result.getTranslatedText());
        });
    }

    protected Suggestion processSuggestion(String propName, TranslateTextResult result) {
        return new Suggestion(propName, Collections.singletonList(new AIMetadata.Label(result.getTranslatedText(), 0.95f)));
    }
}

