/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.rekognition;

import com.amazonaws.services.rekognition.model.Image;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ai.rekognition.RekognitionHelper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.BlobProvider;

public class DefaultRekognitionHelper
implements RekognitionHelper {
    private static final Log log = LogFactory.getLog(DefaultRekognitionHelper.class);

    @Override
    public Image getImage(BlobProvider blobProvider, String key) {
        BlobInfo blobInfo = new BlobInfo();
        blobInfo.key = key;
        try {
            Blob blob = blobProvider.readBlob(blobInfo);
            if (blob != null) {
                return new Image().withBytes(ByteBuffer.wrap(blob.getByteArray()));
            }
        }
        catch (IOException e) {
            log.error((Object)String.format("Failed to read blob %s", key), (Throwable)e);
        }
        return null;
    }
}

