/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.rekognition;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.services.rekognition.AmazonRekognition;
import com.amazonaws.services.rekognition.AmazonRekognitionClientBuilder;
import com.amazonaws.services.rekognition.model.Attribute;
import com.amazonaws.services.rekognition.model.DetectFacesRequest;
import com.amazonaws.services.rekognition.model.DetectFacesResult;
import com.amazonaws.services.rekognition.model.DetectLabelsRequest;
import com.amazonaws.services.rekognition.model.DetectLabelsResult;
import com.amazonaws.services.rekognition.model.DetectModerationLabelsRequest;
import com.amazonaws.services.rekognition.model.DetectModerationLabelsResult;
import com.amazonaws.services.rekognition.model.DetectTextRequest;
import com.amazonaws.services.rekognition.model.DetectTextResult;
import com.amazonaws.services.rekognition.model.Image;
import com.amazonaws.services.rekognition.model.RecognizeCelebritiesRequest;
import com.amazonaws.services.rekognition.model.RecognizeCelebritiesResult;
import java.util.function.BiFunction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ai.rekognition.DefaultRekognitionHelper;
import org.nuxeo.ai.rekognition.RekognitionHelper;
import org.nuxeo.ai.rekognition.RekognitionService;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.storage.sql.RekognitionHelperWithS3;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.aws.NuxeoAWSCredentialsProvider;
import org.nuxeo.runtime.aws.NuxeoAWSRegionProvider;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class RekognitionServiceImpl
extends DefaultComponent
implements RekognitionService {
    public static final boolean USE_S3_STORAGE;
    private static final Log log;
    protected volatile AmazonRekognition client;
    protected RekognitionHelper rekognitionHelper;

    @Override
    public DetectLabelsResult detectLabels(ManagedBlob blob, int maxResults, float minConfidence) {
        return this.detectWithClient(blob, (rekognitionClient, image) -> {
            DetectLabelsRequest detectLabelsRequest = new DetectLabelsRequest().withMaxLabels(Integer.valueOf(maxResults)).withMinConfidence(Float.valueOf(minConfidence)).withImage(image);
            return rekognitionClient.detectLabels(detectLabelsRequest);
        });
    }

    @Override
    public DetectTextResult detectText(ManagedBlob blob) {
        return this.detectWithClient(blob, (rekognitionClient, image) -> {
            DetectTextRequest request = new DetectTextRequest().withImage(image);
            return rekognitionClient.detectText(request);
        });
    }

    @Override
    public DetectFacesResult detectFaces(ManagedBlob blob, Attribute ... attributes) {
        return this.detectWithClient(blob, (rekognitionClient, image) -> {
            DetectFacesRequest request = new DetectFacesRequest().withImage(image).withAttributes(attributes);
            return rekognitionClient.detectFaces(request);
        });
    }

    @Override
    public RecognizeCelebritiesResult detectCelebrityFaces(ManagedBlob blob) {
        return this.detectWithClient(blob, (rekognitionClient, image) -> {
            RecognizeCelebritiesRequest request = new RecognizeCelebritiesRequest().withImage(image);
            return rekognitionClient.recognizeCelebrities(request);
        });
    }

    @Override
    public DetectModerationLabelsResult detectUnsafeImages(ManagedBlob blob) {
        return this.detectWithClient(blob, (rekognitionClient, image) -> {
            DetectModerationLabelsRequest request = new DetectModerationLabelsRequest().withImage(image);
            return rekognitionClient.detectModerationLabels(request);
        });
    }

    protected <T extends AmazonWebServiceResult> T detectWithClient(ManagedBlob blob, BiFunction<AmazonRekognition, Image, T> func) {
        BlobProvider blobProvider = ((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(blob.getProviderId());
        Image image = this.rekognitionHelper.getImage(blobProvider, blob.getKey());
        if (image != null) {
            AmazonWebServiceResult result = (AmazonWebServiceResult)func.apply(this.getClient(), image);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Result of call to AWS " + result));
            }
            return (T)result;
        }
        return null;
    }

    public void start(ComponentContext context) {
        super.start(context);
        this.rekognitionHelper = USE_S3_STORAGE ? new RekognitionHelperWithS3(new DefaultRekognitionHelper()) : new DefaultRekognitionHelper();
    }

    public void stop(ComponentContext context) throws InterruptedException {
        super.stop(context);
        this.client = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AmazonRekognition getClient() {
        AmazonRekognition localClient = this.client;
        if (localClient == null) {
            RekognitionServiceImpl rekognitionServiceImpl = this;
            synchronized (rekognitionServiceImpl) {
                localClient = this.client;
                if (localClient == null) {
                    AmazonRekognitionClientBuilder builder = (AmazonRekognitionClientBuilder)((AmazonRekognitionClientBuilder)AmazonRekognitionClientBuilder.standard().withCredentials(NuxeoAWSCredentialsProvider.getInstance())).withRegion(NuxeoAWSRegionProvider.getInstance().getRegion());
                    this.client = localClient = (AmazonRekognition)builder.build();
                }
            }
        }
        return localClient;
    }

    static {
        log = LogFactory.getLog(RekognitionServiceImpl.class);
        boolean hasS3BinaryManager = true;
        try {
            Class.forName("org.nuxeo.ecm.core.storage.sql.S3BinaryManager");
        }
        catch (ClassNotFoundException e) {
            hasS3BinaryManager = false;
        }
        USE_S3_STORAGE = hasS3BinaryManager;
    }
}

