/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.imagequality;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.nuxeo.ai.enrichment.EnrichmentDescriptor;
import org.nuxeo.ai.enrichment.EnrichmentMetadata;
import org.nuxeo.ai.enrichment.EnrichmentUtils;
import org.nuxeo.ai.imagequality.pojo.Box;
import org.nuxeo.ai.imagequality.pojo.Celebrity;
import org.nuxeo.ai.imagequality.pojo.Faces;
import org.nuxeo.ai.imagequality.pojo.ImageProperties;
import org.nuxeo.ai.metadata.AIMetadata;
import org.nuxeo.ai.pipes.services.JacksonUtil;
import org.nuxeo.ai.pipes.types.BlobTextFromDocument;
import org.nuxeo.ai.rest.RestEnrichmentService;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.ManagedBlob;

public class ImageQualityEnrichmentService
extends RestEnrichmentService {
    public static final String PARAM_API_SECRET = "api_secret";
    public static final String PARAM_API_USER = "api_user";
    public static final String PARAM_MODELS = "models";
    public static final String PARAM_MEDIA = "media";
    public static final String DEFAULT_SIGHTENGINE_MODELS = "properties";
    public static final String API_KEY_CONF = "nuxeo.ai.sightengine.apiKey";
    public static final String API_SECRET_CONF = "nuxeo.ai.sightengine.apiSecret";
    public static final String MINIMUM_CONFIDENCE = "minConfidence";
    public static final String DEFAULT_CONFIDENCE = "0.7";
    private static final Log log = LogFactory.getLog(ImageQualityEnrichmentService.class);
    protected String apiKey;
    protected String apiSecret;
    protected String models;
    protected float minConfidence;

    public void init(EnrichmentDescriptor descriptor) {
        super.init(descriptor);
        this.apiKey = (String)descriptor.options.get(API_KEY_CONF);
        this.apiSecret = (String)descriptor.options.get(API_SECRET_CONF);
        if (StringUtils.isBlank((CharSequence)this.apiKey) || StringUtils.isBlank((CharSequence)this.apiSecret)) {
            throw new IllegalArgumentException(String.format("%s and %s are required configuration parameters", API_KEY_CONF, API_SECRET_CONF));
        }
        this.models = descriptor.options.getOrDefault(PARAM_MODELS, DEFAULT_SIGHTENGINE_MODELS);
        this.minConfidence = Float.parseFloat(descriptor.options.getOrDefault(MINIMUM_CONFIDENCE, DEFAULT_CONFIDENCE));
    }

    public HttpUriRequest prepareRequest(RequestBuilder requestBuilder, BlobTextFromDocument blobTextFromDoc) {
        if (blobTextFromDoc.getBlobs().size() != 1) {
            throw new NuxeoException("Sightengine only supports one blob image at a time.");
        }
        File file = EnrichmentUtils.getBlobFromProvider((ManagedBlob)((ManagedBlob)blobTextFromDoc.getBlobs().values().stream().findFirst().get())).getFile();
        this.setMultipart(requestBuilder, builder -> {
            builder.addTextBody(PARAM_MODELS, this.models, ContentType.DEFAULT_BINARY);
            builder.addTextBody(PARAM_API_USER, this.apiKey, ContentType.DEFAULT_BINARY);
            builder.addTextBody(PARAM_API_SECRET, this.apiSecret, ContentType.DEFAULT_BINARY);
            builder.addBinaryBody(PARAM_MEDIA, file, ContentType.DEFAULT_BINARY, file.getName());
        });
        requestBuilder.addHeader("Cache-Control", "no-cache");
        return requestBuilder.build();
    }

    public Collection<EnrichmentMetadata> handleResponse(HttpResponse httpResponse, BlobTextFromDocument blobTextFromDoc) {
        String json = this.getContent(httpResponse);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returned json is " + json));
            }
            String rawKey = this.saveJsonAsRawBlob(json);
            ImageProperties imgProperties = (ImageProperties)JacksonUtil.MAPPER.readValue(json, ImageProperties.class);
            return this.processResponseProperties(imgProperties, rawKey, blobTextFromDoc);
        }
        catch (IOException e) {
            log.warn((Object)"Failed to process json return from siteengine.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    protected Collection<EnrichmentMetadata> processResponseProperties(ImageProperties props, String rawKey, BlobTextFromDocument blobTextFromDoc) {
        ArrayList<AIMetadata.Label> labels = new ArrayList<AIMetadata.Label>();
        ArrayList<AIMetadata.Tag> tags = new ArrayList<AIMetadata.Tag>();
        if (props.getAlcohol() > this.minConfidence) {
            labels.add(new AIMetadata.Label("alcohol", props.getAlcohol()));
        }
        if (props.getDrugs() > this.minConfidence) {
            labels.add(new AIMetadata.Label("drugs", props.getDrugs()));
        }
        if (props.getWeapon() > this.minConfidence) {
            labels.add(new AIMetadata.Label("weapon", props.getWeapon()));
        }
        if (props.getScam() != null && props.getScam().getProb() > this.minConfidence) {
            labels.add(new AIMetadata.Label("scam", props.getScam().getProb()));
        }
        if (props.getNudity() != null) {
            if (props.getNudity().getRaw() > this.minConfidence) {
                labels.add(new AIMetadata.Label("nudity/raw", props.getNudity().getRaw()));
            }
            if (props.getNudity().getPartial() > this.minConfidence) {
                labels.add(new AIMetadata.Label("nudity/partial", props.getNudity().getPartial()));
            }
            if (props.getNudity().getSafe() > this.minConfidence) {
                labels.add(new AIMetadata.Label("safe", props.getNudity().getSafe()));
            }
        }
        if (props.getText() != null && props.getText().getBoxes() != null && !props.getText().getBoxes().isEmpty()) {
            tags.addAll(props.getText().getBoxes().stream().map(this::newTag).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        if (props.getOffensive() != null) {
            if (props.getOffensive().getProb() > this.minConfidence) {
                labels.add(new AIMetadata.Label("offensive", props.getOffensive().getProb()));
            }
            if (props.getOffensive().getBoxes() != null && !props.getOffensive().getBoxes().isEmpty()) {
                tags.addAll(props.getOffensive().getBoxes().stream().map(this::newTag).filter(Objects::nonNull).collect(Collectors.toList()));
            }
        }
        if (props.getType() != null) {
            if (props.getType().getPhoto() > this.minConfidence) {
                labels.add(new AIMetadata.Label("photo", props.getType().getPhoto()));
            }
            if (props.getType().getIllustration() > this.minConfidence) {
                labels.add(new AIMetadata.Label("illustration", props.getType().getIllustration()));
            }
        }
        if (props.getFace() != null) {
            if (props.getFace().getSingle() > this.minConfidence) {
                labels.add(new AIMetadata.Label("face/single", props.getFace().getSingle()));
            }
            if (props.getFace().getMultiple() > this.minConfidence) {
                labels.add(new AIMetadata.Label("face/multiple", props.getFace().getMultiple()));
            }
        }
        if (props.getFaces() != null && !props.getFaces().isEmpty()) {
            for (Faces faces : props.getFaces()) {
                if (faces.getCelebrity() != null && !faces.getCelebrity().isEmpty()) {
                    for (Celebrity celebrity : faces.getCelebrity()) {
                        if (!(celebrity.getProb() > this.minConfidence)) continue;
                        labels.add(new AIMetadata.Label(celebrity.getName(), celebrity.getProb()));
                    }
                }
                if (faces.getAttributes() == null || faces.getAttributes().isEmpty()) continue;
                for (Map.Entry entry : faces.getAttributes().entrySet()) {
                    labels.add(new AIMetadata.Label((String)entry.getKey(), ((Float)entry.getValue()).floatValue()));
                }
            }
        }
        if (props.getColors() != null && props.getColors().getDominant() != null) {
            tags.add(new AIMetadata.Tag(props.getColors().getDominant().getHex(), "color/dominant", null, null, null, 0.1f));
        }
        labels.add(new AIMetadata.Label(props.getSharpnessDescription(), props.getSharpness()));
        labels.add(new AIMetadata.Label(props.getContrastDescription(), props.getContrast()));
        labels.add(new AIMetadata.Label(props.getBrightnessDescription(), props.getBrightness()));
        return Collections.singletonList(new EnrichmentMetadata.Builder(this.kind, this.name, blobTextFromDoc).withLabels(labels).withTags(tags).withRawKey(rawKey).build());
    }

    protected AIMetadata.Tag newTag(Box box) {
        if (box.getProb() >= this.minConfidence) {
            return new AIMetadata.Tag(box.getLabel(), this.kind, null, new AIMetadata.Box(box.getX2(), box.getY2(), (float)box.getX1(), (float)box.getY1()), null, box.getProb());
        }
        return null;
    }
}

