/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.imagequality.pojo;

import java.util.List;
import org.nuxeo.ai.imagequality.pojo.Colors;
import org.nuxeo.ai.imagequality.pojo.Face;
import org.nuxeo.ai.imagequality.pojo.Faces;
import org.nuxeo.ai.imagequality.pojo.Media;
import org.nuxeo.ai.imagequality.pojo.Nudity;
import org.nuxeo.ai.imagequality.pojo.Offensive;
import org.nuxeo.ai.imagequality.pojo.Request;
import org.nuxeo.ai.imagequality.pojo.Scam;
import org.nuxeo.ai.imagequality.pojo.Text;
import org.nuxeo.ai.imagequality.pojo.Type;

public class ImageProperties {
    public static final float SHARPNESS_VERY_BLURRY = 0.4f;
    public static final float SHARPNESS_BLURRY = 0.6f;
    public static final float SHARPNESS_SLIGHTLY_BLURRY = 0.8f;
    public static final float SHARPNESS_SHARP = 0.9f;
    public static final float SHARPNESS_VERY_SHARP = 1.0f;
    public static final String SHARPNESS_TXT_VERY_BLURRY = "Very blurry";
    public static final String SHARPNESS_TXT_BLURRY = "Blurry";
    public static final String SHARPNESS_TXT_SLIGHTLY_BLURRY = "Slightly blurry";
    public static final String SHARPNESS_TXT_SHARP = "Sharp";
    public static final String SHARPNESS_TXT_VERY_SHARP = "Very sharp";
    public static final String SHARPNESS_TXT_UNKNOWN = "Unknown sharp";
    public static final float BRIGHTNESS_VERY_DARK = 0.2f;
    public static final float BRIGHTNESS_DARK = 0.4f;
    public static final float BRIGHTNESS_LOW_BRIGHTNESS = 0.6f;
    public static final float BRIGHTNESS_BRIGHT = 0.8f;
    public static final float BRIGHTNESS_VERY_BRIGHT = 1.0f;
    public static final String BRIGHTNESS_TXT_VERY_DARK = "Very dark";
    public static final String BRIGHTNESS_TXT_DARK = "Dark";
    public static final String BRIGHTNESS_TXT_LOW_BRIGHTNESS = "Low brightness";
    public static final String BRIGHTNESS_TXT_BRIGHT = "Bright";
    public static final String BRIGHTNESS_TXT_VERY_BRIGHT = "Very bright";
    public static final String BRIGHTNESS_TXT_UNKNOWN = "Unknown bright";
    public static final float CONTRAST_LOW_CONTRAST = 0.3f;
    public static final float CONTRAST_AVERAGE_CONTRAST = 0.7f;
    public static final float CONTRAST_HIGH_CONTRAST = 1.0f;
    public static final String CONTRAST_TXT_LOW_CONTRAST = "Low contrast";
    public static final String CONTRAST_TXT_AVERAGE_CONTRAST = "Average contrast";
    public static final String CONTRAST_TXT_HIGH_CONTRAST = "High contrast";
    public static final String CONTRAST_TXT_UNKNOWN_CONTRAST = "Unknown contrast";
    private String status;
    private Request request;
    private float sharpness;
    private float brightness;
    private float contrast;
    private Colors colors;
    private Media media;
    private List<Faces> faces;
    private float weapon;
    private float alcohol;
    private float drugs;
    private Nudity nudity;
    private Type type;
    private Face face;
    private Scam scam;
    private Text text;
    private Offensive offensive;

    public Nudity getNudity() {
        return this.nudity;
    }

    public Face getFace() {
        return this.face;
    }

    public void setFace(Face face) {
        this.face = face;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Scam getScam() {
        return this.scam;
    }

    public void setScam(Scam scam) {
        this.scam = scam;
    }

    public Text getText() {
        return this.text;
    }

    public void setText(Text text) {
        this.text = text;
    }

    public Offensive getOffensive() {
        return this.offensive;
    }

    public void setOffensive(Offensive offensive) {
        this.offensive = offensive;
    }

    public void setNudity(Nudity nudity) {
        this.nudity = nudity;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public float getSharpness() {
        return this.sharpness;
    }

    public void setSharpness(float sharpness) {
        this.sharpness = sharpness;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
    }

    public float getContrast() {
        return this.contrast;
    }

    public void setContrast(float contrast) {
        this.contrast = contrast;
    }

    public Colors getColors() {
        return this.colors;
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }

    public Media getMedia() {
        return this.media;
    }

    public void setMedia(Media media) {
        this.media = media;
    }

    public float getWeapon() {
        return this.weapon;
    }

    public void setWeapon(float weapon) {
        this.weapon = weapon;
    }

    public float getAlcohol() {
        return this.alcohol;
    }

    public void setAlcohol(float alcohol) {
        this.alcohol = alcohol;
    }

    public float getDrugs() {
        return this.drugs;
    }

    public void setDrugs(float drugs) {
        this.drugs = drugs;
    }

    public String getSharpnessDescription() {
        if (this.sharpness < 0.4f) {
            return SHARPNESS_TXT_VERY_BLURRY;
        }
        if (this.sharpness < 0.6f) {
            return SHARPNESS_TXT_BLURRY;
        }
        if (this.sharpness < 0.8f) {
            return SHARPNESS_TXT_SLIGHTLY_BLURRY;
        }
        if (this.sharpness < 0.9f) {
            return SHARPNESS_TXT_SHARP;
        }
        if (this.sharpness <= 1.0f) {
            return SHARPNESS_TXT_VERY_SHARP;
        }
        return SHARPNESS_TXT_UNKNOWN;
    }

    public String getBrightnessDescription() {
        if (this.brightness < 0.2f) {
            return BRIGHTNESS_TXT_VERY_DARK;
        }
        if (this.brightness < 0.4f) {
            return BRIGHTNESS_TXT_DARK;
        }
        if (this.brightness < 0.6f) {
            return BRIGHTNESS_TXT_LOW_BRIGHTNESS;
        }
        if (this.brightness < 0.8f) {
            return BRIGHTNESS_TXT_BRIGHT;
        }
        if (this.brightness <= 1.0f) {
            return BRIGHTNESS_TXT_VERY_BRIGHT;
        }
        return BRIGHTNESS_TXT_UNKNOWN;
    }

    public String getContrastDescription() {
        if (this.contrast < 0.3f) {
            return CONTRAST_TXT_LOW_CONTRAST;
        }
        if (this.contrast < 0.7f) {
            return CONTRAST_TXT_AVERAGE_CONTRAST;
        }
        if (this.contrast <= 1.0f) {
            return CONTRAST_TXT_HIGH_CONTRAST;
        }
        return CONTRAST_TXT_UNKNOWN_CONTRAST;
    }

    public boolean isSuitableForCommercialUse() {
        int metricsFailed = 0;
        if (this.contrast < 0.7f) {
            metricsFailed = (short)(metricsFailed + 1);
        }
        if (this.brightness < 0.8f) {
            metricsFailed = (short)(metricsFailed + 1);
        }
        if (this.sharpness < 0.9f) {
            metricsFailed = (short)(metricsFailed + 1);
        }
        return metricsFailed < 2;
    }

    public boolean hasFaces() {
        return this.faces != null && !this.faces.isEmpty();
    }

    public List<Faces> getFaces() {
        return this.faces;
    }

    public void setFaces(List<Faces> faces) {
        this.faces = faces;
    }
}

