/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.bulk;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class DataSetExportDoneListener
implements EventListener {
    private static final Log log = LogFactory.getLog(DataSetExportDoneListener.class);

    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (ctx == null) {
            return;
        }
        String actionId = (String)((Object)ctx.getProperty("ACTION_ID"));
        String actionData = (String)((Object)ctx.getProperty("ACTION_DATA"));
        String repository = ctx.getRepositoryName();
        String user = (String)((Object)ctx.getProperty("ACTION_USER"));
        String blobRef = (String)((Object)ctx.getProperty("ACTION_BLOB_REF"));
        String providerRef = (String)((Object)ctx.getProperty("ACTION_BLOB_PROVIDER"));
        this.handleDataSetExportDone(actionId, actionData, blobRef, providerRef, repository, user);
    }

    protected void handleDataSetExportDone(String actionId, String actionData, String blobRef, String providerRef, String repository, String user) {
        TransactionHelper.runInTransaction(() -> {
            try (CloseableCoreSession session = CoreInstance.openCoreSession((String)repository, (String)user);){
                DocumentModelList docs = session.query(String.format("select * from %s WHERE %s = '%s'", "AI_Corpus", "ai_corpus:job_id", actionId));
                for (DocumentModel doc : docs) {
                    boolean isTraining = this.isTraining(actionData);
                    doc.setPropertyValue(isTraining ? "ai_corpus:training_data" : "ai_corpus:evaluation_data", (Serializable)((Object)blobRef));
                    session.saveDocument(doc);
                }
            }
        });
    }

    protected boolean isTraining(String actionData) {
        return "training".equals(actionData);
    }
}

