/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.cloud;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ai.cloud.CloudClient;
import org.nuxeo.ai.cloud.CloudConfigDescriptor;
import org.nuxeo.ai.pipes.services.JacksonUtil;
import org.nuxeo.client.NuxeoClient;
import org.nuxeo.client.objects.upload.BatchUpload;
import org.nuxeo.client.spi.auth.TokenAuthInterceptor;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class NuxeoCloudClient
extends DefaultComponent
implements CloudClient {
    public static final String XP_CONFIG = "config";
    public static final String DATASET_TEMPLATE = "{\n  \"entity-type\": \"document\",\n  \"name\": \"%s\",\n  \"type\": \"AI_Corpus\",\n  \"properties\": {\n    \"dc:title\": \"%s\",\n    \"ai_corpus:documents_count\": %s,\n    \"ai_corpus:evaluation_documents_count\": %s,\n    \"ai_corpus:query\": \"%s\",\n    \"ai_corpus:split\": \"%s\",\n    \"ai_corpus:fields\": %s,\n    \"ai_corpus:training_data\" : { \"upload-batch\": \"%s\", \"upload-fileId\": \"0\" },\n    \"ai_corpus:evaluation_data\" : { \"upload-batch\": \"%s\", \"upload-fileId\": \"1\" }\n  }\n}";
    private static final Log log = LogFactory.getLog(NuxeoCloudClient.class);
    protected String id;
    protected String url;
    protected NuxeoClient client;

    public void start(ComponentContext context) {
        super.start(context);
        List configs = this.getDescriptors(XP_CONFIG);
        if (!configs.isEmpty()) {
            if (configs.size() == 1) {
                this.configureClient((CloudConfigDescriptor)configs.get(0));
            } else {
                throw new IllegalArgumentException("Nuxeo cloud client requires 1 single configuration.");
            }
        }
    }

    protected void configureClient(CloudConfigDescriptor descriptor) {
        NuxeoClient.Builder builder = new NuxeoClient.Builder().url(descriptor.url);
        CloudConfigDescriptor.Authentication auth = descriptor.authentication;
        if (auth != null && StringUtils.isNotEmpty((CharSequence)auth.token)) {
            builder.authentication((Interceptor)new TokenAuthInterceptor(auth.token));
        } else if (auth != null && StringUtils.isNotEmpty((CharSequence)auth.username) && StringUtils.isNotEmpty((CharSequence)auth.password)) {
            builder.authentication(auth.username, auth.password);
        } else {
            throw new IllegalArgumentException("Nuxeo cloud client has incorrect authentication configuration.");
        }
        this.client = builder.connect();
        this.id = descriptor.getId();
        this.url = descriptor.url;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Nuxeo Cloud Client %s is configured for %s ", this.id, this.url));
        }
    }

    protected NuxeoClient getClient() {
        if (this.client == null) {
            throw new IllegalArgumentException("Nuxeo cloud client has no configuration. You should call client.isAvailable() first.");
        }
        return this.client;
    }

    @Override
    public boolean isAvailable() {
        return this.client != null;
    }

    @Override
    public void uploadDataset(DocumentModel corpusDoc) {
        if (corpusDoc != null) {
            BatchUpload batchUpload = this.getClient().batchUploadManager().createBatch();
            Blob trainingData = (Blob)corpusDoc.getPropertyValue("ai_corpus:training_data");
            Blob evalData = (Blob)corpusDoc.getPropertyValue("ai_corpus:evaluation_data");
            if (trainingData != null) {
                batchUpload = batchUpload.upload("0", trainingData.getFile(), trainingData.getDigest(), "application/x-tensorflow-record", trainingData.getLength());
            }
            if (evalData != null) {
                batchUpload = batchUpload.upload("1", evalData.getFile(), evalData.getFilename(), "application/x-tensorflow-record", evalData.getLength());
            }
            this.createDataset(corpusDoc, batchUpload.getBatchId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDataset(DocumentModel corpusDoc, String batchId) {
        String jobId = (String)((Object)corpusDoc.getPropertyValue("ai_corpus:job_id"));
        String query = (String)((Object)corpusDoc.getPropertyValue("ai_corpus:query"));
        Long docCount = (Long)corpusDoc.getPropertyValue("ai_corpus:documents_count");
        Long split = (Long)corpusDoc.getPropertyValue("ai_corpus:split");
        long trainingCount = 0L;
        long evalCount = 0L;
        if (docCount != null && docCount > 0L && split != null && split > 0L) {
            trainingCount = Math.round((double)docCount.longValue() * Double.valueOf("0." + split));
            evalCount = Math.round((double)docCount.longValue() * Double.valueOf("0." + (100L - split)));
        }
        String title = this.makeTitle(query, trainingCount, evalCount, jobId);
        Response response = null;
        try {
            List inputs = (List)((Object)corpusDoc.getPropertyValue("ai_corpus:inputs"));
            List outputs = (List)((Object)corpusDoc.getPropertyValue("ai_corpus:outputs"));
            ArrayList fields = new ArrayList(inputs);
            fields.addAll(outputs);
            String fieldsAsJson = JacksonUtil.MAPPER.writeValueAsString(fields);
            String payload = String.format(DATASET_TEMPLATE, jobId, title, trainingCount, evalCount, query, split, fieldsAsJson, batchId, batchId);
            response = this.getClient().post(this.url + "/api/v1/ai/" + this.id, payload);
            if (!response.isSuccessful()) {
                log.error((Object)("Failed to upload the corpus dataset. " + response.toString()));
            }
        }
        catch (IOException e) {
            log.error((Object)"Failed to process corpus dataset. ", (Throwable)e);
        }
        finally {
            if (response != null && response.body() != null) {
                response.body().close();
            }
        }
    }

    protected String makeTitle(String query, long trainingCount, long evalCount, String suffix) {
        String toReturn = trainingCount + "/" + evalCount + " " + suffix;
        int wherePos = (StringUtils.isBlank((CharSequence)query) ? "" : query.toLowerCase()).indexOf("where");
        if (wherePos == -1) {
            return toReturn;
        }
        return query.substring(wherePos + 5).trim() + " " + toReturn;
    }
}

