/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.model.serving;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ai.enrichment.EnrichmentService;
import org.nuxeo.ai.metadata.SuggestionMetadata;
import org.nuxeo.ai.model.AIModel;
import org.nuxeo.ai.model.ModelProperty;
import org.nuxeo.ai.model.serving.ModelDescriptor;
import org.nuxeo.ai.model.serving.ModelServingService;
import org.nuxeo.ai.model.serving.RuntimeModel;
import org.nuxeo.ai.pipes.functions.Predicates;
import org.nuxeo.ai.pipes.functions.PropertyUtils;
import org.nuxeo.ai.services.AIComponent;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolverService;
import org.nuxeo.ecm.directory.DirectoryEntryResolver;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ModelServingServiceImpl
extends DefaultComponent
implements ModelServingService {
    public static final String AI_DATATYPES = "aidatatypes";
    private static final String MODELS_AP = "models";
    protected final Map<String, ModelDescriptor> configs = new HashMap<String, ModelDescriptor>();
    protected final Map<String, RuntimeModel> models = new HashMap<String, RuntimeModel>();
    protected final Map<String, Predicate<DocumentModel>> predicates = new HashMap<String, Predicate<DocumentModel>>();
    protected DirectoryEntryResolver inputTypesResolver;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (MODELS_AP.equals(extensionPoint)) {
            ModelDescriptor descriptor = (ModelDescriptor)contribution;
            this.configs.put(descriptor.id, descriptor);
        }
    }

    public void start(ComponentContext context) {
        super.start(context);
        this.configs.forEach((key, value) -> this.addModel((ModelDescriptor)value));
    }

    @Override
    public void addModel(ModelDescriptor descriptor) {
        if (!descriptor.getInputs().stream().allMatch(i -> this.getInputTypesResolver().validate((Object)i.getType()))) {
            throw new IllegalArgumentException(String.format("The input types %s for service %s must be defined in the %s vocabulary", descriptor.getInputs(), descriptor.id, AI_DATATYPES));
        }
        RuntimeModel model = descriptor.getModel();
        if (model instanceof EnrichmentService) {
            ((AIComponent)Framework.getService(AIComponent.class)).addEnrichmentService(descriptor.id, (EnrichmentService)model);
        }
        this.models.put(descriptor.id, model);
        this.predicates.put(descriptor.id, ModelServingServiceImpl.makePredicate(descriptor.getInputs(), descriptor.filter.primaryType));
    }

    public void stop(ComponentContext context) throws InterruptedException {
        super.stop(context);
        this.inputTypesResolver = null;
        this.models.clear();
        this.predicates.clear();
    }

    @Override
    public Collection<AIModel> listModels() {
        return new ArrayList<AIModel>(this.models.values());
    }

    @Override
    public RuntimeModel getModel(String modelId) {
        return this.models.get(modelId);
    }

    @Override
    public Predicate<DocumentModel> getPredicate(String modelId) {
        return this.predicates.get(modelId);
    }

    @Override
    public List<SuggestionMetadata> predict(DocumentModel document) {
        return this.predicates.entrySet().stream().filter(e -> ((Predicate)e.getValue()).test(document)).map(e -> this.models.get(e.getKey()).predict(document)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Predicate<DocumentModel> makePredicate(Set<ModelProperty> inputs, String primaryType) {
        Predicate<DocumentModel> docPredicate = Predicates.doc();
        if (StringUtils.isNotBlank((CharSequence)primaryType)) {
            docPredicate = docPredicate.and(d -> primaryType.equals(d.getType()));
        }
        return docPredicate.and(d -> inputs.stream().allMatch(i -> PropertyUtils.notNull((DocumentModel)d, (String)i.getName())));
    }

    protected DirectoryEntryResolver getInputTypesResolver() {
        if (this.inputTypesResolver == null) {
            this.inputTypesResolver = (DirectoryEntryResolver)((ObjectResolverService)Framework.getService(ObjectResolverService.class)).getResolver("directoryResolver", Collections.singletonMap("directory", AI_DATATYPES));
        }
        return this.inputTypesResolver;
    }
}

