/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.cloud;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ai.cloud.CloudClient;
import org.nuxeo.ai.cloud.CloudConfigDescriptor;
import org.nuxeo.ai.pipes.services.JacksonUtil;
import org.nuxeo.client.NuxeoClient;
import org.nuxeo.client.objects.upload.BatchUpload;
import org.nuxeo.client.spi.auth.TokenAuthInterceptor;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class NuxeoCloudClient
extends DefaultComponent
implements CloudClient {
    public static final String XP_CONFIG = "config";
    public static final String DATASET_TEMPLATE = "{\n  \"entity-type\": \"document\",\n  \"name\": \"%s\",\n  \"type\": \"AI_Corpus\",\n  \"properties\": {\n    \"dc:title\": \"%s\",\n    \"ai_corpus:documents_count\": %s,\n    \"ai_corpus:evaluation_documents_count\": %s,\n    \"ai_corpus:query\": \"%s\",\n    \"ai_corpus:split\": \"%s\",\n    \"ai_corpus:fields\": %s,\n    \"ai_corpus:training_data\" : { \"upload-batch\": \"%s\", \"upload-fileId\": \"0\" },\n    \"ai_corpus:evaluation_data\" : { \"upload-batch\": \"%s\", \"upload-fileId\": \"1\" },\n    \"ai_corpus:statistics\" : { \"upload-batch\": \"%s\", \"upload-fileId\": \"2\" }\n  }\n}";
    public static final String API_V1_AI = "/api/v1/ai/";
    private static final Logger log = LogManager.getLogger(NuxeoCloudClient.class);
    protected String projectId;
    protected String url;
    protected NuxeoClient client;

    public void start(ComponentContext context) {
        super.start(context);
        List configs = this.getDescriptors(XP_CONFIG);
        if (!configs.isEmpty()) {
            if (configs.size() == 1) {
                this.configureClient((CloudConfigDescriptor)configs.get(0));
            } else {
                throw new IllegalArgumentException("Nuxeo cloud client requires 1 single configuration.");
            }
        }
    }

    protected void configureClient(CloudConfigDescriptor descriptor) {
        NuxeoClient.Builder builder = new NuxeoClient.Builder().url(descriptor.url);
        CloudConfigDescriptor.Authentication auth = descriptor.authentication;
        if (auth != null && StringUtils.isNotEmpty((CharSequence)auth.token)) {
            builder.authentication((Interceptor)new TokenAuthInterceptor(auth.token));
        } else if (auth != null && StringUtils.isNotEmpty((CharSequence)auth.username) && StringUtils.isNotEmpty((CharSequence)auth.password)) {
            builder.authentication(auth.username, auth.password);
        } else {
            throw new IllegalArgumentException("Nuxeo cloud client has incorrect authentication configuration.");
        }
        this.projectId = descriptor.projectId;
        this.url = descriptor.url;
        if (StringUtils.isBlank((CharSequence)this.url) || StringUtils.isBlank((CharSequence)this.projectId)) {
            throw new IllegalArgumentException("url and projectId are mandatory fields for cloud configuration.");
        }
        this.client = builder.connect();
        log.debug("Nuxeo Cloud Client {} is configured for {}.", (Object)this.projectId, (Object)this.url);
    }

    protected NuxeoClient getClient() {
        if (this.client == null) {
            throw new IllegalArgumentException("Nuxeo cloud client has no configuration. You should call client.isAvailable() first.");
        }
        return this.client;
    }

    @Override
    public boolean isAvailable() {
        return this.client != null;
    }

    @Override
    public boolean uploadedDataset(DocumentModel corpusDoc) {
        if (corpusDoc != null) {
            String jobId = (String)((Object)corpusDoc.getPropertyValue("ai_corpus:job_id"));
            Blob trainingData = (Blob)corpusDoc.getPropertyValue("ai_corpus:training_data");
            Blob evalData = (Blob)corpusDoc.getPropertyValue("ai_corpus:evaluation_data");
            Blob statsData = (Blob)corpusDoc.getPropertyValue("ai_corpus:statistics");
            if (trainingData == null) {
                log.error("Job: {} has no training data.", (Object)jobId);
            }
            if (evalData == null) {
                log.error("Job: {} has no evaluation data.", (Object)jobId);
            }
            if (statsData == null) {
                log.error("Job: {} has no statistics data.", (Object)jobId);
            }
            if (trainingData != null && evalData != null && statsData != null) {
                BatchUpload batchUpload = this.getClient().batchUploadManager().createBatch();
                batchUpload = batchUpload.upload("0", trainingData.getFile(), trainingData.getDigest(), "application/x-tensorflow-record", trainingData.getLength());
                batchUpload = batchUpload.upload("1", evalData.getFile(), evalData.getFilename(), "application/x-tensorflow-record", evalData.getLength());
                batchUpload = batchUpload.upload("2", statsData.getFile(), statsData.getFilename(), statsData.getMimeType(), statsData.getLength());
                return this.createDataset(corpusDoc, batchUpload.getBatchId());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean createDataset(DocumentModel corpusDoc, String batchId) {
        String jobId = (String)((Object)corpusDoc.getPropertyValue("ai_corpus:job_id"));
        String query = (String)((Object)corpusDoc.getPropertyValue("ai_corpus:query"));
        Long docCount = (Long)corpusDoc.getPropertyValue("ai_corpus:documents_count");
        Long split = (Long)corpusDoc.getPropertyValue("ai_corpus:split");
        long trainingCount = 0L;
        long evalCount = 0L;
        if (docCount != null && docCount > 0L && split != null && split > 0L) {
            trainingCount = Math.round((double)docCount.longValue() * Double.valueOf("0." + split));
            evalCount = Math.round((double)docCount.longValue() * Double.valueOf("0." + (100L - split)));
        }
        Response response = null;
        try {
            List inputs = (List)((Object)corpusDoc.getPropertyValue("ai_corpus:inputs"));
            List outputs = (List)((Object)corpusDoc.getPropertyValue("ai_corpus:outputs"));
            ArrayList fields = new ArrayList(inputs);
            fields.addAll(outputs);
            String title = this.makeTitle(trainingCount, evalCount, jobId, fields.size());
            String fieldsAsJson = JacksonUtil.MAPPER.writeValueAsString(fields);
            String payload = String.format(DATASET_TEMPLATE, jobId, title, trainingCount, evalCount, query, split, fieldsAsJson, batchId, batchId, batchId);
            log.debug("Uploading to cloud project: {}, payload {}", (Object)this.projectId, (Object)payload);
            response = this.getClient().post(this.getBaseUrl(), payload);
            log.debug("Upload to cloud project: {}, finished.", (Object)this.projectId);
            if (!response.isSuccessful()) {
                log.error("Failed to upload the corpus dataset. " + response.toString());
            }
            boolean bl = response.isSuccessful();
            return bl;
        }
        catch (IOException e) {
            log.error("Failed to process corpus dataset. ", (Throwable)e);
        }
        finally {
            if (response != null && response.body() != null) {
                response.body().close();
            }
        }
        return false;
    }

    @Override
    public <T> T post(String postUrl, String jsonBody, CloudClient.ResponseHandler<T> handler) {
        try {
            Response response = this.getClient().post(this.getBaseUrl() + postUrl, jsonBody);
            if (response != null && handler != null) {
                if (response.isSuccessful()) {
                    return handler.handleResponse(response);
                }
                log.warn(String.format("Unsuccessful call to (%s), status is %d", postUrl, response.code()));
            }
        }
        catch (IOException e) {
            log.info(String.format("Unsuccessful call to api %s", postUrl), (Throwable)e);
        }
        return null;
    }

    @Override
    public String getBaseUrl() {
        return this.url + API_V1_AI + this.projectId;
    }

    protected String makeTitle(long trainingCount, long evalCount, String suffix, int numberOfFields) {
        return String.format("%s features, %s Training, %s Evaluation, Export id %s", numberOfFields, trainingCount, evalCount, suffix);
    }
}

