/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.model.export;

import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuxeo.ai.pipes.services.JacksonUtil;
import org.nuxeo.ecm.platform.query.api.Aggregate;
import org.nuxeo.elasticsearch.aggregate.MultiBucketAggregate;
import org.nuxeo.elasticsearch.aggregate.SingleBucketAggregate;
import org.nuxeo.elasticsearch.aggregate.SingleValueMetricAggregate;

public class Statistic {
    protected final String id;
    protected final String field;
    protected final String type;
    @JsonRawValue
    protected final String value;
    protected final Number numericValue;

    public Statistic(String id, String field, String type, String value, Number numericValue) {
        this.id = id;
        this.field = field;
        this.type = type;
        this.value = value;
        this.numericValue = numericValue;
    }

    public static Statistic of(String id, String field, String type, String value, Number numericValue) {
        return new Statistic(id, field, type, value, numericValue);
    }

    public static Statistic from(Aggregate agg) {
        Number numericValue = null;
        String value = null;
        if (agg instanceof SingleValueMetricAggregate) {
            Double val = ((SingleValueMetricAggregate)agg).getValue();
            numericValue = Double.isFinite(val) ? val : -1.0;
        } else if (agg instanceof SingleBucketAggregate) {
            numericValue = ((SingleBucketAggregate)agg).getDocCount();
        } else if (agg instanceof MultiBucketAggregate) {
            List buckets = agg.getBuckets();
            try {
                value = JacksonUtil.MAPPER.writeValueAsString((Object)buckets);
            }
            catch (JsonProcessingException e) {
                throw new UnsupportedOperationException("Unable to create a statistic for " + agg.getType(), e);
            }
        } else {
            throw new UnsupportedOperationException("Unable to create a statistic for " + agg.getType());
        }
        return new Statistic(agg.getId(), agg.getField(), agg.getType(), value, numericValue);
    }

    public String getId() {
        return this.id;
    }

    public String getField() {
        return this.field;
    }

    public String getType() {
        return this.type;
    }

    public Number getNumericValue() {
        return this.numericValue;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

