/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.pipes.events;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.nuxeo.ai.pipes.streams.Initializable;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class DirtyEventListener
implements EventListener,
Initializable {
    public static final String DIRTY = "dirty_prop_";
    public static final String DIRTY_EVENT_NAME = "beforeDocumentModification";
    protected List<String> properties;

    public DirtyEventListener(Map<String, String> options) {
        this.init(options);
    }

    public static String makeDirtyKey(String propertyName) {
        return DIRTY + propertyName;
    }

    @Override
    public void init(Map<String, String> options) {
        this.properties = this.propsList(options.get("properties"));
    }

    public void handleEvent(Event event) {
        DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
        if (docCtx == null) {
            return;
        }
        DocumentModel doc = docCtx.getSourceDocument();
        if (doc != null && !doc.isProxy()) {
            this.properties.forEach(propName -> {
                try {
                    Property prop = doc.getProperty(propName);
                    if (prop != null && prop.isDirty()) {
                        docCtx.setProperty(DirtyEventListener.makeDirtyKey(propName), (Serializable)Boolean.valueOf(true));
                    }
                }
                catch (PropertyNotFoundException propertyNotFoundException) {
                    // empty catch block
                }
            });
        }
    }
}

