/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.pipes.events;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ai.pipes.functions.MetricsProducer;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.runtime.metrics.NuxeoMetricSet;

public class EventConsumer<R>
implements EventListener,
MetricsProducer {
    private static final Log log = LogFactory.getLog(EventConsumer.class);
    private final Function<Event, Collection<R>> function;
    private final Consumer<R> consumer;
    private long handled = 0L;
    private long consumed = 0L;

    public EventConsumer(Function<Event, Collection<R>> function, Consumer<R> consumer) {
        this.function = function;
        this.consumer = consumer;
    }

    public void handleEvent(Event event) {
        ++this.handled;
        Collection<R> applied = this.function.apply(event);
        if (applied != null && !applied.isEmpty()) {
            applied.forEach(i -> {
                this.consumer.accept(i);
                ++this.consumed;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Consumed event %s", event.getName()));
                }
            });
        }
    }

    @Override
    public void withMetrics(NuxeoMetricSet nuxeoMetrics) {
        nuxeoMetrics.putGauge(() -> this.handled, "events", new String[0]);
        nuxeoMetrics.putGauge(() -> this.consumed, "consumed", new String[0]);
    }
}

